/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.LoopMode;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.screen.Screen;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GuiEvent
extends AbstractCinematicEvent {
    private static final Logger log = Logger.getLogger(GuiEvent.class.getName());
    protected String screen;
    protected Nifty nifty;

    public GuiEvent() {
    }

    public GuiEvent(Nifty nifty, String screen) {
        this.screen = screen;
        this.nifty = nifty;
    }

    public GuiEvent(Nifty nifty, String screen, float initialDuration) {
        super(initialDuration);
        this.screen = screen;
        this.nifty = nifty;
    }

    public GuiEvent(Nifty nifty, String screen, LoopMode loopMode) {
        super(loopMode);
        this.screen = screen;
        this.nifty = nifty;
    }

    public GuiEvent(Nifty nifty, String screen, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.screen = screen;
        this.nifty = nifty;
    }

    public void onPlay() {
        log.log(Level.FINEST, "screen should be {0}", this.screen);
        this.nifty.gotoScreen(this.screen);
    }

    public void onStop() {
        Screen currentScreen = this.nifty.getCurrentScreen();
        if (currentScreen != null) {
            currentScreen.endScreen(null);
        }
    }

    public void onPause() {
    }

    public void setNifty(Nifty nifty) {
        this.nifty = nifty;
    }

    public void setScreen(String screen) {
        this.screen = screen;
    }

    public void onUpdate(float tpf) {
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.screen, "screen", "");
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.screen = ic.readString("screen", "");
    }
}

