/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.material;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.material.FbxMaterialProperties;
import com.jme3.scene.plugins.fbx.material.FbxTexture;
import com.jme3.scene.plugins.fbx.obj.FbxObject;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FbxMaterial
extends FbxObject<Material> {
    private static final Logger logger = Logger.getLogger(FbxMaterial.class.getName());
    private String shadingModel;
    private final FbxMaterialProperties properties = new FbxMaterialProperties();

    public FbxMaterial(AssetManager assetManager, String sceneFolderName) {
        super(assetManager, sceneFolderName);
    }

    @Override
    public void fromElement(FbxElement element) {
        super.fromElement(element);
        if (!this.getSubclassName().equals("")) {
            return;
        }
        FbxElement shadingModelEl = element.getChildById("ShadingModel");
        if (shadingModelEl != null) {
            this.shadingModel = (String)shadingModelEl.properties.get(0);
            if (!(this.shadingModel.equals("") || this.shadingModel.equalsIgnoreCase("phong") || this.shadingModel.equalsIgnoreCase("lambert"))) {
                logger.log(Level.WARNING, "FBX material uses unknown shading model: {0}. Material may display incorrectly.", this.shadingModel);
            }
        }
        for (FbxElement child : element.getFbxProperties()) {
            this.properties.setPropertyFromElement(child);
        }
    }

    @Override
    public void connectObject(FbxObject object) {
        this.unsupportedConnectObject(object);
    }

    @Override
    public void connectObjectProperty(FbxObject object, String property) {
        if (!(object instanceof FbxTexture)) {
            this.unsupportedConnectObjectProperty(object, property);
        }
        this.properties.setPropertyTexture(property, (FbxTexture)object);
    }

    private static void multRGB(ColorRGBA color, float factor) {
        color.r *= factor;
        color.g *= factor;
        color.b *= factor;
    }

    @Override
    protected Material toJmeObject() {
        Object aoColor;
        Object bumpNormal;
        Object shininessFactor;
        Object ambientFactor;
        Object ambientColor;
        Object emissiveFactor;
        Object emissiveColor;
        Object transparencyFactor;
        Object transparentColor;
        Object specularFactor;
        Object specularColor;
        Object diffuseFactor;
        ColorRGBA ambient = null;
        ColorRGBA diffuse = null;
        ColorRGBA specular = null;
        ColorRGBA transp = null;
        ColorRGBA emissive = null;
        float shininess = 1.0f;
        boolean separateTexCoord = false;
        Texture diffuseMap = null;
        Texture specularMap = null;
        Texture normalMap = null;
        Texture transpMap = null;
        Texture emitMap = null;
        Texture aoMap = null;
        FbxTexture fbxDiffuseMap = null;
        Object diffuseColor = this.properties.getProperty("DiffuseColor");
        if (diffuseColor != null) {
            if (diffuseColor instanceof ColorRGBA) {
                diffuse = ((ColorRGBA)diffuseColor).clone();
            } else if (diffuseColor instanceof FbxTexture) {
                FbxTexture tex;
                fbxDiffuseMap = tex = (FbxTexture)diffuseColor;
                diffuseMap = (Texture)tex.getJmeObject();
                diffuseMap.getImage().setColorSpace(ColorSpace.sRGB);
            }
        }
        if ((diffuseFactor = this.properties.getProperty("DiffuseFactor")) != null && diffuseFactor instanceof Float) {
            float factor = ((Float)diffuseFactor).floatValue();
            if (diffuse != null) {
                FbxMaterial.multRGB(diffuse, factor);
            } else {
                diffuse = new ColorRGBA(factor, factor, factor, 1.0f);
            }
        }
        if ((specularColor = this.properties.getProperty("SpecularColor")) != null) {
            if (specularColor instanceof ColorRGBA) {
                specular = ((ColorRGBA)specularColor).clone();
            } else if (specularColor instanceof FbxTexture) {
                FbxTexture tex = (FbxTexture)specularColor;
                specularMap = (Texture)tex.getJmeObject();
                specularMap.getImage().setColorSpace(ColorSpace.sRGB);
            }
        }
        if ((specularFactor = this.properties.getProperty("SpecularFactor")) != null && specularFactor instanceof Float) {
            float factor = ((Float)specularFactor).floatValue();
            if (specular != null) {
                FbxMaterial.multRGB(specular, factor);
            } else {
                specular = new ColorRGBA(factor, factor, factor, 1.0f);
            }
        }
        if ((transparentColor = this.properties.getProperty("TransparentColor")) != null) {
            if (transparentColor instanceof ColorRGBA) {
                transp = ((ColorRGBA)transparentColor).clone();
            } else if (transparentColor instanceof FbxTexture) {
                FbxTexture tex = (FbxTexture)transparentColor;
                transpMap = (Texture)tex.getJmeObject();
                transpMap.getImage().setColorSpace(ColorSpace.sRGB);
            }
        }
        if ((transparencyFactor = this.properties.getProperty("TransparencyFactor")) != null && transparencyFactor instanceof Float) {
            float factor = ((Float)transparencyFactor).floatValue();
            if (transp != null) {
                transp.a *= factor;
            } else {
                transp = new ColorRGBA(1.0f, 1.0f, 1.0f, factor);
            }
        }
        if ((emissiveColor = this.properties.getProperty("EmissiveColor")) != null) {
            if (emissiveColor instanceof ColorRGBA) {
                emissive = ((ColorRGBA)emissiveColor).clone();
            } else if (emissiveColor instanceof FbxTexture) {
                FbxTexture tex = (FbxTexture)emissiveColor;
                emitMap = (Texture)tex.getJmeObject();
                emitMap.getImage().setColorSpace(ColorSpace.sRGB);
            }
        }
        if ((emissiveFactor = this.properties.getProperty("EmissiveFactor")) != null && emissiveFactor instanceof Float) {
            float factor = ((Float)emissiveFactor).floatValue();
            if (emissive != null) {
                FbxMaterial.multRGB(emissive, factor);
            } else {
                emissive = new ColorRGBA(factor, factor, factor, 1.0f);
            }
        }
        if ((ambientColor = this.properties.getProperty("AmbientColor")) != null && ambientColor instanceof ColorRGBA) {
            ambient = ((ColorRGBA)ambientColor).clone();
        }
        if ((ambientFactor = this.properties.getProperty("AmbientFactor")) != null && ambientFactor instanceof Float) {
            float factor = ((Float)ambientFactor).floatValue();
            if (ambient != null) {
                FbxMaterial.multRGB(ambient, factor);
            } else {
                ambient = new ColorRGBA(factor, factor, factor, 1.0f);
            }
        }
        if ((shininessFactor = this.properties.getProperty("Shininess")) != null) {
            if (shininessFactor instanceof Float) {
                shininess = ((Float)shininessFactor).floatValue();
            } else if (shininessFactor instanceof FbxTexture) {
                // empty if block
            }
        }
        if ((bumpNormal = this.properties.getProperty("NormalMap")) != null && bumpNormal instanceof FbxTexture) {
            FbxTexture tex = (FbxTexture)bumpNormal;
            normalMap = (Texture)tex.getJmeObject();
            normalMap.getImage().setColorSpace(ColorSpace.Linear);
        }
        if ((aoColor = this.properties.getProperty("DiffuseColor2")) != null && aoColor instanceof FbxTexture) {
            FbxTexture tex = (FbxTexture)aoColor;
            if (tex.getUvSet() != null && fbxDiffuseMap != null && !tex.getUvSet().equals(fbxDiffuseMap.getUvSet())) {
                separateTexCoord = true;
            }
            aoMap = (Texture)tex.getJmeObject();
            aoMap.getImage().setColorSpace(ColorSpace.sRGB);
        }
        assert (ambient == null || ambient.a == 1.0f);
        assert (diffuse == null || diffuse.a == 1.0f);
        assert (specular == null || specular.a == 1.0f);
        assert (emissive == null || emissive.a == 1.0f);
        assert (transp == null || transp.r == 1.0f && transp.g == 1.0f && transp.b == 1.0f);
        if (shininess < 1.0f) {
            shininess = 1.0f;
            specular = ColorRGBA.Black;
        }
        boolean useAlphaBlend = false;
        if (diffuseMap != null && diffuseMap == transpMap) {
            useAlphaBlend = true;
            transpMap = null;
        } else if (diffuseMap != null && transpMap != null && diffuseMap != transpMap) {
            useAlphaBlend = true;
        } else if (transpMap != null) {
            useAlphaBlend = true;
        }
        if (transp != null && transp.a != 1.0f) {
            useAlphaBlend = true;
            if (diffuse != null) {
                diffuse.a = transp.a;
            } else {
                diffuse = transp;
            }
        }
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setName(this.name);
        mat.setReceivesShadows(true);
        if (useAlphaBlend) {
            mat.setTransparent(true);
            mat.setFloat("AlphaDiscardThreshold", 0.01f);
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        }
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        if (ambient != null || diffuse != null || specular != null) {
            mat.setBoolean("UseMaterialColors", true);
            mat.setColor("Ambient", ColorRGBA.White);
            mat.setColor("Diffuse", diffuse != null ? diffuse : ColorRGBA.White);
            mat.setColor("Specular", specular != null ? specular : ColorRGBA.Black);
        }
        if (emissive != null) {
            mat.setColor("GlowColor", emissive);
        }
        if (shininess > 1.0f) {
            float blinnShininess = shininess * 5.1f + 1.0f;
            mat.setFloat("Shininess", blinnShininess);
        }
        if (diffuseMap != null) {
            mat.setTexture("DiffuseMap", diffuseMap);
        }
        if (specularMap != null) {
            mat.setTexture("SpecularMap", specularMap);
        }
        if (normalMap != null) {
            mat.setTexture("NormalMap", normalMap);
        }
        if (transpMap != null) {
            // empty if block
        }
        if (emitMap != null) {
            mat.setTexture("GlowMap", emitMap);
        }
        if (aoMap != null) {
            mat.setTexture("LightMap", aoMap);
            if (separateTexCoord) {
                mat.setBoolean("SeparateTexCoord", true);
            }
        }
        return mat;
    }
}

