/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.ogre;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimTrack;
import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.TransformTrack;
import com.jme3.anim.util.AnimMigrationUtils;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.ogre.AnimData;
import com.jme3.scene.plugins.ogre.SceneLoader;
import com.jme3.util.xml.SAXUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SkeletonLoader
extends DefaultHandler
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(SceneLoader.class.getName());
    private Stack<String> elementStack = new Stack();
    private HashMap<Integer, Joint> indexToJoint = new HashMap();
    private HashMap<String, Joint> nameToJoint = new HashMap();
    private TransformTrack track;
    private ArrayList<TransformTrack> tracks = new ArrayList();
    private AnimClip animClip;
    private ArrayList<AnimClip> animClips;
    private Joint joint;
    private Armature armature;
    private ArrayList<Float> times = new ArrayList();
    private ArrayList<Vector3f> translations = new ArrayList();
    private ArrayList<Quaternion> rotations = new ArrayList();
    private ArrayList<Vector3f> scales = new ArrayList();
    private float time = -1.0f;
    private Vector3f position;
    private Quaternion rotation;
    private Vector3f scale;
    private float angle;
    private Vector3f axis;
    private List<Joint> unusedJoints = new ArrayList<Joint>();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
        if (qName.equals("position") || qName.equals("translate")) {
            this.position = SAXUtil.parseVector3((Attributes)attribs);
        } else if (qName.equals("rotation") || qName.equals("rotate")) {
            this.angle = SAXUtil.parseFloat((String)attribs.getValue("angle"));
        } else if (qName.equals("axis")) {
            assert (this.elementStack.peek().equals("rotation") || this.elementStack.peek().equals("rotate"));
            this.axis = SAXUtil.parseVector3((Attributes)attribs);
        } else if (qName.equals("scale")) {
            this.scale = SAXUtil.parseVector3((Attributes)attribs);
        } else if (qName.equals("keyframe")) {
            assert (this.elementStack.peek().equals("keyframes"));
            this.time = SAXUtil.parseFloat((String)attribs.getValue("time"));
        } else if (qName.equals("keyframes")) {
            assert (this.elementStack.peek().equals("track"));
        } else if (qName.equals("track")) {
            assert (this.elementStack.peek().equals("tracks"));
            String jointName = SAXUtil.parseString((String)attribs.getValue("bone"));
            this.joint = this.nameToJoint.get(jointName);
            this.track = new TransformTrack();
            this.track.setTarget((HasLocalTransform)this.joint);
        } else if (qName.equals("boneparent")) {
            assert (this.elementStack.peek().equals("bonehierarchy"));
            String jointName = attribs.getValue("bone");
            String parentName = attribs.getValue("parent");
            Joint joint = this.nameToJoint.get(jointName);
            Joint parent = this.nameToJoint.get(parentName);
            parent.addChild(joint);
        } else if (qName.equals("bone")) {
            assert (this.elementStack.peek().equals("bones"));
            this.joint = new Joint(attribs.getValue("name"));
            int id = SAXUtil.parseInt((String)attribs.getValue("id"));
            this.indexToJoint.put(id, this.joint);
            this.nameToJoint.put(this.joint.getName(), this.joint);
        } else if (qName.equals("tracks")) {
            assert (this.elementStack.peek().equals("animation"));
            this.tracks.clear();
            this.unusedJoints.clear();
            this.unusedJoints.addAll(this.nameToJoint.values());
        } else if (qName.equals("animation")) {
            assert (this.elementStack.peek().equals("animations"));
            String name = SAXUtil.parseString((String)attribs.getValue("name"));
            this.animClip = new AnimClip(name);
        } else if (qName.equals("bonehierarchy")) {
            assert (this.elementStack.peek().equals("skeleton"));
        } else if (qName.equals("animations")) {
            assert (this.elementStack.peek().equals("skeleton"));
            this.animClips = new ArrayList();
        } else if (qName.equals("bones") ? !$assertionsDisabled && !this.elementStack.peek().equals("skeleton") : qName.equals("skeleton") && !$assertionsDisabled && this.elementStack.size() != 0) {
            throw new AssertionError();
        }
        this.elementStack.add(qName);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (!(qName.equals("translate") || qName.equals("position") || qName.equals("scale") || qName.equals("axis"))) {
            if (qName.equals("rotate") || qName.equals("rotation")) {
                this.rotation = new Quaternion();
                this.axis.normalizeLocal();
                this.rotation.fromAngleNormalAxis(this.angle, this.axis);
                this.angle = 0.0f;
                this.axis = null;
            } else if (qName.equals("bone")) {
                this.joint.getLocalTransform().setTranslation(this.position);
                this.joint.getLocalTransform().setRotation(this.rotation);
                if (this.scale != null) {
                    this.joint.getLocalTransform().setScale(this.scale);
                }
                this.joint = null;
                this.position = null;
                this.rotation = null;
                this.scale = null;
            } else if (qName.equals("bonehierarchy")) {
                Joint[] joints = new Joint[this.indexToJoint.size()];
                for (Map.Entry<Integer, Joint> entry : this.indexToJoint.entrySet()) {
                    Joint joint;
                    joints[entry.getKey().intValue()] = joint = entry.getValue();
                }
                this.indexToJoint.clear();
                this.armature = new Armature(joints);
                this.armature.saveBindPose();
                this.armature.saveInitialPose();
            } else if (qName.equals("animation")) {
                this.animClips.add(this.animClip);
                this.animClip = null;
            } else if (qName.equals("track")) {
                if (this.track != null) {
                    this.tracks.add(this.track);
                    this.unusedJoints.remove(this.joint);
                    this.track = null;
                }
            } else if (qName.equals("tracks")) {
                for (Joint j : this.unusedJoints) {
                    AnimMigrationUtils.padJointTracks(this.tracks, (Joint)j);
                }
                TransformTrack[] trackList = this.tracks.toArray(new TransformTrack[this.tracks.size()]);
                this.animClip.setTracks((AnimTrack[])trackList);
                this.tracks.clear();
            } else if (qName.equals("keyframe")) {
                assert (this.time >= 0.0f);
                assert (this.position != null);
                assert (this.rotation != null);
                this.times.add(Float.valueOf(this.time));
                this.translations.add(this.position.addLocal(this.joint.getLocalTranslation()));
                this.rotations.add(this.joint.getLocalRotation().mult(this.rotation, this.rotation));
                if (this.scale != null) {
                    this.scales.add(this.scale.multLocal(this.joint.getLocalScale()));
                } else {
                    this.scales.add(new Vector3f(1.0f, 1.0f, 1.0f));
                }
                this.time = -1.0f;
                this.position = null;
                this.rotation = null;
                this.scale = null;
            } else if (qName.equals("keyframes")) {
                if (this.times.size() > 0) {
                    float[] timesArray = new float[this.times.size()];
                    for (int i = 0; i < timesArray.length; ++i) {
                        timesArray[i] = this.times.get(i).floatValue();
                    }
                    Vector3f[] transArray = this.translations.toArray(new Vector3f[this.translations.size()]);
                    Quaternion[] rotArray = this.rotations.toArray(new Quaternion[this.rotations.size()]);
                    Vector3f[] scalesArray = this.scales.toArray(new Vector3f[this.scales.size()]);
                    this.track.setKeyframes(timesArray, transArray, rotArray, scalesArray);
                } else {
                    this.track = null;
                }
                this.times.clear();
                this.translations.clear();
                this.rotations.clear();
                this.scales.clear();
            } else if (qName.equals("skeleton")) {
                this.nameToJoint.clear();
            }
        }
        assert (this.elementStack.peek().equals(qName));
        this.elementStack.pop();
    }

    private void fullReset() {
        this.elementStack.clear();
        this.indexToJoint.clear();
        this.nameToJoint.clear();
        this.track = null;
        this.tracks.clear();
        this.animClip = null;
        if (this.animClips != null) {
            this.animClips.clear();
        }
        this.joint = null;
        this.armature = null;
        this.times.clear();
        this.rotations.clear();
        this.translations.clear();
        this.time = -1.0f;
        this.position = null;
        this.rotation = null;
        this.scale = null;
        this.angle = 0.0f;
        this.axis = null;
    }

    public Object load(InputStream in) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader xr = factory.newSAXParser().getXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            InputStreamReader r = new InputStreamReader(in);
            xr.parse(new InputSource(r));
            if (this.animClips == null) {
                this.animClips = new ArrayList();
            }
            AnimData data = new AnimData(this.armature, this.animClips);
            this.armature = null;
            this.animClips = null;
            return data;
        }
        catch (ParserConfigurationException | SAXException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D dotScene");
            ioEx.initCause(ex);
            this.fullReset();
            throw ioEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo info) throws IOException {
        try (InputStream in = null;){
            in = info.openStream();
            Object object = this.load(in);
            return object;
        }
    }
}

