/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.anim;

import com.jme3.asset.AssetManager;
import com.jme3.scene.plugins.fbx.anim.FbxAnimLayer;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.obj.FbxObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FbxAnimStack
extends FbxObject {
    private static final Logger logger = Logger.getLogger(FbxAnimStack.class.getName());
    private float duration;
    private FbxAnimLayer layer0;

    public FbxAnimStack(AssetManager assetManager, String sceneFolderName) {
        super(assetManager, sceneFolderName);
    }

    @Override
    public void fromElement(FbxElement element) {
        super.fromElement(element);
        for (FbxElement child : element.getFbxProperties()) {
            String propName = (String)child.properties.get(0);
            if (!propName.equals("LocalStop")) continue;
            long durationLong = (Long)child.properties.get(4);
            this.duration = (float)((double)durationLong * 2.165150866196751E-11);
        }
    }

    public float getDuration() {
        return this.duration;
    }

    public FbxAnimLayer[] getLayers() {
        return new FbxAnimLayer[]{this.layer0};
    }

    protected Object toJmeObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectObject(FbxObject object) {
        if (!(object instanceof FbxAnimLayer)) {
            this.unsupportedConnectObject(object);
        }
        if (this.layer0 != null) {
            logger.log(Level.WARNING, "jME3 does not support layered animation. Only first layer has been loaded.");
            return;
        }
        this.layer0 = (FbxAnimLayer)object;
    }

    @Override
    public void connectObjectProperty(FbxObject object, String property) {
        this.unsupportedConnectObjectProperty(object, property);
    }
}

