/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.objects;

import com.jme3.asset.AssetLoadException;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.fbx.SceneLoader;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.objects.FbxCluster;
import com.jme3.scene.plugins.fbx.objects.FbxMesh;
import com.jme3.scene.plugins.fbx.objects.FbxNode;
import com.jme3.scene.plugins.fbx.objects.FbxObject;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class FbxSkin
extends FbxObject {
    public String skinningType;
    public List<FbxMesh> toSkin = new ArrayList<FbxMesh>();
    public List<FbxNode> bones = new ArrayList<FbxNode>();

    public FbxSkin(SceneLoader scene, FbxElement element) {
        super(scene, element);
        for (FbxElement e : element.children) {
            switch (e.id) {
                case "SkinningType": {
                    this.skinningType = (String)e.properties.get(0);
                }
            }
        }
    }

    @Override
    public void link(FbxObject otherObject) {
        if (otherObject instanceof FbxCluster) {
            FbxCluster cluster = (FbxCluster)otherObject;
            cluster.skin = this;
        }
    }

    public void generateSkinning() {
        for (FbxMesh fbxMesh : this.toSkin) {
            if (fbxMesh.geometries == null) continue;
            Mesh firstMesh = fbxMesh.geometries.get(0).getMesh();
            int maxWeightsPerVert = this.generateBoneData(firstMesh, fbxMesh);
            for (int i = 0; i < fbxMesh.geometries.size(); ++i) {
                Mesh mesh = fbxMesh.geometries.get(i).getMesh();
                if (mesh != firstMesh) {
                    mesh.setBuffer(firstMesh.getBuffer(VertexBuffer.Type.BoneWeight));
                    mesh.setBuffer(firstMesh.getBuffer(VertexBuffer.Type.BoneIndex));
                    mesh.setBuffer(firstMesh.getBuffer(VertexBuffer.Type.HWBoneWeight));
                    mesh.setBuffer(firstMesh.getBuffer(VertexBuffer.Type.HWBoneIndex));
                }
                mesh.setMaxNumWeights(maxWeightsPerVert);
                mesh.generateBindPose(true);
            }
        }
    }

    private int generateBoneData(Mesh mesh, FbxMesh fbxMesh) {
        FloatBuffer boneWeightData = BufferUtils.createFloatBuffer((int)(fbxMesh.vCount * 4));
        ByteBuffer boneIndicesData = BufferUtils.createByteBuffer((int)(fbxMesh.vCount * 4));
        mesh.setBuffer(VertexBuffer.Type.BoneWeight, 4, boneWeightData);
        mesh.setBuffer(VertexBuffer.Type.BoneIndex, 4, boneIndicesData);
        mesh.getBuffer(VertexBuffer.Type.BoneWeight).setUsage(VertexBuffer.Usage.CpuOnly);
        mesh.getBuffer(VertexBuffer.Type.BoneIndex).setUsage(VertexBuffer.Usage.CpuOnly);
        VertexBuffer weightsHW = new VertexBuffer(VertexBuffer.Type.HWBoneWeight);
        VertexBuffer indicesHW = new VertexBuffer(VertexBuffer.Type.HWBoneIndex);
        indicesHW.setUsage(VertexBuffer.Usage.CpuOnly);
        weightsHW.setUsage(VertexBuffer.Usage.CpuOnly);
        mesh.setBuffer(weightsHW);
        mesh.setBuffer(indicesHW);
        int bonesLimitExceeded = 0;
        for (FbxNode limb : this.bones) {
            FbxCluster cluster = limb.skinToCluster.get(this.id);
            if (cluster == null || cluster.indexes == null || cluster.weights == null || cluster.indexes.length != cluster.weights.length) continue;
            if (limb.boneIndex > 255) {
                throw new AssetLoadException("Bone index can't be packed into byte");
            }
            for (int i = 0; i < cluster.indexes.length; ++i) {
                int vertexIndex = cluster.indexes[i];
                if (vertexIndex >= fbxMesh.reverseVertexMap.size()) {
                    throw new AssetLoadException("Invalid skinning vertex index. Unexpected index lookup " + vertexIndex + " from " + fbxMesh.reverseVertexMap.size());
                }
                List<Integer> dstVertices = fbxMesh.reverseVertexMap.get(vertexIndex);
                for (int j = 0; j < dstVertices.size(); ++j) {
                    int offset;
                    int v = dstVertices.get(j);
                    int smallestOffset = 0;
                    float w = 0.0f;
                    float smallestW = Float.MAX_VALUE;
                    for (offset = v * 4; offset < v * 4 + 4 && (w = boneWeightData.get(offset)) != 0.0f; ++offset) {
                        if (!(w < smallestW)) continue;
                        smallestW = w;
                        smallestOffset = offset;
                    }
                    if (w == 0.0f) {
                        boneWeightData.put(offset, (float)cluster.weights[i]);
                        boneIndicesData.put(offset, (byte)limb.boneIndex);
                        continue;
                    }
                    if ((float)cluster.weights[i] > smallestW) {
                        boneWeightData.put(smallestOffset, (float)cluster.weights[i]);
                        boneIndicesData.put(smallestOffset, (byte)limb.boneIndex);
                    }
                    ++bonesLimitExceeded;
                }
            }
        }
        if (bonesLimitExceeded > 0) {
            this.scene.warning("Skinning support max 4 bone per vertex. Exceeding data of " + bonesLimitExceeded + " weights in mesh bones will be discarded");
        }
        int maxWeightsPerVert = 0;
        boneWeightData.rewind();
        for (int v = 0; v < fbxMesh.vCount; ++v) {
            float w0 = boneWeightData.get();
            float w1 = boneWeightData.get();
            float w2 = boneWeightData.get();
            float w3 = boneWeightData.get();
            if (w3 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 4);
            } else if (w2 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 3);
            } else if (w1 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 2);
            } else if (w0 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 1);
            }
            float sum = w0 + w1 + w2 + w3;
            if (sum == 1.0f) continue;
            float mult = sum != 0.0f ? 1.0f / sum : 0.0f;
            boneWeightData.position(v * 4);
            boneWeightData.put(w0 * mult);
            boneWeightData.put(w1 * mult);
            boneWeightData.put(w2 * mult);
            boneWeightData.put(w3 * mult);
        }
        return maxWeightsPerVert;
    }
}

