/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.anim;

import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.fbx.anim.FbxAnimCurve;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.node.FbxNode;
import com.jme3.scene.plugins.fbx.obj.FbxObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FbxAnimCurveNode
extends FbxObject {
    private static final Logger logger = Logger.getLogger(FbxAnimCurveNode.class.getName());
    private final Map<FbxNode, String> influencedNodePropertiesMap = new HashMap<FbxNode, String>();
    private final Map<String, FbxAnimCurve> propertyToCurveMap = new HashMap<String, FbxAnimCurve>();
    private final Map<String, Float> propertyToDefaultMap = new HashMap<String, Float>();

    public FbxAnimCurveNode(AssetManager assetManager, String sceneFolderName) {
        super(assetManager, sceneFolderName);
    }

    @Override
    public void fromElement(FbxElement element) {
        super.fromElement(element);
        for (FbxElement prop : element.getFbxProperties()) {
            String propName = (String)prop.properties.get(0);
            String propType = (String)prop.properties.get(1);
            if (!propType.equals("Number")) continue;
            float propValue = ((Double)prop.properties.get(4)).floatValue();
            this.propertyToDefaultMap.put(propName, Float.valueOf(propValue));
        }
    }

    public void addInfluencedNode(FbxNode node, String property) {
        this.influencedNodePropertiesMap.put(node, property);
    }

    public Map<FbxNode, String> getInfluencedNodeProperties() {
        return this.influencedNodePropertiesMap;
    }

    public Collection<FbxAnimCurve> getCurves() {
        return this.propertyToCurveMap.values();
    }

    public Vector3f getVector3Value(long time) {
        Vector3f value = new Vector3f();
        FbxAnimCurve xCurve = this.propertyToCurveMap.get("d|X");
        FbxAnimCurve yCurve = this.propertyToCurveMap.get("d|Y");
        FbxAnimCurve zCurve = this.propertyToCurveMap.get("d|Z");
        Float xDefault = this.propertyToDefaultMap.get("d|X");
        Float yDefault = this.propertyToDefaultMap.get("d|Y");
        Float zDefault = this.propertyToDefaultMap.get("d|Z");
        value.x = xCurve != null ? xCurve.getValueAtTime(time) : xDefault.floatValue();
        value.y = yCurve != null ? yCurve.getValueAtTime(time) : yDefault.floatValue();
        value.z = zCurve != null ? zCurve.getValueAtTime(time) : zDefault.floatValue();
        return value;
    }

    public Quaternion getQuaternionValue(long time) {
        Vector3f eulerAngles = this.getVector3Value(time);
        Quaternion q = new Quaternion();
        q.fromAngles(eulerAngles.x * ((float)Math.PI / 180), eulerAngles.y * ((float)Math.PI / 180), eulerAngles.z * ((float)Math.PI / 180));
        return q;
    }

    protected Object toJmeObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectObject(FbxObject object) {
        this.unsupportedConnectObject(object);
    }

    @Override
    public void connectObjectProperty(FbxObject object, String property) {
        if (!(object instanceof FbxAnimCurve)) {
            this.unsupportedConnectObjectProperty(object, property);
        }
        if (!(property.equals("d|X") || property.equals("d|Y") || property.equals("d|Z") || property.equals("d|Visibility"))) {
            logger.log(Level.WARNING, "Animating the dimension ''{0}'' is not supported yet. Ignoring.", property);
            return;
        }
        if (this.propertyToCurveMap.containsKey(property)) {
            throw new UnsupportedOperationException("!");
        }
        this.propertyToCurveMap.put(property, (FbxAnimCurve)object);
    }
}

