/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.jme3.asset.AssetLoadException;
import com.jme3.plugins.json.JsonArray;
import com.jme3.plugins.json.JsonElement;
import com.jme3.plugins.json.JsonObject;
import com.jme3.scene.plugins.gltf.ExtensionLoader;
import com.jme3.scene.plugins.gltf.ExtrasLoader;
import com.jme3.scene.plugins.gltf.GltfLoader;
import com.jme3.scene.plugins.gltf.GltfModelKey;
import com.jme3.scene.plugins.gltf.LightsPunctualExtensionLoader;
import com.jme3.scene.plugins.gltf.PBREmissiveStrengthExtensionLoader;
import com.jme3.scene.plugins.gltf.PBRSpecGlossExtensionLoader;
import com.jme3.scene.plugins.gltf.TextureTransformExtensionLoader;
import com.jme3.scene.plugins.gltf.UnlitExtensionLoader;
import com.jme3.scene.plugins.gltf.UserDataLoader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomContentManager {
    static volatile Class<? extends ExtrasLoader> defaultExtraLoaderClass = UserDataLoader.class;
    private ExtrasLoader defaultExtraLoaderInstance;
    private static final Logger logger = Logger.getLogger(CustomContentManager.class.getName());
    private GltfModelKey key;
    private GltfLoader gltfLoader;
    static final Map<String, Class<? extends ExtensionLoader>> defaultExtensionLoaders = new ConcurrentHashMap<String, Class<? extends ExtensionLoader>>();
    private final Map<String, ExtensionLoader> loadedExtensionLoaders = new HashMap<String, ExtensionLoader>();

    public ExtrasLoader getDefaultExtrasLoader() {
        if (defaultExtraLoaderClass == null) {
            this.defaultExtraLoaderInstance = null;
            return null;
        }
        if (this.defaultExtraLoaderInstance != null && this.defaultExtraLoaderInstance.getClass() != defaultExtraLoaderClass) {
            this.defaultExtraLoaderInstance = null;
        }
        try {
            this.defaultExtraLoaderInstance = defaultExtraLoaderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not instantiate default extras loader", e);
            this.defaultExtraLoaderInstance = null;
        }
        return this.defaultExtraLoaderInstance;
    }

    void init(GltfLoader gltfLoader) {
        JsonArray extensionRequired;
        JsonArray extensionUsed;
        this.gltfLoader = gltfLoader;
        if (gltfLoader.getInfo().getKey() instanceof GltfModelKey) {
            this.key = (GltfModelKey)gltfLoader.getInfo().getKey();
        }
        if ((extensionUsed = gltfLoader.getDocRoot().getAsJsonArray("extensionsUsed")) != null) {
            for (JsonElement extElem : extensionUsed) {
                String ext = extElem.getAsString();
                if (ext == null || defaultExtensionLoaders.get(ext) != null || this.key == null || this.key.getExtensionLoader(ext) != null) continue;
                logger.log(Level.WARNING, "Extension " + ext + " is not supported, please provide your own implementation in the GltfModelKey");
            }
        }
        if ((extensionRequired = gltfLoader.getDocRoot().getAsJsonArray("extensionsRequired")) != null) {
            for (JsonElement extElem : extensionRequired) {
                String ext = extElem.getAsString();
                if (ext == null || defaultExtensionLoaders.get(ext) != null || this.key == null || this.key.getExtensionLoader(ext) != null) continue;
                logger.log(Level.SEVERE, "Extension " + ext + " is mandatory for this file, the loaded scene result will be unexpected.");
            }
        }
    }

    public <T> T readExtensionAndExtras(String name, JsonElement el, T input) throws AssetLoadException, IOException {
        T output = this.readExtension(name, el, input);
        output = this.readExtras(name, el, output);
        return output;
    }

    private <T> T readExtension(String name, JsonElement el, T input) throws AssetLoadException, IOException {
        JsonObject extensions = el.getAsJsonObject().getAsJsonObject("extensions");
        if (extensions == null) {
            return input;
        }
        for (Map.Entry ext : extensions.getAsJsonObject().entrySet()) {
            ExtensionLoader loader = null;
            if (this.key != null) {
                loader = this.key.getExtensionLoader((String)ext.getKey());
            }
            if (loader == null && (loader = this.loadedExtensionLoaders.get(ext.getKey())) == null) {
                try {
                    Class<? extends ExtensionLoader> clz = defaultExtensionLoaders.get(ext.getKey());
                    if (clz != null) {
                        loader = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    logger.log(Level.WARNING, "Could not instantiate loader", e);
                }
                if (loader != null) {
                    this.loadedExtensionLoaders.put((String)ext.getKey(), loader);
                }
            }
            if (loader != null) {
                try {
                    return (T)loader.handleExtension(this.gltfLoader, name, el, (JsonElement)ext.getValue(), input);
                }
                catch (ClassCastException e) {
                    throw new AssetLoadException("Extension loader " + loader.getClass().getName() + " for extension " + (String)ext.getKey() + " is incompatible with type " + input.getClass(), (Throwable)e);
                }
            }
            logger.log(Level.WARNING, "Could not find loader for extension " + (String)ext.getKey());
        }
        return input;
    }

    private <T> T readExtras(String name, JsonElement el, T input) throws AssetLoadException {
        ExtrasLoader loader = null;
        if (this.key != null) {
            loader = this.key.getExtrasLoader();
        }
        if (loader == null) {
            loader = this.getDefaultExtrasLoader();
        }
        if (loader == null) {
            return input;
        }
        JsonObject extras = el.getAsJsonObject().getAsJsonObject("extras");
        if (extras == null) {
            return input;
        }
        try {
            return (T)loader.handleExtras(this.gltfLoader, name, el, (JsonElement)extras, input);
        }
        catch (ClassCastException e) {
            throw new AssetLoadException("Extra loader " + loader.getClass().getName() + " for " + name + " is incompatible with type " + input.getClass(), (Throwable)e);
        }
    }

    static {
        defaultExtensionLoaders.put("KHR_materials_pbrSpecularGlossiness", PBRSpecGlossExtensionLoader.class);
        defaultExtensionLoaders.put("KHR_lights_punctual", LightsPunctualExtensionLoader.class);
        defaultExtensionLoaders.put("KHR_materials_unlit", UnlitExtensionLoader.class);
        defaultExtensionLoaders.put("KHR_texture_transform", TextureTransformExtensionLoader.class);
        defaultExtensionLoaders.put("KHR_materials_emissive_strength", PBREmissiveStrengthExtensionLoader.class);
    }
}

