/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimComposer;
import com.jme3.anim.AnimTrack;
import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.MorphControl;
import com.jme3.anim.MorphTrack;
import com.jme3.anim.SkinningControl;
import com.jme3.anim.TransformTrack;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.plugins.json.JsonArray;
import com.jme3.plugins.json.JsonElement;
import com.jme3.plugins.json.JsonObject;
import com.jme3.plugins.json.JsonPrimitive;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.CameraControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.mesh.MorphTarget;
import com.jme3.scene.plugins.gltf.BinDataKey;
import com.jme3.scene.plugins.gltf.CustomContentManager;
import com.jme3.scene.plugins.gltf.ExtensionLoader;
import com.jme3.scene.plugins.gltf.ExtrasLoader;
import com.jme3.scene.plugins.gltf.GltfUtils;
import com.jme3.scene.plugins.gltf.MaterialAdapter;
import com.jme3.scene.plugins.gltf.PBRMetalRoughMaterialAdapter;
import com.jme3.scene.plugins.gltf.TrackData;
import com.jme3.scene.plugins.gltf.UserDataLoader;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.IntMap;
import com.jme3.util.mikktspace.MikktspaceTangentGenerator;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GltfLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(GltfLoader.class.getName());
    private final Map<String, Object[]> dataCache = new HashMap<String, Object[]>();
    private JsonArray scenes;
    private JsonArray nodes;
    private JsonArray meshes;
    private JsonArray accessors;
    private JsonArray bufferViews;
    private JsonArray buffers;
    private JsonArray materials;
    private JsonArray textures;
    private JsonArray images;
    private JsonArray samplers;
    private JsonArray animations;
    private JsonArray skins;
    private JsonArray cameras;
    private Material defaultMat;
    private AssetInfo info;
    private JsonObject docRoot;
    private Node rootNode;
    private final FloatArrayPopulator floatArrayPopulator = new FloatArrayPopulator();
    private final Vector3fArrayPopulator vector3fArrayPopulator = new Vector3fArrayPopulator();
    private final QuaternionArrayPopulator quaternionArrayPopulator = new QuaternionArrayPopulator();
    private final Matrix4fArrayPopulator matrix4fArrayPopulator = new Matrix4fArrayPopulator();
    private final Map<String, MaterialAdapter> defaultMaterialAdapters = new HashMap<String, MaterialAdapter>();
    private final CustomContentManager customContentManager = new CustomContentManager();
    private boolean useNormalsFlag = false;
    Map<SkinData, List<Spatial>> skinnedSpatials = new HashMap<SkinData, List<Spatial>>();
    IntMap<SkinBuffers> skinBuffers = new IntMap();

    public GltfLoader() {
        this.defaultMaterialAdapters.put("pbrMetallicRoughness", new PBRMetalRoughMaterialAdapter());
    }

    public Object load(AssetInfo assetInfo) throws IOException {
        return this.loadFromStream(assetInfo, assetInfo.openStream());
    }

    protected Object loadFromStream(AssetInfo assetInfo, InputStream stream) throws IOException {
        try {
            this.dataCache.clear();
            this.info = assetInfo;
            this.skinnedSpatials.clear();
            this.rootNode = new Node();
            if (this.defaultMat == null) {
                this.defaultMat = new Material(assetInfo.getManager(), "Common/MatDefs/Light/PBRLighting.j3md");
                this.defaultMat.setColor("BaseColor", ColorRGBA.White);
                this.defaultMat.setFloat("Metallic", 0.0f);
                this.defaultMat.setFloat("Roughness", 1.0f);
            }
            this.docRoot = GltfUtils.parse(stream);
            JsonObject asset = this.docRoot.getAsJsonObject().get("asset").getAsJsonObject();
            GltfUtils.getAsString(asset, "generator");
            String version = GltfUtils.getAsString(asset, "version");
            String minVersion = GltfUtils.getAsString(asset, "minVersion");
            if (!this.isSupported(version, minVersion)) {
                logger.log(Level.SEVERE, "Gltf Loader doesn''t support this gltf version: {0}{1}", new Object[]{version, minVersion != null ? "/" + minVersion : ""});
            }
            this.scenes = this.docRoot.getAsJsonArray("scenes");
            this.nodes = this.docRoot.getAsJsonArray("nodes");
            this.meshes = this.docRoot.getAsJsonArray("meshes");
            this.accessors = this.docRoot.getAsJsonArray("accessors");
            this.bufferViews = this.docRoot.getAsJsonArray("bufferViews");
            this.buffers = this.docRoot.getAsJsonArray("buffers");
            this.materials = this.docRoot.getAsJsonArray("materials");
            this.textures = this.docRoot.getAsJsonArray("textures");
            this.images = this.docRoot.getAsJsonArray("images");
            this.samplers = this.docRoot.getAsJsonArray("samplers");
            this.animations = this.docRoot.getAsJsonArray("animations");
            this.skins = this.docRoot.getAsJsonArray("skins");
            this.cameras = this.docRoot.getAsJsonArray("cameras");
            this.customContentManager.init(this);
            this.readSkins();
            this.readCameras();
            JsonPrimitive defaultScene = this.docRoot.getAsJsonPrimitive("scene");
            this.readScenes(defaultScene, this.rootNode);
            this.rootNode = this.customContentManager.readExtensionAndExtras("root", (JsonElement)this.docRoot, this.rootNode);
            if (this.animations != null) {
                for (int i = 0; i < this.animations.size(); ++i) {
                    this.readAnimation(i);
                }
            }
            this.setupControls();
            if (this.rootNode.getChildren().size() == 1) {
                Node child = (Node)this.rootNode.getChild(0);
                this.rootNode.getLocalLightList().forEach(arg_0 -> ((Node)child).addLight(arg_0));
                this.rootNode = child;
            }
            if (this.rootNode.getName() == null) {
                this.rootNode.setName(assetInfo.getKey().getName());
            }
            Node node = this.rootNode;
            return node;
        }
        catch (Exception e) {
            throw new AssetLoadException("An error occurred loading " + assetInfo.getKey().getName(), (Throwable)e);
        }
        finally {
            stream.close();
        }
    }

    private void setDefaultParams(Material mat) {
        mat.setColor("BaseColor", ColorRGBA.White);
        mat.setFloat("Metallic", 0.0f);
        mat.setFloat("Roughness", 1.0f);
    }

    private boolean isSupported(String version, String minVersion) {
        return "2.0".equals(version);
    }

    public void readScenes(JsonPrimitive defaultScene, Node rootNode) throws IOException {
        if (this.scenes == null) {
            throw new AssetLoadException("Gltf files with no scene is not yet supported");
        }
        for (JsonElement scene : this.scenes) {
            Node sceneNode = new Node();
            sceneNode.setCullHint(Spatial.CullHint.Always);
            sceneNode.setName(GltfUtils.getAsString(scene.getAsJsonObject(), "name"));
            if (!scene.getAsJsonObject().has("nodes")) continue;
            JsonArray sceneNodes = scene.getAsJsonObject().getAsJsonArray("nodes");
            sceneNode = this.customContentManager.readExtensionAndExtras("scene", scene, sceneNode);
            rootNode.attachChild((Spatial)sceneNode);
            for (JsonElement node : sceneNodes) {
                this.readChild((Spatial)sceneNode, node);
            }
        }
        int activeChild = 0;
        if (defaultScene != null) {
            activeChild = defaultScene.getAsInt();
        }
        rootNode.getChild(activeChild).setCullHint(Spatial.CullHint.Inherit);
    }

    public Object readNode(int nodeIndex) throws IOException {
        SkinData skinData;
        Node spatial;
        Node node;
        Object obj = this.fetchFromCache("nodes", nodeIndex, Object.class);
        if (obj != null) {
            if (obj instanceof JointWrapper) {
                return obj;
            }
            return ((Spatial)obj).clone();
        }
        JsonObject nodeData = this.nodes.get(nodeIndex).getAsJsonObject();
        JsonArray children = nodeData.getAsJsonArray("children");
        Integer meshIndex = GltfUtils.getAsInteger(nodeData, "mesh");
        if (meshIndex != null) {
            GltfUtils.assertNotNull(this.meshes, "Can't find any mesh data, yet a node references a mesh");
            Geometry[] primitives = this.readMeshPrimitives(meshIndex);
            node = new Node();
            for (Geometry primitive : primitives) {
                node.attachChild((Spatial)primitive);
            }
            node.setName(this.readMeshName(meshIndex));
            spatial = new Node();
            spatial.attachChild((Spatial)node);
        } else {
            Integer camIndex = GltfUtils.getAsInteger(nodeData, "camera");
            if (camIndex != null) {
                Camera cam = this.fetchFromCache("cameras", camIndex, Camera.class);
                CameraNode node2 = new CameraNode(null, cam);
                node2.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
                spatial = node2;
            } else {
                spatial = node = new Node();
            }
        }
        Integer skinIndex = GltfUtils.getAsInteger(nodeData, "skin");
        if (skinIndex != null && (skinData = this.fetchFromCache("skins", skinIndex, SkinData.class)) != null) {
            List<Spatial> spatials = this.skinnedSpatials.get(skinData);
            spatials.add((Spatial)spatial);
            skinData.used = true;
        }
        spatial.setLocalTransform(this.readTransforms(nodeData));
        if (spatial.getName() == null) {
            spatial.setName(GltfUtils.getAsString(nodeData.getAsJsonObject(), "name"));
        }
        spatial = (Spatial)this.customContentManager.readExtensionAndExtras("node", (JsonElement)nodeData, spatial);
        this.addToCache("nodes", nodeIndex, spatial, this.nodes.size());
        return spatial;
    }

    private void readChild(Spatial parent, JsonElement nodeIndex) throws IOException {
        Object loaded = this.readNode(nodeIndex.getAsInt());
        if (loaded instanceof Spatial) {
            Spatial spatial = (Spatial)loaded;
            ((Node)parent).attachChild(spatial);
            JsonObject nodeElem = this.nodes.get(nodeIndex.getAsInt()).getAsJsonObject();
            JsonArray children = nodeElem.getAsJsonArray("children");
            if (children != null) {
                for (JsonElement child : children) {
                    this.readChild(spatial, child);
                }
            }
        } else if (loaded instanceof JointWrapper) {
            JointWrapper bw = (JointWrapper)loaded;
            bw.isRoot = true;
            SkinData skinData = this.fetchFromCache("skins", bw.skinIndex, SkinData.class);
            if (skinData == null) {
                return;
            }
            skinData.parent = parent;
        }
    }

    public Transform readTransforms(JsonObject nodeData) {
        JsonArray scale;
        JsonArray rotation;
        Transform transform = new Transform();
        JsonArray matrix = nodeData.getAsJsonArray("matrix");
        if (matrix != null) {
            float[] tmpArray = new float[16];
            for (int i = 0; i < tmpArray.length; ++i) {
                tmpArray[i] = matrix.get(i).getAsFloat();
            }
            Matrix4f mat = new Matrix4f(tmpArray);
            transform.fromTransformMatrix(mat);
            return transform;
        }
        JsonArray translation = nodeData.getAsJsonArray("translation");
        if (translation != null) {
            transform.setTranslation(translation.get(0).getAsFloat(), translation.get(1).getAsFloat(), translation.get(2).getAsFloat());
        }
        if ((rotation = nodeData.getAsJsonArray("rotation")) != null) {
            transform.setRotation(new Quaternion(rotation.get(0).getAsFloat(), rotation.get(1).getAsFloat(), rotation.get(2).getAsFloat(), rotation.get(3).getAsFloat()));
        }
        if ((scale = nodeData.getAsJsonArray("scale")) != null) {
            transform.setScale(scale.get(0).getAsFloat(), scale.get(1).getAsFloat(), scale.get(2).getAsFloat());
        }
        return transform;
    }

    public Geometry[] readMeshPrimitives(int meshIndex) throws IOException {
        Geometry[] geomArray = (Geometry[])this.fetchFromCache("meshes", meshIndex, Object.class);
        if (geomArray == null) {
            JsonObject meshData = this.meshes.get(meshIndex).getAsJsonObject();
            JsonArray primitives = meshData.getAsJsonArray("primitives");
            GltfUtils.assertNotNull(primitives, "Can't find any primitives in mesh " + meshIndex);
            String name = GltfUtils.getAsString(meshData, "name");
            geomArray = new Geometry[primitives.size()];
            int index = 0;
            for (JsonElement primitive : primitives) {
                JsonArray targets;
                JsonObject meshObject = primitive.getAsJsonObject();
                Mesh mesh = new Mesh();
                this.addToCache("mesh", 0, mesh, 1);
                Integer mode = GltfUtils.getAsInteger(meshObject, "mode");
                mesh.setMode(GltfUtils.getMeshMode(mode));
                Integer indices = GltfUtils.getAsInteger(meshObject, "indices");
                if (indices != null) {
                    mesh.setBuffer(this.readAccessorData(indices, new VertexBufferPopulator(VertexBuffer.Type.Index)));
                }
                JsonObject attributes = meshObject.getAsJsonObject("attributes");
                GltfUtils.assertNotNull(attributes, "No attributes defined for mesh " + mesh);
                boolean useVertexColors = false;
                this.skinBuffers.clear();
                for (Map.Entry entry : attributes.entrySet()) {
                    SkinBuffers buffs;
                    String bufferType = (String)entry.getKey();
                    if (bufferType.startsWith("JOINTS")) {
                        buffs = this.getSkinBuffers(bufferType);
                        SkinBuffers buffer = this.readAccessorData(((JsonElement)entry.getValue()).getAsInt(), new JointArrayPopulator());
                        buffs.joints = buffer.joints;
                        buffs.componentSize = buffer.componentSize;
                    } else if (bufferType.startsWith("WEIGHTS")) {
                        buffs = this.getSkinBuffers(bufferType);
                        buffs.weights = this.readAccessorData(((JsonElement)entry.getValue()).getAsInt(), new FloatArrayPopulator());
                    } else {
                        VertexBuffer vb = this.readAccessorData(((JsonElement)entry.getValue()).getAsInt(), new VertexBufferPopulator(GltfUtils.getVertexBufferType(bufferType)));
                        if (vb != null) {
                            mesh.setBuffer(vb);
                        }
                    }
                    if (!bufferType.startsWith("COLOR")) continue;
                    useVertexColors = true;
                }
                GltfUtils.handleSkinningBuffers(mesh, this.skinBuffers);
                if (mesh.getBuffer(VertexBuffer.Type.BoneIndex) != null) {
                    VertexBuffer weightsHW = new VertexBuffer(VertexBuffer.Type.HWBoneWeight);
                    VertexBuffer indicesHW = new VertexBuffer(VertexBuffer.Type.HWBoneIndex);
                    indicesHW.setUsage(VertexBuffer.Usage.CpuOnly);
                    weightsHW.setUsage(VertexBuffer.Usage.CpuOnly);
                    mesh.setBuffer(weightsHW);
                    mesh.setBuffer(indicesHW);
                    mesh.generateBindPose();
                }
                LinkedList<String> targetNames = new LinkedList<String>();
                if (meshData.has("extras") && meshData.getAsJsonObject("extras").has("targetNames")) {
                    JsonArray targetNamesJson = meshData.getAsJsonObject("extras").getAsJsonArray("targetNames");
                    for (JsonElement target : targetNamesJson) {
                        targetNames.add(target.getAsString());
                    }
                }
                if ((targets = meshObject.getAsJsonArray("targets")) != null) {
                    for (JsonElement target : targets) {
                        MorphTarget morphTarget = new MorphTarget();
                        if (targetNames.size() > 0) {
                            morphTarget.setName((String)targetNames.pop());
                        }
                        for (Map.Entry entry : target.getAsJsonObject().entrySet()) {
                            String bufferType = (String)entry.getKey();
                            VertexBuffer.Type type = GltfUtils.getVertexBufferType(bufferType);
                            VertexBuffer vb = this.readAccessorData(((JsonElement)entry.getValue()).getAsInt(), new VertexBufferPopulator(type));
                            if (vb == null) continue;
                            morphTarget.setBuffer(type, (FloatBuffer)vb.getData());
                        }
                        mesh.addMorphTarget(morphTarget);
                    }
                }
                mesh = this.customContentManager.readExtensionAndExtras("primitive", (JsonElement)meshObject, mesh);
                Geometry geom = new Geometry(null, mesh);
                Integer materialIndex = GltfUtils.getAsInteger(meshObject, "material");
                if (materialIndex == null) {
                    geom.setMaterial(this.defaultMat);
                } else {
                    this.useNormalsFlag = false;
                    geom.setMaterial(this.readMaterial(materialIndex));
                    if (geom.getMaterial().getAdditionalRenderState().getBlendMode() == RenderState.BlendMode.Alpha) {
                        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
                    }
                    if (this.useNormalsFlag && mesh.getBuffer(VertexBuffer.Type.Tangent) == null) {
                        MikktspaceTangentGenerator.generate((Spatial)geom);
                    }
                }
                if (useVertexColors) {
                    geom.getMaterial().setBoolean("UseVertexColor", useVertexColors);
                }
                geom.setName(name + "_" + index);
                geom.updateModelBound();
                geomArray[index] = geom;
                ++index;
            }
            geomArray = this.customContentManager.readExtensionAndExtras("mesh", (JsonElement)meshData, geomArray);
            this.addToCache("meshes", meshIndex, geomArray, this.meshes.size());
        }
        Geometry[] geoms = new Geometry[geomArray.length];
        for (int i = 0; i < geoms.length; ++i) {
            geoms[i] = geomArray[i].clone(false);
        }
        return geoms;
    }

    private SkinBuffers getSkinBuffers(String bufferType) {
        int bufIndex = GltfUtils.getIndex(bufferType);
        SkinBuffers buffs = (SkinBuffers)this.skinBuffers.get(bufIndex);
        if (buffs == null) {
            buffs = new SkinBuffers();
            this.skinBuffers.put(bufIndex, (Object)buffs);
        }
        return buffs;
    }

    private <R> R readAccessorData(int accessorIndex, Populator<R> populator) throws IOException {
        GltfUtils.assertNotNull(this.accessors, "No accessor attribute in the gltf file");
        JsonObject accessor = this.accessors.get(accessorIndex).getAsJsonObject();
        Integer bufferViewIndex = GltfUtils.getAsInteger(accessor, "bufferView");
        int byteOffset = GltfUtils.getAsInteger(accessor, "byteOffset", 0);
        Integer componentType = GltfUtils.getAsInteger(accessor, "componentType");
        GltfUtils.assertNotNull(componentType, "No component type defined for accessor " + accessorIndex);
        Integer count = GltfUtils.getAsInteger(accessor, "count");
        GltfUtils.assertNotNull(count, "No count attribute defined for accessor " + accessorIndex);
        String type = GltfUtils.getAsString(accessor, "type");
        GltfUtils.assertNotNull(type, "No type attribute defined for accessor " + accessorIndex);
        boolean normalized = GltfUtils.getAsBoolean(accessor, "normalized", false);
        R data = populator.populate(bufferViewIndex, componentType, type, count, byteOffset, normalized);
        data = this.customContentManager.readExtensionAndExtras("accessor", (JsonElement)accessor, data);
        return data;
    }

    public Object readBuffer(Integer bufferViewIndex, int byteOffset, int count, Object store, int numComponents, VertexBuffer.Format format) throws IOException {
        JsonObject bufferView = this.bufferViews.get(bufferViewIndex.intValue()).getAsJsonObject();
        Integer bufferIndex = GltfUtils.getAsInteger(bufferView, "buffer");
        GltfUtils.assertNotNull(bufferIndex, "No buffer defined for bufferView " + bufferViewIndex);
        int bvByteOffset = GltfUtils.getAsInteger(bufferView, "byteOffset", 0);
        Integer byteLength = GltfUtils.getAsInteger(bufferView, "byteLength");
        GltfUtils.assertNotNull(byteLength, "No byte length defined for bufferView " + bufferViewIndex);
        int byteStride = GltfUtils.getAsInteger(bufferView, "byteStride", 0);
        byte[] data = this.readData(bufferIndex);
        data = this.customContentManager.readExtensionAndExtras("bufferView", (JsonElement)bufferView, data);
        if (store == null) {
            store = new byte[byteLength.intValue()];
        }
        if (count == -1) {
            count = byteLength;
        }
        GltfUtils.populateBuffer(store, data, count, byteOffset + bvByteOffset, byteStride, numComponents, format);
        return store;
    }

    public byte[] readData(int bufferIndex) throws IOException {
        GltfUtils.assertNotNull(this.buffers, "No buffer defined");
        JsonObject buffer = this.buffers.get(bufferIndex).getAsJsonObject();
        String uri = GltfUtils.getAsString(buffer, "uri");
        Integer bufferLength = GltfUtils.getAsInteger(buffer, "byteLength");
        GltfUtils.assertNotNull(bufferLength, "No byteLength defined for buffer " + bufferIndex);
        byte[] data = (byte[])this.fetchFromCache("buffers", bufferIndex, Object.class);
        if (data != null) {
            return data;
        }
        data = this.getBytes(bufferIndex, uri, bufferLength);
        data = this.customContentManager.readExtensionAndExtras("buffer", (JsonElement)buffer, data);
        this.addToCache("buffers", bufferIndex, data, this.buffers.size());
        return data;
    }

    protected byte[] getBytes(int bufferIndex, String uri, Integer bufferLength) throws IOException {
        byte[] data;
        if (uri != null) {
            if (uri.startsWith("data:")) {
                data = Base64.getDecoder().decode(uri.substring(uri.indexOf(",") + 1));
            } else {
                String decoded = this.decodeUri(uri);
                if (!decoded.endsWith(".bin")) {
                    throw new AssetLoadException("Cannot load " + decoded + ", a .bin extension is required.");
                }
                BinDataKey key = new BinDataKey(this.info.getKey().getFolder() + decoded);
                InputStream input = (InputStream)this.info.getManager().loadAsset((AssetKey)key);
                data = new byte[bufferLength.intValue()];
                try (DataInputStream dataStream = new DataInputStream(input);){
                    dataStream.readFully(data);
                }
            }
        } else {
            throw new AssetLoadException("Buffer " + bufferIndex + " has no uri");
        }
        return data;
    }

    public Material readMaterial(int materialIndex) throws IOException {
        Float occlusionStrength;
        JsonObject occlusionJson;
        Integer occlusionIndex;
        GltfUtils.assertNotNull(this.materials, "There is no material defined yet a mesh references one");
        Material material = this.fetchFromCache("materials", materialIndex, Material.class);
        if (material != null) {
            return material.clone();
        }
        JsonObject matData = this.materials.get(materialIndex).getAsJsonObject();
        JsonObject pbrMat = matData.getAsJsonObject("pbrMetallicRoughness");
        MaterialAdapter adapter = null;
        if (pbrMat != null) {
            adapter = GltfUtils.getAdapterForMaterial(this.info, "pbrMetallicRoughness");
            if (adapter == null) {
                adapter = this.defaultMaterialAdapters.get("pbrMetallicRoughness");
            }
            adapter.init(this.info.getManager());
        }
        if ((adapter = this.customContentManager.readExtensionAndExtras("material", (JsonElement)matData, adapter)) == null) {
            logger.log(Level.WARNING, "Couldn't find any matching material definition for material " + materialIndex);
            adapter = this.defaultMaterialAdapters.get("pbrMetallicRoughness");
            adapter.init(this.info.getManager());
            this.setDefaultParams(adapter.getMaterial());
        }
        Integer metallicRoughnessIndex = null;
        if (pbrMat != null) {
            adapter.setParam("baseColorFactor", GltfUtils.getAsColor(pbrMat, "baseColorFactor", ColorRGBA.White));
            adapter.setParam("metallicFactor", GltfUtils.getAsFloat(pbrMat, "metallicFactor", 1.0f));
            adapter.setParam("roughnessFactor", GltfUtils.getAsFloat(pbrMat, "roughnessFactor", 1.0f));
            adapter.setParam("baseColorTexture", this.readTexture(pbrMat.getAsJsonObject("baseColorTexture")));
            adapter.setParam("metallicRoughnessTexture", this.readTexture(pbrMat.getAsJsonObject("metallicRoughnessTexture")));
            JsonObject metallicRoughnessJson = pbrMat.getAsJsonObject("metallicRoughnessTexture");
            metallicRoughnessIndex = metallicRoughnessJson != null ? GltfUtils.getAsInteger(metallicRoughnessJson, "index") : null;
        }
        adapter.getMaterial().setName(GltfUtils.getAsString(matData, "name"));
        adapter.setParam("emissiveFactor", GltfUtils.getAsColor(matData, "emissiveFactor", ColorRGBA.Black));
        String alphaMode = GltfUtils.getAsString(matData, "alphaMode");
        adapter.setParam("alphaMode", alphaMode);
        if (alphaMode != null && alphaMode.equals("MASK")) {
            adapter.setParam("alphaCutoff", GltfUtils.getAsFloat(matData, "alphaCutoff"));
        }
        adapter.setParam("doubleSided", GltfUtils.getAsBoolean(matData, "doubleSided"));
        Texture2D normal = this.readTexture(matData.getAsJsonObject("normalTexture"));
        adapter.setParam("normalTexture", normal);
        if (normal != null) {
            this.useNormalsFlag = true;
            JsonObject normalTexture = matData.getAsJsonObject("normalTexture");
            Float normalScale = GltfUtils.getAsFloat(normalTexture, "scale");
            if (normalScale != null) {
                adapter.setParam("normalScale", normalScale);
            }
        }
        Integer n = occlusionIndex = (occlusionJson = matData.getAsJsonObject("occlusionTexture")) != null ? GltfUtils.getAsInteger(occlusionJson, "index") : null;
        if (occlusionIndex != null && occlusionIndex.equals(metallicRoughnessIndex)) {
            adapter.getMaterial().setBoolean("AoPackedInMRMap", true);
        } else {
            adapter.setParam("occlusionTexture", this.readTexture(matData.getAsJsonObject("occlusionTexture")));
        }
        Float f = occlusionStrength = occlusionJson != null ? GltfUtils.getAsFloat(occlusionJson, "strength") : null;
        if (occlusionStrength != null) {
            adapter.setParam("occlusionStrength", occlusionStrength);
        }
        adapter.setParam("emissiveTexture", this.readTexture(matData.getAsJsonObject("emissiveTexture")));
        material = adapter.getMaterial();
        this.addToCache("materials", materialIndex, material, this.materials.size());
        return material;
    }

    public void readCameras() throws IOException {
        if (this.cameras == null) {
            return;
        }
        for (int i = 0; i < this.cameras.size(); ++i) {
            Float zFar;
            Float zNear;
            Camera cam = new Camera(1, 1);
            JsonObject camObj = this.cameras.get(i).getAsJsonObject();
            String type = GltfUtils.getAsString(camObj, "type");
            GltfUtils.assertNotNull(type, "No type defined for camera");
            JsonObject camData = camObj.getAsJsonObject(type);
            if (type.equals("perspective")) {
                float aspectRatio = GltfUtils.getAsFloat(camData, "aspectRation", 1.0f).floatValue();
                Float yfov = GltfUtils.getAsFloat(camData, "yfov");
                GltfUtils.assertNotNull(yfov, "No yfov for perspective camera");
                zNear = GltfUtils.getAsFloat(camData, "znear");
                GltfUtils.assertNotNull(zNear, "No znear for perspective camera");
                zFar = GltfUtils.getAsFloat(camData, "zfar", zNear.floatValue() * 1000.0f);
                cam.setFrustumPerspective(yfov.floatValue() * 57.295776f, aspectRatio, zNear.floatValue(), zFar.floatValue());
                cam = this.customContentManager.readExtensionAndExtras("camera.perspective", (JsonElement)camData, cam);
            } else {
                Float xmag = GltfUtils.getAsFloat(camData, "xmag");
                GltfUtils.assertNotNull(xmag, "No xmag for orthographic camera");
                Float ymag = GltfUtils.getAsFloat(camData, "ymag");
                GltfUtils.assertNotNull(ymag, "No ymag for orthographic camera");
                zNear = GltfUtils.getAsFloat(camData, "znear");
                GltfUtils.assertNotNull(zNear, "No znear for orthographic camera");
                zFar = GltfUtils.getAsFloat(camData, "zfar", zNear.floatValue() * 1000.0f);
                GltfUtils.assertNotNull(zFar, "No zfar for orthographic camera");
                cam.setParallelProjection(true);
                cam.setFrustum(zNear.floatValue(), zFar.floatValue(), -xmag.floatValue(), xmag.floatValue(), ymag.floatValue(), -ymag.floatValue());
                cam = this.customContentManager.readExtensionAndExtras("camera.orthographic", (JsonElement)camData, cam);
            }
            cam = this.customContentManager.readExtensionAndExtras("camera", (JsonElement)camObj, cam);
            this.addToCache("cameras", i, cam, this.cameras.size());
        }
    }

    public Texture2D readTexture(JsonObject texture) throws IOException {
        return this.readTexture(texture, false);
    }

    public Texture2D readTexture(JsonObject texture, boolean flip) throws IOException {
        if (texture == null) {
            return null;
        }
        Integer textureIndex = GltfUtils.getAsInteger(texture, "index");
        GltfUtils.assertNotNull(textureIndex, "Texture has no index");
        GltfUtils.assertNotNull(this.textures, "There are no textures, yet one is referenced by a material");
        Texture2D texture2d = this.fetchFromCache("textures", textureIndex, Texture2D.class);
        if (texture2d != null) {
            return texture2d;
        }
        JsonObject textureData = this.textures.get(textureIndex.intValue()).getAsJsonObject();
        Integer sourceIndex = GltfUtils.getAsInteger(textureData, "source");
        Integer samplerIndex = GltfUtils.getAsInteger(textureData, "sampler");
        texture2d = this.readImage(sourceIndex, flip);
        if (samplerIndex != null) {
            texture2d = this.readSampler(samplerIndex, texture2d);
        } else {
            texture2d.setWrap(Texture.WrapMode.Repeat);
        }
        texture2d = this.customContentManager.readExtensionAndExtras("texture", (JsonElement)texture, texture2d);
        this.addToCache("textures", textureIndex, texture2d, this.textures.size());
        return texture2d;
    }

    public Texture2D readImage(int sourceIndex, boolean flip) throws IOException {
        Texture2D result;
        if (this.images == null) {
            throw new AssetLoadException("No image defined");
        }
        JsonObject image = this.images.get(sourceIndex).getAsJsonObject();
        String uri = GltfUtils.getAsString(image, "uri");
        Integer bufferView = GltfUtils.getAsInteger(image, "bufferView");
        String mimeType = GltfUtils.getAsString(image, "mimeType");
        if (uri == null) {
            GltfUtils.assertNotNull(bufferView, "Image " + sourceIndex + " should either have an uri or a bufferView");
            GltfUtils.assertNotNull(mimeType, "Image " + sourceIndex + " should have a mimeType");
            byte[] data = (byte[])this.readBuffer(bufferView, 0, -1, null, 1, VertexBuffer.Format.Byte);
            String extension = mimeType.split("/")[1];
            TextureKey key = new TextureKey("image" + sourceIndex + "." + extension, flip);
            result = (Texture2D)this.info.getManager().loadAssetFromStream((AssetKey)key, (InputStream)new ByteArrayInputStream(data));
        } else if (uri.startsWith("data:")) {
            String[] uriInfo = uri.split(",");
            byte[] data = Base64.getDecoder().decode(uriInfo[1]);
            String headerInfo = uriInfo[0].split(";")[0];
            String extension = headerInfo.split("/")[1];
            TextureKey key = new TextureKey("image" + sourceIndex + "." + extension, flip);
            result = (Texture2D)this.info.getManager().loadAssetFromStream((AssetKey)key, (InputStream)new ByteArrayInputStream(data));
        } else {
            String decoded = this.decodeUri(uri);
            TextureKey key = new TextureKey(this.info.getKey().getFolder() + decoded, flip);
            Texture tex = this.info.getManager().loadTexture(key);
            result = (Texture2D)tex;
        }
        return result;
    }

    public void readAnimation(int animationIndex) throws IOException {
        Quaternion[] rotations;
        JsonObject animation = this.animations.get(animationIndex).getAsJsonObject();
        JsonArray channels = animation.getAsJsonArray("channels");
        JsonArray samplers = animation.getAsJsonArray("samplers");
        String name = GltfUtils.getAsString(animation, "name");
        GltfUtils.assertNotNull(channels, "No channels for animation " + name);
        GltfUtils.assertNotNull(samplers, "No samplers for animation " + name);
        TrackData[] tracks = new TrackData[this.nodes.size()];
        boolean hasMorphTrack = false;
        for (JsonElement channel : channels) {
            JsonObject target = channel.getAsJsonObject().getAsJsonObject("target");
            Integer targetNode = GltfUtils.getAsInteger(target, "node");
            String targetPath = GltfUtils.getAsString(target, "path");
            if (targetNode == null) continue;
            GltfUtils.assertNotNull(targetPath, "No target path for channel");
            TrackData trackData = tracks[targetNode];
            if (trackData == null) {
                tracks[targetNode.intValue()] = trackData = new TrackData();
            }
            Integer samplerIndex = GltfUtils.getAsInteger(channel.getAsJsonObject(), "sampler");
            GltfUtils.assertNotNull(samplerIndex, "No animation sampler provided for channel");
            JsonObject sampler = samplers.get(samplerIndex.intValue()).getAsJsonObject();
            Integer timeIndex = GltfUtils.getAsInteger(sampler, "input");
            GltfUtils.assertNotNull(timeIndex, "No input accessor Provided for animation sampler");
            Integer dataIndex = GltfUtils.getAsInteger(sampler, "output");
            GltfUtils.assertNotNull(dataIndex, "No output accessor Provided for animation sampler");
            String interpolation = GltfUtils.getAsString(sampler, "interpolation");
            if (interpolation == null || !interpolation.equals("LINEAR")) {
                logger.log(Level.WARNING, "JME only supports linear interpolation for animations");
            }
            trackData = this.customContentManager.readExtensionAndExtras("animation.sampler", (JsonElement)sampler, trackData);
            float[] times = this.fetchFromCache("accessors", timeIndex, float[].class);
            if (times == null) {
                times = this.readAccessorData(timeIndex, this.floatArrayPopulator);
                this.addToCache("accessors", timeIndex, times, this.accessors.size());
            }
            if (targetPath.equals("translation")) {
                trackData.timeArrays.add(new TrackData.TimeData(times, TrackData.Type.Translation));
                Vector3f[] translations = this.readAccessorData(dataIndex, this.vector3fArrayPopulator);
                trackData.translations = translations;
            } else if (targetPath.equals("scale")) {
                trackData.timeArrays.add(new TrackData.TimeData(times, TrackData.Type.Scale));
                Vector3f[] scales = this.readAccessorData(dataIndex, this.vector3fArrayPopulator);
                trackData.scales = scales;
            } else if (targetPath.equals("rotation")) {
                trackData.timeArrays.add(new TrackData.TimeData(times, TrackData.Type.Rotation));
                rotations = this.readAccessorData(dataIndex, this.quaternionArrayPopulator);
                trackData.rotations = rotations;
            } else {
                trackData.timeArrays.add(new TrackData.TimeData(times, TrackData.Type.Morph));
                float[] weights = this.readAccessorData(dataIndex, this.floatArrayPopulator);
                trackData.weights = weights;
                hasMorphTrack = true;
            }
            tracks[targetNode.intValue()] = this.customContentManager.readExtensionAndExtras("channel", channel, trackData);
        }
        if (name == null) {
            name = "anim_" + animationIndex;
        }
        ArrayList<Spatial> spatials = new ArrayList<Spatial>();
        AnimClip anim = new AnimClip(name);
        ArrayList<Object> aTracks = new ArrayList<Object>();
        int skinIndex = -1;
        ArrayList<Joint> usedJoints = new ArrayList<Joint>();
        for (int i = 0; i < tracks.length; ++i) {
            TransformTrack track;
            Joint[] trackData = tracks[i];
            if (trackData == null || trackData.timeArrays.isEmpty()) continue;
            trackData.update();
            Object node = this.fetchFromCache("nodes", i, Object.class);
            if (node instanceof Spatial) {
                Spatial s = (Spatial)node;
                spatials.add(s);
                if (trackData.rotations != null || trackData.translations != null || trackData.scales != null) {
                    track = new TransformTrack((HasLocalTransform)s, trackData.times, trackData.translations, trackData.rotations, trackData.scales);
                    aTracks.add(track);
                }
                if (trackData.weights == null) continue;
                if (s instanceof Node) {
                    s.depthFirstTraversal(arg_0 -> this.lambda$readAnimation$0(aTracks, (TrackData)trackData, arg_0));
                    continue;
                }
                if (!(s instanceof Geometry)) continue;
                aTracks.add(this.toMorphTrack((TrackData)trackData, s));
                continue;
            }
            if (!(node instanceof JointWrapper)) continue;
            JointWrapper jw = (JointWrapper)node;
            usedJoints.add(jw.joint);
            if (skinIndex == -1) {
                skinIndex = jw.skinIndex;
            } else if (skinIndex != jw.skinIndex) {
                logger.log(Level.WARNING, "Animation " + animationIndex + " (" + name + ") applies to joints that are not from the same skin: skin " + skinIndex + ", joint " + jw.joint.getName() + " from skin " + jw.skinIndex);
                continue;
            }
            track = new TransformTrack((HasLocalTransform)jw.joint, trackData.times, trackData.translations, trackData.rotations, trackData.scales);
            aTracks.add(track);
        }
        if (skinIndex != -1) {
            SkinData skin = this.fetchFromCache("skins", skinIndex, SkinData.class);
            for (Joint joint : skin.joints) {
                if (usedJoints.contains(joint)) continue;
                float[] times = new float[]{0.0f};
                Vector3f[] translations = new Vector3f[]{joint.getLocalTranslation()};
                rotations = new Quaternion[]{joint.getLocalRotation()};
                Vector3f[] scales = new Vector3f[]{joint.getLocalScale()};
                TransformTrack track = new TransformTrack((HasLocalTransform)joint, times, translations, rotations, scales);
                aTracks.add(track);
            }
        }
        anim.setTracks(aTracks.toArray(new AnimTrack[aTracks.size()]));
        anim = this.customContentManager.readExtensionAndExtras("animations", (JsonElement)animation, anim);
        if (skinIndex != -1) {
            SkinData skin = this.fetchFromCache("skins", skinIndex, SkinData.class);
            skin.animComposer.addAnimClip(anim);
        }
        if (!spatials.isEmpty()) {
            if (skinIndex != -1) {
                SkinData skin = this.fetchFromCache("skins", skinIndex, SkinData.class);
                List<Spatial> spat = this.skinnedSpatials.get(skin);
                spat.addAll(spatials);
                if (hasMorphTrack && skin.morphControl == null) {
                    skin.morphControl = new MorphControl();
                }
            } else {
                Spatial spatial = null;
                spatial = spatials.size() == 1 ? (Spatial)spatials.get(0) : GltfUtils.findCommonAncestor(spatials);
                AnimComposer composer = (AnimComposer)spatial.getControl(AnimComposer.class);
                if (composer == null) {
                    composer = new AnimComposer();
                    spatial.addControl((Control)composer);
                }
                composer.addAnimClip(anim);
                if (hasMorphTrack && spatial.getControl(MorphControl.class) == null) {
                    spatial.addControl((Control)new MorphControl());
                }
            }
        }
    }

    public Texture2D readSampler(int samplerIndex, Texture2D texture) throws IOException {
        if (this.samplers == null) {
            throw new AssetLoadException("No samplers defined");
        }
        JsonObject sampler = this.samplers.get(samplerIndex).getAsJsonObject();
        Texture.MagFilter magFilter = GltfUtils.getMagFilter(GltfUtils.getAsInteger(sampler, "magFilter"));
        Texture.MinFilter minFilter = GltfUtils.getMinFilter(GltfUtils.getAsInteger(sampler, "minFilter"));
        Texture.WrapMode wrapS = GltfUtils.getWrapMode(GltfUtils.getAsInteger(sampler, "wrapS"));
        Texture.WrapMode wrapT = GltfUtils.getWrapMode(GltfUtils.getAsInteger(sampler, "wrapT"));
        if (magFilter != null) {
            texture.setMagFilter(magFilter);
        }
        if (minFilter != null) {
            texture.setMinFilter(minFilter);
        }
        texture.setWrap(Texture.WrapAxis.S, wrapS);
        texture.setWrap(Texture.WrapAxis.T, wrapT);
        texture = this.customContentManager.readExtensionAndExtras("texture.sampler", (JsonElement)sampler, texture);
        return texture;
    }

    public void readSkins() throws IOException {
        if (this.skins == null) {
            return;
        }
        ArrayList<JsonArray> allJoints = new ArrayList<JsonArray>();
        for (int index = 0; index < this.skins.size(); ++index) {
            int i;
            JsonObject skin = this.skins.get(index).getAsJsonObject();
            JsonArray jsonJoints = skin.getAsJsonArray("joints");
            GltfUtils.assertNotNull(jsonJoints, "No joints defined for skin");
            int idx = allJoints.indexOf(jsonJoints);
            if (idx >= 0) {
                SkinData sd = this.fetchFromCache("skins", idx, SkinData.class);
                this.addToCache("skins", index, sd, this.nodes.size());
                continue;
            }
            allJoints.add(jsonJoints);
            Integer matricesIndex = GltfUtils.getAsInteger(skin, "inverseBindMatrices");
            Matrix4f[] inverseBindMatrices = null;
            if (matricesIndex != null) {
                inverseBindMatrices = this.readAccessorData(matricesIndex, this.matrix4fArrayPopulator);
            } else {
                inverseBindMatrices = new Matrix4f[jsonJoints.size()];
                for (int i2 = 0; i2 < inverseBindMatrices.length; ++i2) {
                    inverseBindMatrices[i2] = new Matrix4f();
                }
            }
            Joint[] joints = new Joint[jsonJoints.size()];
            for (i = 0; i < jsonJoints.size(); ++i) {
                int boneIndex = jsonJoints.get(i).getAsInt();
                Matrix4f inverseModelBindMatrix = inverseBindMatrices[i];
                joints[i] = this.readNodeAsBone(boneIndex, i, index, inverseModelBindMatrix);
            }
            for (i = 0; i < jsonJoints.size(); ++i) {
                this.findChildren(jsonJoints.get(i).getAsInt());
            }
            Armature armature = new Armature(joints);
            armature = this.customContentManager.readExtensionAndExtras("skin", (JsonElement)skin, armature);
            SkinData skinData = new SkinData();
            skinData.joints = joints;
            skinData.skinningControl = new SkinningControl(armature);
            skinData.animComposer = new AnimComposer();
            this.addToCache("skins", index, skinData, this.nodes.size());
            this.skinnedSpatials.put(skinData, new ArrayList());
            armature.update();
            armature.saveInitialPose();
        }
    }

    public Joint readNodeAsBone(int nodeIndex, int jointIndex, int skinIndex, Matrix4f inverseModelBindMatrix) throws IOException {
        JointWrapper jointWrapper = this.fetchFromCache("nodes", nodeIndex, JointWrapper.class);
        if (jointWrapper != null) {
            return jointWrapper.joint;
        }
        JsonObject nodeData = this.nodes.get(nodeIndex).getAsJsonObject();
        String name = GltfUtils.getAsString(nodeData, "name");
        if (name == null) {
            name = "Joint_" + nodeIndex;
        }
        Joint joint = new Joint(name);
        Transform boneTransforms = null;
        boneTransforms = this.readTransforms(nodeData);
        joint.setLocalTransform(boneTransforms);
        joint.setInverseModelBindMatrix(inverseModelBindMatrix);
        this.addToCache("nodes", nodeIndex, new JointWrapper(joint, jointIndex, skinIndex), this.nodes.size());
        return joint;
    }

    private void findChildren(int nodeIndex) throws IOException {
        JointWrapper jw = this.fetchFromCache("nodes", nodeIndex, JointWrapper.class);
        if (jw == null) {
            logger.log(Level.WARNING, "No JointWrapper found for nodeIndex={0}.", nodeIndex);
            return;
        }
        JsonObject nodeData = this.nodes.get(nodeIndex).getAsJsonObject();
        JsonArray children = nodeData.getAsJsonArray("children");
        if (children != null) {
            for (JsonElement child : children) {
                int childIndex = child.getAsInt();
                if (jw.children.contains(childIndex)) continue;
                JointWrapper cjw = this.fetchFromCache("nodes", childIndex, JointWrapper.class);
                if (cjw != null) {
                    jw.joint.addChild(cjw.joint);
                    jw.children.add(childIndex);
                    continue;
                }
                Node n = new Node();
                this.readChild((Spatial)n, child);
                Spatial s = n.getChild(0);
                s.removeFromParent();
                jw.attachedSpatial = s;
            }
        }
    }

    private void setupControls() {
        for (SkinData skinData : this.skinnedSpatials.keySet()) {
            List<Spatial> spatials = this.skinnedSpatials.get(skinData);
            if (spatials.isEmpty()) continue;
            Spatial spatial = skinData.parent;
            if (spatials.size() >= 1) {
                spatial = GltfUtils.findCommonAncestor(spatials);
            }
            if (skinData.animComposer != null && skinData.animComposer.getSpatial() == null) {
                spatial.addControl((Control)skinData.animComposer);
            }
            spatial.addControl((Control)skinData.skinningControl);
            if (skinData.morphControl == null) continue;
            spatial.addControl((Control)skinData.morphControl);
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            JointWrapper bw = this.fetchFromCache("nodes", i, JointWrapper.class);
            if (bw == null || bw.attachedSpatial == null) continue;
            String jointName = bw.joint.getName();
            SkinData skinData = this.fetchFromCache("skins", bw.skinIndex, SkinData.class);
            SkinningControl skinControl = skinData.skinningControl;
            if (skinControl.getSpatial() == null) {
                logger.log(Level.WARNING, "No skinned Spatial for joint \"{0}\" -- will skin the model's root node!", jointName);
                this.rootNode.addControl((Control)skinControl);
            }
            skinControl.getAttachmentsNode(jointName).attachChild(bw.attachedSpatial);
        }
    }

    private String readMeshName(int meshIndex) {
        JsonObject meshData = this.meshes.get(meshIndex).getAsJsonObject();
        return GltfUtils.getAsString(meshData, "name");
    }

    private MorphTrack toMorphTrack(TrackData data, Spatial spatial) {
        Geometry g = (Geometry)spatial;
        int nbMorph = g.getMesh().getMorphTargets().length;
        return new MorphTrack(g, data.times, data.weights, nbMorph);
    }

    public <T> T fetchFromCache(String name, int index, Class<T> type) {
        Object[] data = this.dataCache.get(name);
        if (data == null) {
            return null;
        }
        try {
            T ret = type.cast(data[index]);
            return ret;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public void addToCache(String name, int index, Object object, int maxLength) {
        Object[] data = this.dataCache.get(name);
        if (data == null) {
            data = new Object[maxLength];
            this.dataCache.put(name, data);
        }
        data[index] = object;
    }

    public AssetInfo getInfo() {
        return this.info;
    }

    public JsonObject getDocRoot() {
        return this.docRoot;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    private String decodeUri(String uri) {
        try {
            return URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return uri;
        }
    }

    public static void registerExtension(String name, Class<? extends ExtensionLoader> ext) {
        CustomContentManager.defaultExtensionLoaders.put(name, ext);
    }

    public static void unregisterExtension(String name) {
        CustomContentManager.defaultExtensionLoaders.remove(name);
    }

    public static void registerDefaultExtrasLoader(Class<? extends ExtrasLoader> loader) {
        CustomContentManager.defaultExtraLoaderClass = loader;
    }

    public static void unregisterDefaultExtrasLoader() {
        CustomContentManager.defaultExtraLoaderClass = UserDataLoader.class;
    }

    private /* synthetic */ void lambda$readAnimation$0(List aTracks, TrackData trackData, Spatial spatial) {
        if (spatial instanceof Geometry) {
            aTracks.add(this.toMorphTrack(trackData, spatial));
        }
    }

    private class FloatArrayPopulator
    implements Populator<float[]> {
        private FloatArrayPopulator() {
        }

        @Override
        public float[] populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            int numComponents = GltfUtils.getNumberOfComponents(type);
            int dataSize = numComponents * count;
            float[] data = new float[dataSize];
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(data, dataSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, data, numComponents, GltfUtils.getVertexBufferFormat(componentType));
            }
            return data;
        }
    }

    private class Vector3fArrayPopulator
    implements Populator<Vector3f[]> {
        private Vector3fArrayPopulator() {
        }

        @Override
        public Vector3f[] populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            int numComponents = GltfUtils.getNumberOfComponents(type);
            int dataSize = numComponents * count;
            Vector3f[] data = new Vector3f[count];
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(data, dataSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, data, numComponents, GltfUtils.getVertexBufferFormat(componentType));
            }
            return data;
        }
    }

    private class QuaternionArrayPopulator
    implements Populator<Quaternion[]> {
        private QuaternionArrayPopulator() {
        }

        @Override
        public Quaternion[] populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            int numComponents = GltfUtils.getNumberOfComponents(type);
            int dataSize = numComponents * count;
            Quaternion[] data = new Quaternion[count];
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(data, dataSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, data, numComponents, GltfUtils.getVertexBufferFormat(componentType));
            }
            return data;
        }
    }

    private class Matrix4fArrayPopulator
    implements Populator<Matrix4f[]> {
        private Matrix4fArrayPopulator() {
        }

        @Override
        public Matrix4f[] populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            int numComponents = GltfUtils.getNumberOfComponents(type);
            int dataSize = numComponents * count;
            Matrix4f[] data = new Matrix4f[count];
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(data, dataSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, data, numComponents, GltfUtils.getVertexBufferFormat(componentType));
            }
            return data;
        }
    }

    private class JointWrapper {
        Joint joint;
        int jointIndex;
        int skinIndex;
        boolean isRoot = false;
        Spatial attachedSpatial;
        List<Integer> children = new ArrayList<Integer>();

        public JointWrapper(Joint joint, int jointIndex, int skinIndex) {
            this.joint = joint;
            this.jointIndex = jointIndex;
            this.skinIndex = skinIndex;
        }
    }

    private class SkinData {
        SkinningControl skinningControl;
        MorphControl morphControl;
        AnimComposer animComposer;
        Spatial spatial;
        Spatial parent;
        Transform rootBoneTransformOffset;
        Joint[] joints;
        boolean used = false;

        private SkinData() {
        }
    }

    private class VertexBufferPopulator
    implements Populator<VertexBuffer> {
        VertexBuffer.Type bufferType;

        public VertexBufferPopulator(VertexBuffer.Type bufferType) {
            this.bufferType = bufferType;
        }

        @Override
        public VertexBuffer populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            VertexBuffer.Format format;
            if (this.bufferType == null) {
                logger.log(Level.WARNING, "could not assign data to any VertexBuffer type for buffer view {0}", bufferViewIndex);
                return null;
            }
            VertexBuffer vb = new VertexBuffer(this.bufferType);
            VertexBuffer.Format originalFormat = format = GltfUtils.getVertexBufferFormat(componentType);
            if (normalized) {
                format = VertexBuffer.Format.Float;
            }
            int numComponents = GltfUtils.getNumberOfComponents(type);
            Buffer buff = VertexBuffer.createBuffer((VertexBuffer.Format)format, (int)numComponents, (int)count);
            int bufferSize = numComponents * count;
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(buff, bufferSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, buff, numComponents, originalFormat);
            }
            if (this.bufferType == VertexBuffer.Type.Index) {
                numComponents = 3;
            }
            vb.setupData(VertexBuffer.Usage.Dynamic, numComponents, format, buff);
            return vb;
        }
    }

    private static interface Populator<T> {
        public T populate(Integer var1, int var2, String var3, int var4, int var5, boolean var6) throws IOException;
    }

    public static class SkinBuffers {
        short[] joints;
        float[] weights;
        int componentSize;

        public SkinBuffers(short[] joints, int componentSize) {
            this.joints = joints;
            this.componentSize = componentSize;
        }

        public SkinBuffers() {
        }
    }

    private class JointArrayPopulator
    implements Populator<SkinBuffers> {
        private JointArrayPopulator() {
        }

        @Override
        public SkinBuffers populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            int numComponents = GltfUtils.getNumberOfComponents(type);
            VertexBuffer.Format format = VertexBuffer.Format.Byte;
            if (componentType == 5123) {
                format = VertexBuffer.Format.Short;
            }
            int dataSize = numComponents * count;
            short[] data = new short[dataSize];
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(data, dataSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, data, numComponents, format);
            }
            return new SkinBuffers(data, format.getComponentSize());
        }
    }

    public static class WeightData {
        float value;
        short index;
        int componentSize;

        public WeightData(float value, short index, int componentSize) {
            this.value = value;
            this.index = index;
            this.componentSize = componentSize;
        }
    }
}

