/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetManager;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamTexture;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import java.util.HashMap;
import java.util.Map;

public abstract class MaterialAdapter {
    private final Map<String, String> paramsMapping = new HashMap<String, String>();
    private Material mat;
    private AssetManager assetManager;

    protected abstract String getMaterialDefPath();

    protected abstract MatParam adaptMatParam(MatParam var1);

    protected abstract void initDefaultMatParams(Material var1);

    protected void init(AssetManager assetManager) {
        this.assetManager = assetManager;
        this.reset();
    }

    void reset() {
        this.mat = null;
    }

    protected Material getMaterial() {
        if (this.mat == null) {
            this.mat = new Material(this.assetManager, this.getMaterialDefPath());
            this.initDefaultMatParams(this.mat);
        }
        return this.mat;
    }

    public void setParam(String gltfParamName, Object value) {
        String name = this.getJmeParamName(gltfParamName);
        if (name == null || value == null) {
            return;
        }
        if (value instanceof Texture) {
            MatParam defParam = this.getMaterial().getMaterialDef().getMaterialParam(name);
            if (defParam == null) {
                throw new AssetLoadException("Material definition " + this.getMaterialDefPath() + " has not param with name" + name);
            }
            if (!(defParam instanceof MatParamTexture)) {
                throw new AssetLoadException("param with name" + name + "in material definition " + this.getMaterialDefPath() + " should be a texture param");
            }
            MatParamTexture param = new MatParamTexture(VarType.Texture2D, name, (Texture)value, ((MatParamTexture)defParam).getColorSpace());
            if ((param = this.adaptMatParam((MatParam)param)) != null) {
                this.getMaterial().setTextureParam(param.getName(), param.getVarType(), (Texture)param.getValue());
            }
        } else {
            MatParam param = new MatParam(this.getVarType(value), name, value);
            if ((param = this.adaptMatParam(param)) != null) {
                this.getMaterial().setParam(param.getName(), param.getVarType(), param.getValue());
            }
        }
    }

    protected void addParamMapping(String gltfParamName, String jmeParamName) {
        this.paramsMapping.put(gltfParamName, jmeParamName);
    }

    protected String getJmeParamName(String gltfParamName) {
        return this.paramsMapping.get(gltfParamName);
    }

    private VarType getVarType(Object value) {
        if (value instanceof Float) {
            return VarType.Float;
        }
        if (value instanceof Integer) {
            return VarType.Int;
        }
        if (value instanceof Boolean) {
            return VarType.Boolean;
        }
        if (value instanceof ColorRGBA) {
            return VarType.Vector4;
        }
        if (value instanceof Vector4f) {
            return VarType.Vector4;
        }
        if (value instanceof Vector3f) {
            return VarType.Vector3;
        }
        if (value instanceof Vector2f) {
            return VarType.Vector2;
        }
        if (value instanceof Matrix3f) {
            return VarType.Matrix3;
        }
        if (value instanceof Matrix4f) {
            return VarType.Matrix4;
        }
        if (value instanceof String) {
            return VarType.Boolean;
        }
        throw new AssetLoadException("Unsupported material parameter type : " + value.getClass().getSimpleName());
    }
}

