/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.xml;

import com.jme3.export.JmeExporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.export.SavableClassUtil;
import com.jme3.export.xml.XMLUtils;
import com.jme3.util.IntMap;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMOutputCapsule
implements OutputCapsule {
    private Document doc;
    private Element currentElement;
    private JmeExporter exporter;
    private Map<Savable, Element> writtenSavables = new IdentityHashMap<Savable, Element>();

    public DOMOutputCapsule(Document doc, JmeExporter exporter) {
        this.doc = doc;
        this.exporter = exporter;
        this.currentElement = null;
    }

    public Document getDoc() {
        return this.doc;
    }

    private Element appendElement(String name) {
        Element ret = this.doc.createElement(name);
        if (this.currentElement == null) {
            ret.setAttribute("format_version", Integer.toString(3));
            this.doc.appendChild(ret);
        } else {
            this.currentElement.appendChild(ret);
        }
        this.currentElement = ret;
        return ret;
    }

    private void writePrimitiveArrayHelper(Object value, String name) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Array.getLength(value); ++i) {
            sb.append(Array.get(value, i));
            sb.append(" ");
        }
        sb.setLength(Math.max(0, sb.length() - 1));
        this.appendElement(name);
        XMLUtils.setAttribute(this.currentElement, "size", String.valueOf(Array.getLength(value)));
        XMLUtils.setAttribute(this.currentElement, "data", sb.toString());
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    private void writePrimitiveArray2DHelper(Object[] value, String name) throws IOException {
        this.appendElement(name);
        XMLUtils.setAttribute(this.currentElement, "size", String.valueOf(value.length));
        String childNamePrefix = value.getClass().getComponentType().getSimpleName().toLowerCase();
        childNamePrefix = childNamePrefix.replace("[]", "_array_");
        for (int i = 0; i < value.length; ++i) {
            String childName = childNamePrefix + i;
            if (value[i] != null) {
                this.writePrimitiveArrayHelper(value[i], childName);
                continue;
            }
            this.appendElement(childName);
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(byte value, String name, byte defVal) throws IOException {
        if (value != defVal) {
            XMLUtils.setAttribute(this.currentElement, name, String.valueOf(value));
        }
    }

    public void write(byte[] value, String name, byte[] defVal) throws IOException {
        if (!Arrays.equals(value, defVal)) {
            this.writePrimitiveArrayHelper(value, name);
        }
    }

    public void write(byte[][] value, String name, byte[][] defVal) throws IOException {
        if (!Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            this.writePrimitiveArray2DHelper((Object[])value, name);
        }
    }

    public void write(short value, String name, short defVal) throws IOException {
        if (value != defVal) {
            XMLUtils.setAttribute(this.currentElement, name, String.valueOf(value));
        }
    }

    public void write(short[] value, String name, short[] defVal) throws IOException {
        if (!Arrays.equals(value, defVal)) {
            this.writePrimitiveArrayHelper(value, name);
        }
    }

    public void write(short[][] value, String name, short[][] defVal) throws IOException {
        if (!Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            this.writePrimitiveArray2DHelper((Object[])value, name);
        }
    }

    public void write(int value, String name, int defVal) throws IOException {
        if (value != defVal) {
            XMLUtils.setAttribute(this.currentElement, name, String.valueOf(value));
        }
    }

    public void write(int[] value, String name, int[] defVal) throws IOException {
        if (!Arrays.equals(value, defVal)) {
            this.writePrimitiveArrayHelper(value, name);
        }
    }

    public void write(int[][] value, String name, int[][] defVal) throws IOException {
        if (!Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            this.writePrimitiveArray2DHelper((Object[])value, name);
        }
    }

    public void write(long value, String name, long defVal) throws IOException {
        if (value != defVal) {
            XMLUtils.setAttribute(this.currentElement, name, String.valueOf(value));
        }
    }

    public void write(long[] value, String name, long[] defVal) throws IOException {
        if (!Arrays.equals(value, defVal)) {
            this.writePrimitiveArrayHelper(value, name);
        }
    }

    public void write(long[][] value, String name, long[][] defVal) throws IOException {
        if (!Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            this.writePrimitiveArray2DHelper((Object[])value, name);
        }
    }

    public void write(float value, String name, float defVal) throws IOException {
        if (value != defVal) {
            XMLUtils.setAttribute(this.currentElement, name, String.valueOf(value));
        }
    }

    public void write(float[] value, String name, float[] defVal) throws IOException {
        if (!Arrays.equals(value, defVal)) {
            this.writePrimitiveArrayHelper(value, name);
        }
    }

    public void write(float[][] value, String name, float[][] defVal) throws IOException {
        if (!Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            this.writePrimitiveArray2DHelper((Object[])value, name);
        }
    }

    public void write(double value, String name, double defVal) throws IOException {
        if (value != defVal) {
            XMLUtils.setAttribute(this.currentElement, name, String.valueOf(value));
        }
    }

    public void write(double[] value, String name, double[] defVal) throws IOException {
        if (!Arrays.equals(value, defVal)) {
            this.writePrimitiveArrayHelper(value, name);
        }
    }

    public void write(double[][] value, String name, double[][] defVal) throws IOException {
        if (!Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            this.writePrimitiveArray2DHelper((Object[])value, name);
        }
    }

    public void write(boolean value, String name, boolean defVal) throws IOException {
        if (value != defVal) {
            XMLUtils.setAttribute(this.currentElement, name, String.valueOf(value));
        }
    }

    public void write(boolean[] value, String name, boolean[] defVal) throws IOException {
        if (!Arrays.equals(value, defVal)) {
            this.writePrimitiveArrayHelper(value, name);
        }
    }

    public void write(boolean[][] value, String name, boolean[][] defVal) throws IOException {
        if (!Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            this.writePrimitiveArray2DHelper((Object[])value, name);
        }
    }

    public void write(String value, String name, String defVal) throws IOException {
        if (value != null && !value.equals(defVal)) {
            XMLUtils.setAttribute(this.currentElement, name, value);
        }
    }

    public void write(String[] value, String name, String[] defVal) throws IOException {
        if (value == null || Arrays.equals(value, defVal)) {
            return;
        }
        this.appendElement(name);
        XMLUtils.setAttribute(this.currentElement, "size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            this.appendElement("string_" + i);
            if (value[i] != null) {
                XMLUtils.setAttribute(this.currentElement, "value", value[i]);
            }
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(String[][] value, String name, String[][] defVal) throws IOException {
        if (value == null || Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        this.appendElement(name);
        XMLUtils.setAttribute(this.currentElement, "size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            String childName = "string_array_" + i;
            if (value[i] != null) {
                this.write(value[i], childName, defVal != null ? defVal[i] : null);
                continue;
            }
            this.appendElement(childName);
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(Enum value, String name, Enum defVal) throws IOException {
        if (value != null && !value.equals(defVal)) {
            XMLUtils.setAttribute(this.currentElement, name, String.valueOf(value));
        }
    }

    public void write(BitSet value, String name, BitSet defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < value.size(); ++i) {
            buf.append(value.get(i) ? "1 " : "0 ");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        XMLUtils.setAttribute(this.currentElement, name, buf.toString());
    }

    public void write(Savable value, String name, Savable defVal) throws IOException {
        if (value == null || value.equals((Object)defVal)) {
            return;
        }
        Element old = this.currentElement;
        Element refElement = this.writtenSavables.get(value);
        if (refElement != null) {
            String refID = XMLUtils.getAttribute(3, refElement, "reference_ID");
            if (refID.isEmpty()) {
                refID = value.getClass().getName() + "@" + value.hashCode();
                XMLUtils.setAttribute(refElement, "reference_ID", refID);
            }
            this.appendElement(name);
            XMLUtils.setAttribute(this.currentElement, "ref", refID);
        } else {
            this.appendElement(name);
            XMLUtils.setAttribute(this.currentElement, "class", value.getClass().getName());
            int[] versions = SavableClassUtil.getSavableVersions((Class)value.getClass());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < versions.length; ++i) {
                sb.append(versions[i]);
                if (i == versions.length - 1) continue;
                sb.append(", ");
            }
            XMLUtils.setAttribute(this.currentElement, "savable_versions", sb.toString());
            this.writtenSavables.put(value, this.currentElement);
            value.write(this.exporter);
        }
        this.currentElement = old;
    }

    public void write(Savable[] value, String name, Savable[] defVal) throws IOException {
        if (value == null || Arrays.equals(value, defVal)) {
            return;
        }
        Element old = this.currentElement;
        this.appendElement(name);
        XMLUtils.setAttribute(this.currentElement, "size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            Savable o = value[i];
            String elementName = "savable_" + i;
            if (o == null) {
                if (name.equals("renderStateList")) continue;
                Element before = this.currentElement;
                this.appendElement(elementName);
                this.currentElement = before;
                continue;
            }
            this.write(o, elementName, null);
        }
        this.currentElement = old;
    }

    public void write(Savable[][] value, String name, Savable[][] defVal) throws IOException {
        if (value == null || Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element old = this.currentElement;
        this.appendElement(name);
        XMLUtils.setAttribute(this.currentElement, "size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            String childName = "savable_array_" + i;
            if (value[i] != null) {
                this.write(value[i], childName, null);
                continue;
            }
            this.appendElement(childName);
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
        this.currentElement = old;
    }

    public void write(ByteBuffer value, String name, ByteBuffer defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        int position = value.position();
        value.rewind();
        byte[] array = new byte[value.remaining()];
        value.get(array);
        value.position(position);
        this.writePrimitiveArrayHelper(array, name);
    }

    public void write(ShortBuffer value, String name, ShortBuffer defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        int position = value.position();
        value.rewind();
        short[] array = new short[value.remaining()];
        value.get(array);
        value.position(position);
        this.writePrimitiveArrayHelper(array, name);
    }

    public void write(IntBuffer value, String name, IntBuffer defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        int position = value.position();
        value.rewind();
        int[] array = new int[value.remaining()];
        value.get(array);
        value.position(position);
        this.writePrimitiveArrayHelper(array, name);
    }

    public void write(FloatBuffer value, String name, FloatBuffer defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        int position = value.position();
        value.rewind();
        float[] array = new float[value.remaining()];
        value.get(array);
        value.position(position);
        this.writePrimitiveArrayHelper(array, name);
    }

    public void writeByteBufferArrayList(ArrayList<ByteBuffer> value, String name, ArrayList<ByteBuffer> defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        this.appendElement(name);
        XMLUtils.setAttribute(this.currentElement, "size", String.valueOf(value.size()));
        for (int i = 0; i < value.size(); ++i) {
            String childName = "byte_buffer_" + i;
            if (value.get(i) != null) {
                this.write(value.get(i), childName, null);
                continue;
            }
            this.appendElement(childName);
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void writeFloatBufferArrayList(ArrayList<FloatBuffer> value, String name, ArrayList<FloatBuffer> defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        this.appendElement(name);
        XMLUtils.setAttribute(this.currentElement, "size", String.valueOf(value.size()));
        for (int i = 0; i < value.size(); ++i) {
            String childName = "float_buffer_" + i;
            if (value.get(i) != null) {
                this.write(value.get(i), childName, null);
                continue;
            }
            this.appendElement(childName);
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void writeSavableArrayList(ArrayList value, String name, ArrayList defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        Savable[] savableArray = new Savable[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            Object o = value.get(i);
            if (o != null && !(o instanceof Savable)) {
                throw new IOException(new ClassCastException("Not a Savable instance: " + o));
            }
            savableArray[i] = (Savable)o;
        }
        this.write(savableArray, name, null);
    }

    public void writeSavableArrayListArray(ArrayList[] value, String name, ArrayList[] defVal) throws IOException {
        if (value == null || Arrays.equals(value, defVal)) {
            return;
        }
        Element old = this.currentElement;
        this.appendElement(name);
        XMLUtils.setAttribute(this.currentElement, "size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            String childName = "savable_list_" + i;
            if (value[i] != null) {
                this.writeSavableArrayList(value[i], childName, null);
                continue;
            }
            this.appendElement(childName);
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
        this.currentElement = old;
    }

    public void writeSavableArrayListArray2D(ArrayList[][] value, String name, ArrayList[][] defVal) throws IOException {
        if (value == null || Arrays.equals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element old = this.currentElement;
        this.appendElement(name);
        XMLUtils.setAttribute(this.currentElement, "size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            String childName = "savable_list_array_" + i;
            if (value[i] != null) {
                this.writeSavableArrayListArray(value[i], childName, null);
                continue;
            }
            this.appendElement(childName);
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
        this.currentElement = old;
    }

    public void writeSavableMap(Map<? extends Savable, ? extends Savable> map, String name, Map<? extends Savable, ? extends Savable> defVal) throws IOException {
        if (map == null || map.equals(defVal)) {
            return;
        }
        Element stringMap = this.appendElement(name);
        for (Savable savable : map.keySet()) {
            Element mapEntry = this.appendElement("MapEntry");
            this.write(savable, "Key", null);
            Savable value = map.get(savable);
            this.write(value, "Value", null);
            this.currentElement = stringMap;
        }
        this.currentElement = (Element)stringMap.getParentNode();
    }

    public void writeStringSavableMap(Map<String, ? extends Savable> map, String name, Map<String, ? extends Savable> defVal) throws IOException {
        if (map == null || map.equals(defVal)) {
            return;
        }
        Element stringMap = this.appendElement(name);
        for (String key : map.keySet()) {
            Element mapEntry = this.appendElement("MapEntry");
            XMLUtils.setAttribute(mapEntry, "key", key);
            Savable s = map.get(key);
            this.write(s, "Savable", null);
            this.currentElement = stringMap;
        }
        this.currentElement = (Element)stringMap.getParentNode();
    }

    public void writeIntSavableMap(IntMap<? extends Savable> map, String name, IntMap<? extends Savable> defVal) throws IOException {
        if (map == null || map.equals(defVal)) {
            return;
        }
        Element stringMap = this.appendElement(name);
        for (IntMap.Entry entry : map) {
            int key = entry.getKey();
            Element mapEntry = this.appendElement("MapEntry");
            XMLUtils.setAttribute(mapEntry, "key", Integer.toString(key));
            Savable s = (Savable)entry.getValue();
            this.write(s, "Savable", null);
            this.currentElement = stringMap;
        }
        this.currentElement = (Element)stringMap.getParentNode();
    }
}

