/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.xml;

import com.jme3.export.JmeExporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.export.xml.DOMOutputCapsule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XMLExporter
implements JmeExporter {
    public static final String ELEMENT_MAPENTRY = "MapEntry";
    public static final String ELEMENT_KEY = "Key";
    public static final String ELEMENT_VALUE = "Value";
    public static final String ATTRIBUTE_SIZE = "size";
    public static final String ATTRIBUTE_DATA = "data";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_REFERENCE_ID = "reference_ID";
    public static final String ATTRIBUTE_REFERENCE = "ref";
    public static final String ATTRIBUTE_SAVABLE_VERSIONS = "savable_versions";
    private DOMOutputCapsule domOut;
    private int indentSpaces = 4;

    public void save(Savable object, OutputStream outputStream) throws IOException {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex);
        }
        document.setXmlStandalone(true);
        this.domOut = new DOMOutputCapsule(document, this);
        this.domOut.write(object, "savable", null);
        DOMSource source = new DOMSource(this.domOut.getDoc());
        StreamResult result = new StreamResult(outputStream);
        try {
            TransformerFactory tfFactory = TransformerFactory.newInstance();
            tfFactory.setAttribute("indent-number", this.indentSpaces);
            Transformer transformer = tfFactory.newTransformer();
            transformer.setOutputProperty("standalone", "yes");
            if (this.indentSpaces > 0) {
                transformer.setOutputProperty("indent", "yes");
            }
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Savable object, File f, boolean createDirectories) throws IOException {
        File parentDirectory = f.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists() && createDirectories) {
            parentDirectory.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(f);){
            this.save(object, fos);
        }
    }

    public OutputCapsule getCapsule(Savable object) {
        return this.domOut;
    }

    public void setIndentSpaces(int indentSpaces) {
        this.indentSpaces = indentSpaces;
    }

    public static XMLExporter getInstance() {
        return new XMLExporter();
    }
}

