/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugin.export.material;

import com.jme3.export.JmeExporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.plugin.export.material.J3MRootOutputCapsule;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public class J3MExporter
implements JmeExporter {
    private final J3MRootOutputCapsule rootCapsule = new J3MRootOutputCapsule(this);

    public void save(Savable object, OutputStream f) throws IOException {
        if (!(object instanceof Material)) {
            throw new IllegalArgumentException("J3MExporter can only save com.jme3.material.Material class");
        }
        try (OutputStreamWriter out = new OutputStreamWriter(f, StandardCharsets.UTF_8);){
            this.rootCapsule.clear();
            object.write((JmeExporter)this);
            this.rootCapsule.writeToStream(out);
        }
    }

    public void save(Savable object, File f, boolean createDirectories) throws IOException {
        File parentDirectory = f.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists() && createDirectories) {
            parentDirectory.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(f);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            this.save(object, bos);
        }
    }

    public OutputCapsule getCapsule(Savable object) {
        if (object instanceof Material || object instanceof MaterialDef) {
            return this.rootCapsule;
        }
        return this.rootCapsule.getCapsule(object);
    }
}

