/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugin.export.material;

import com.jme3.asset.TextureKey;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamTexture;
import com.jme3.material.plugin.export.material.J3MExporter;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.jme3.util.IntMap;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class J3MOutputCapsule
implements OutputCapsule {
    private final HashMap<String, String> parameters;
    protected final J3MExporter exporter;

    public J3MOutputCapsule(J3MExporter exporter) {
        this.exporter = exporter;
        this.parameters = new HashMap();
    }

    public void writeToStream(Writer out) throws IOException {
        for (String key : this.parameters.keySet()) {
            out.write("      ");
            this.writeParameter(out, key, this.parameters.get(key));
            out.write("\n");
        }
    }

    protected void writeParameter(Writer out, String name, String value) throws IOException {
        out.write(name);
        out.write(" : ");
        out.write(value);
    }

    public void clear() {
        this.parameters.clear();
    }

    protected void putParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void write(boolean value, String name, boolean defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.putParameter(name, value ? "On" : "Off");
    }

    public void writeStringSavableMap(Map<String, ? extends Savable> map, String name, Map<String, ? extends Savable> defVal) throws IOException {
        for (String key : map.keySet()) {
            Savable value = map.get(key);
            if (defVal != null && defVal.containsKey(key) && defVal.get(key).equals((Object)value)) continue;
            this.putParameter(key, this.format(value));
        }
    }

    protected String format(Savable value) {
        if (value instanceof MatParamTexture) {
            return J3MOutputCapsule.formatMatParamTexture((MatParamTexture)value);
        }
        if (value instanceof MatParam) {
            return this.formatMatParam((MatParam)value);
        }
        throw new UnsupportedOperationException(value.getClass() + ": Not supported yet.");
    }

    private String formatMatParam(MatParam param) {
        VarType type = param.getVarType();
        Object val = param.getValue();
        switch (type) {
            case Boolean: 
            case Float: 
            case Int: {
                return val.toString();
            }
            case Vector2: {
                Vector2f v2 = (Vector2f)val;
                return v2.getX() + " " + v2.getY();
            }
            case Vector3: {
                Vector3f v3 = (Vector3f)val;
                return v3.getX() + " " + v3.getY() + " " + v3.getZ();
            }
            case Vector4: {
                if (val instanceof Vector4f) {
                    Vector4f v4 = (Vector4f)val;
                    return v4.getX() + " " + v4.getY() + " " + v4.getZ() + " " + v4.getW();
                }
                if (val instanceof ColorRGBA) {
                    ColorRGBA color = (ColorRGBA)val;
                    return color.getRed() + " " + color.getGreen() + " " + color.getBlue() + " " + color.getAlpha();
                }
                if (val instanceof Quaternion) {
                    Quaternion quat = (Quaternion)val;
                    return quat.getX() + " " + quat.getY() + " " + quat.getZ() + " " + quat.getW();
                }
                throw new UnsupportedOperationException("Unexpected Vector4 type: " + val);
            }
        }
        return null;
    }

    protected static String formatMatParamTexture(MatParamTexture param) {
        StringBuilder ret = new StringBuilder();
        Texture tex = (Texture)param.getValue();
        if (tex != null) {
            TextureKey key = (TextureKey)tex.getKey();
            if (key != null && key.isFlipY()) {
                ret.append("Flip ");
            }
            ret.append(J3MOutputCapsule.formatWrapMode(tex, Texture.WrapAxis.S));
            ret.append(J3MOutputCapsule.formatWrapMode(tex, Texture.WrapAxis.T));
            ret.append(J3MOutputCapsule.formatWrapMode(tex, Texture.WrapAxis.R));
            if (tex.getMinFilter() != Texture.MinFilter.Trilinear) {
                ret.append("Min").append(tex.getMinFilter().name()).append(" ");
            }
            if (tex.getMagFilter() != Texture.MagFilter.Bilinear) {
                ret.append("Mag").append(tex.getMagFilter().name()).append(" ");
            }
            ret.append("\"").append(key.getName()).append("\"");
        }
        return ret.toString();
    }

    protected static String formatWrapMode(Texture texVal, Texture.WrapAxis axis) {
        Texture.WrapMode mode;
        try {
            mode = texVal.getWrap(axis);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        if (mode != Texture.WrapMode.EdgeClamp) {
            return "Wrap" + mode.name() + "_" + axis.name() + " ";
        }
        return "";
    }

    public void write(Enum value, String name, Enum defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.putParameter(name, value.toString());
    }

    public void write(float value, String name, float defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.putParameter(name, Float.toString(value));
    }

    public void write(float[] value, String name, float[] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(float[][] value, String name, float[][] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(double value, String name, double defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(double[] value, String name, double[] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(double[][] value, String name, double[][] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(long value, String name, long defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(long[] value, String name, long[] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(long[][] value, String name, long[][] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(short value, String name, short defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(short[] value, String name, short[] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(short[][] value, String name, short[][] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(boolean[] value, String name, boolean[] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(boolean[][] value, String name, boolean[][] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(String value, String name, String defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(String[] value, String name, String[] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(String[][] value, String name, String[][] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(BitSet value, String name, BitSet defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(Savable object, String name, Savable defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(Savable[] objects, String name, Savable[] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(Savable[][] objects, String name, Savable[][] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeSavableArrayList(ArrayList array, String name, ArrayList defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeSavableArrayListArray(ArrayList[] array, String name, ArrayList[] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeSavableArrayListArray2D(ArrayList[][] array, String name, ArrayList[][] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeFloatBufferArrayList(ArrayList<FloatBuffer> array, String name, ArrayList<FloatBuffer> defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeByteBufferArrayList(ArrayList<ByteBuffer> array, String name, ArrayList<ByteBuffer> defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeSavableMap(Map<? extends Savable, ? extends Savable> map, String name, Map<? extends Savable, ? extends Savable> defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void writeIntSavableMap(IntMap<? extends Savable> map, String name, IntMap<? extends Savable> defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(FloatBuffer value, String name, FloatBuffer defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(IntBuffer value, String name, IntBuffer defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(ByteBuffer value, String name, ByteBuffer defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(ShortBuffer value, String name, ShortBuffer defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(byte value, String name, byte defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(byte[] value, String name, byte[] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(byte[][] value, String name, byte[][] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(int value, String name, int defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.putParameter(name, Integer.toString(value));
    }

    public void write(int[] value, String name, int[] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(int[][] value, String name, int[][] defVal) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

