/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugin.export.material;

import com.jme3.export.JmeExporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.plugin.export.material.J3MExporter;
import com.jme3.material.plugin.export.material.J3MOutputCapsule;
import com.jme3.material.plugin.export.material.J3MRenderStateOutputCapsule;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public class J3MRootOutputCapsule
extends J3MOutputCapsule {
    private final HashMap<Savable, J3MOutputCapsule> outCapsules = new HashMap();
    private String name;
    private String materialDefinition;
    private Boolean isTransparent;

    public J3MRootOutputCapsule(J3MExporter exporter) {
        super(exporter);
    }

    @Override
    public void clear() {
        super.clear();
        this.isTransparent = null;
        this.name = "";
        this.materialDefinition = "";
        this.outCapsules.clear();
    }

    public OutputCapsule getCapsule(Savable object) {
        if (!this.outCapsules.containsKey(object)) {
            this.outCapsules.put(object, new J3MRenderStateOutputCapsule(this.exporter));
        }
        return this.outCapsules.get(object);
    }

    @Override
    public void writeToStream(Writer out) throws IOException {
        out.write("Material " + this.name + " : " + this.materialDefinition + " {\n\n");
        if (this.isTransparent != null) {
            out.write("    Transparent " + (this.isTransparent != false ? "On" : "Off") + "\n\n");
        }
        out.write("    MaterialParameters {\n");
        super.writeToStream(out);
        out.write("    }\n\n");
        for (J3MOutputCapsule c : this.outCapsules.values()) {
            c.writeToStream(out);
        }
        out.write("}\n");
    }

    @Override
    public void write(String value, String name, String defVal) throws IOException {
        switch (name) {
            case "material_def": {
                this.materialDefinition = value;
                break;
            }
            case "name": {
                this.name = value;
                break;
            }
            default: {
                throw new UnsupportedOperationException(name + " string material parameter not supported yet");
            }
        }
    }

    @Override
    public void write(boolean value, String name, boolean defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        switch (name) {
            case "is_transparent": {
                this.isTransparent = value;
                break;
            }
            default: {
                throw new UnsupportedOperationException(name + " boolean material parameter not supported yet");
            }
        }
    }

    @Override
    public void write(Savable object, String name, Savable defVal) throws IOException {
        if (object != null && !object.equals((Object)defVal)) {
            object.write((JmeExporter)this.exporter);
        }
    }
}

