/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.jme3.asset.AssetLoadException;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.plugins.json.JsonArray;
import com.jme3.plugins.json.JsonElement;
import com.jme3.plugins.json.JsonObject;
import com.jme3.scene.Node;
import com.jme3.scene.control.Control;
import com.jme3.scene.control.LightControl;
import com.jme3.scene.plugins.gltf.ExtensionLoader;
import com.jme3.scene.plugins.gltf.GltfLoader;
import com.jme3.scene.plugins.gltf.GltfUtils;
import java.util.HashMap;
import java.util.HashSet;

public class LightsPunctualExtensionLoader
implements ExtensionLoader {
    private final HashSet<NodeNeedingLight> pendingNodes = new HashSet();
    private final HashMap<Integer, Light> lightDefinitions = new HashMap();

    @Override
    public Object handleExtension(GltfLoader loader, String parentName, JsonElement parent, JsonElement extension, Object input) {
        if (input instanceof Node) {
            JsonObject jsonObject = extension.getAsJsonObject();
            if (jsonObject.has("light")) {
                JsonElement indexElement = jsonObject.get("light");
                int index = indexElement.getAsInt();
                if (!this.lightDefinitions.containsKey(index)) {
                    this.pendingNodes.add(new NodeNeedingLight((Node)input, index));
                } else {
                    this.addLight((Node)input, (Node)input, index);
                }
            } else if (jsonObject.has("lights")) {
                JsonArray lights = jsonObject.getAsJsonArray("lights");
                for (int i = 0; i < lights.size(); ++i) {
                    PointLight lightNode;
                    String type;
                    JsonObject light = lights.get(i).getAsJsonObject();
                    switch (type = light.get("type").getAsString()) {
                        case "point": {
                            lightNode = this.buildPointLight(light);
                            break;
                        }
                        case "directional": {
                            lightNode = this.buildDirectionalLight(light);
                            break;
                        }
                        case "spot": {
                            lightNode = this.buildSpotLight(light);
                            break;
                        }
                        default: {
                            throw new AssetLoadException("KHR_lights_punctual unsupported light type: " + type);
                        }
                    }
                    this.lightDefinitions.put(i, (Light)lightNode);
                }
                for (NodeNeedingLight nodeInNeed : this.pendingNodes) {
                    this.addLight((Node)input, nodeInNeed.getNode(), nodeInNeed.getLightIndex());
                }
                this.pendingNodes.clear();
            } else {
                throw new AssetLoadException("KHR_lights_punctual extension malformed json");
            }
            return input;
        }
        throw new AssetLoadException("KHR_lights_punctual extension added on unsupported element");
    }

    private SpotLight buildSpotLight(JsonObject obj) {
        float outerConeAngle;
        String name = obj.has("name") ? obj.get("name").getAsString() : "";
        float intensity = obj.has("intensity") ? obj.get("intensity").getAsFloat() : 1.0f;
        ColorRGBA color = obj.has("color") ? GltfUtils.getAsColor(obj, "color") : new ColorRGBA(ColorRGBA.White);
        color = this.lumensToColor(color, intensity);
        float range = obj.has("range") ? obj.get("range").getAsFloat() : Float.POSITIVE_INFINITY;
        JsonObject spot = obj.getAsJsonObject("spot");
        float innerConeAngle = spot != null && spot.has("innerConeAngle") ? spot.get("innerConeAngle").getAsFloat() : 0.0f;
        float f = outerConeAngle = spot != null && spot.has("outerConeAngle") ? spot.get("outerConeAngle").getAsFloat() : 0.7853982f;
        if (outerConeAngle >= 1.5707964f) {
            outerConeAngle = 1.5707954f;
        }
        SpotLight spotLight = new SpotLight();
        spotLight.setName(name);
        spotLight.setColor(color);
        spotLight.setSpotRange(range);
        spotLight.setSpotInnerAngle(innerConeAngle);
        spotLight.setSpotOuterAngle(outerConeAngle);
        spotLight.setDirection(Vector3f.UNIT_Z.negate());
        return spotLight;
    }

    private DirectionalLight buildDirectionalLight(JsonObject obj) {
        String name = obj.has("name") ? obj.get("name").getAsString() : "";
        float intensity = obj.has("intensity") ? obj.get("intensity").getAsFloat() : 1.0f;
        ColorRGBA color = obj.has("color") ? GltfUtils.getAsColor(obj, "color") : new ColorRGBA(ColorRGBA.White);
        color = this.lumensToColor(color, intensity);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setName(name);
        directionalLight.setColor(color);
        directionalLight.setDirection(Vector3f.UNIT_Z.negate());
        return directionalLight;
    }

    private PointLight buildPointLight(JsonObject obj) {
        String name = obj.has("name") ? obj.get("name").getAsString() : "";
        float intensity = obj.has("intensity") ? obj.get("intensity").getAsFloat() : 1.0f;
        ColorRGBA color = obj.has("color") ? GltfUtils.getAsColor(obj, "color") : new ColorRGBA(ColorRGBA.White);
        color = this.lumensToColor(color, intensity);
        float range = obj.has("range") ? obj.get("range").getAsFloat() : Float.POSITIVE_INFINITY;
        PointLight pointLight = new PointLight();
        pointLight.setName(name);
        pointLight.setColor(color);
        pointLight.setRadius(range);
        return pointLight;
    }

    private void addLight(Node parent, Node node, int lightIndex) {
        if (!this.lightDefinitions.containsKey(lightIndex)) {
            throw new AssetLoadException("KHR_lights_punctual extension accessed undefined light at index " + lightIndex);
        }
        Light light = this.lightDefinitions.get(lightIndex);
        parent.addLight(light);
        LightControl control = new LightControl(light);
        node.addControl((Control)control);
    }

    private ColorRGBA lumensToColor(ColorRGBA color, float lumens) {
        ColorRGBA brightnessModifier = this.lumensToColor(lumens);
        return color.mult(brightnessModifier);
    }

    private ColorRGBA lumensToColor(float lumens) {
        float val;
        float epsilon = 1.0E-4f;
        double Le = 2.0 * Math.log(lumens * epsilon) / Math.log(2.0) + 127.0;
        ColorRGBA color = new ColorRGBA();
        color.a = (float)(Le - Math.floor(Le));
        color.r = val = (float)((Le - Math.floor((double)color.a * 255.0) / 255.0) / 255.0);
        color.g = val;
        color.b = val;
        return color;
    }

    private static class NodeNeedingLight {
        private Node node;
        private int lightIndex;

        private NodeNeedingLight(Node node, int lightIndex) {
            this.node = node;
            this.lightIndex = lightIndex;
        }

        private Node getNode() {
            return this.node;
        }

        private void setNode(Node node) {
            this.node = node;
        }

        private int getLightIndex() {
            return this.lightIndex;
        }

        private void setLightIndex(int lightIndex) {
            this.lightIndex = lightIndex;
        }
    }
}

