/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.xml;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeImporter;
import com.jme3.export.Savable;
import com.jme3.export.SavableClassUtil;
import com.jme3.export.xml.XMLImporter;
import com.jme3.export.xml.XMLUtils;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMInputCapsule
implements InputCapsule {
    private static final Logger logger = Logger.getLogger(DOMInputCapsule.class.getName());
    private Document doc;
    private Element currentElement;
    private XMLImporter importer;
    private boolean isAtRoot = true;
    private Map<String, Savable> referencedSavables = new HashMap<String, Savable>();
    private int[] classHierarchyVersions;
    private Savable savable;
    private static final String[] zeroStrings = new String[0];

    public DOMInputCapsule(Document doc, XMLImporter importer) {
        this.doc = doc;
        this.importer = importer;
        this.currentElement = doc.getDocumentElement();
        String version = this.currentElement.getAttribute("format_version");
        importer.formatVersion = version.equals("") ? 0 : Integer.parseInt(version);
    }

    public int getSavableVersion(Class<? extends Savable> desiredClass) {
        if (this.classHierarchyVersions != null) {
            return SavableClassUtil.getSavedSavableVersion((Object)this.savable, desiredClass, (int[])this.classHierarchyVersions, (int)this.importer.getFormatVersion());
        }
        return 0;
    }

    private Element findChildElement(String name) {
        Node ret;
        if (this.currentElement == null) {
            return null;
        }
        for (ret = this.currentElement.getFirstChild(); !(ret == null || ret instanceof Element && ret.getNodeName().equals(name)); ret = ret.getNextSibling()) {
        }
        return (Element)ret;
    }

    private Object readPrimitiveArrayHelper(Element element, String primType) throws IOException {
        if (element == null) {
            return null;
        }
        String sizeString = XMLUtils.getAttribute(this.importer.getFormatVersion(), element, "size");
        if (sizeString.isEmpty()) {
            return null;
        }
        String[] tokens = this.parseTokens(XMLUtils.getAttribute(this.importer.getFormatVersion(), element, "data"));
        if (!sizeString.isEmpty()) {
            try {
                int requiredSize = Integer.parseInt(sizeString);
                if (tokens.length != requiredSize) {
                    throw new IOException("Wrong token count for '" + element.getTagName() + "'.  size says " + requiredSize + ", data contains " + tokens.length);
                }
            }
            catch (NumberFormatException ex) {
                throw new IOException("Invalid size for '" + element.getTagName() + "': " + sizeString);
            }
        }
        try {
            switch (primType) {
                case "byte": {
                    byte[] byteArray = new byte[tokens.length];
                    for (int i = 0; i < tokens.length; ++i) {
                        byteArray[i] = Byte.parseByte(tokens[i]);
                    }
                    return byteArray;
                }
                case "short": {
                    short[] shortArray = new short[tokens.length];
                    for (int i = 0; i < tokens.length; ++i) {
                        shortArray[i] = Short.parseShort(tokens[i]);
                    }
                    return shortArray;
                }
                case "int": {
                    int[] intArray = new int[tokens.length];
                    for (int i = 0; i < tokens.length; ++i) {
                        intArray[i] = Integer.parseInt(tokens[i]);
                    }
                    return intArray;
                }
                case "long": {
                    long[] longArray = new long[tokens.length];
                    for (int i = 0; i < tokens.length; ++i) {
                        longArray[i] = Long.parseLong(tokens[i]);
                    }
                    return longArray;
                }
                case "float": {
                    float[] floatArray = new float[tokens.length];
                    for (int i = 0; i < tokens.length; ++i) {
                        floatArray[i] = Float.parseFloat(tokens[i]);
                    }
                    return floatArray;
                }
                case "double": {
                    double[] doubleArray = new double[tokens.length];
                    for (int i = 0; i < tokens.length; ++i) {
                        doubleArray[i] = Double.parseDouble(tokens[i]);
                    }
                    return doubleArray;
                }
                case "boolean": {
                    boolean[] booleanArray = new boolean[tokens.length];
                    for (int i = 0; i < tokens.length; ++i) {
                        booleanArray[i] = Boolean.parseBoolean(tokens[i]);
                    }
                    return booleanArray;
                }
            }
            throw new IOException();
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
    }

    private List<Element> getObjectArrayElements(Element element) throws IOException {
        if (element == null) {
            return null;
        }
        String sizeString = XMLUtils.getAttribute(this.importer.getFormatVersion(), element, "size");
        if (sizeString.isEmpty()) {
            return null;
        }
        NodeList nodes = element.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            elements.add((Element)node);
        }
        try {
            int requiredSize = Integer.parseInt(sizeString);
            if (elements.size() != requiredSize) {
                throw new IOException("DOMInputCapsule.getObjectArrayElements(): Wrong element count for '" + element.getTagName() + "'.  size says " + requiredSize + ", data contains " + elements.size());
            }
        }
        catch (NumberFormatException ex) {
            throw new IOException("Invalid size for '" + element.getTagName() + "': " + sizeString);
        }
        return elements;
    }

    public byte readByte(String name, byte defVal) throws IOException {
        String attribute = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, name);
        if (attribute.isEmpty()) {
            return defVal;
        }
        try {
            return Byte.parseByte(attribute);
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
    }

    public byte[] readByteArray(String name, byte[] defVal) throws IOException {
        byte[] array = (byte[])this.readPrimitiveArrayHelper(this.findChildElement(name), "byte");
        return array != null ? array : defVal;
    }

    public byte[][] readByteArray2D(String name, byte[][] defVal) throws IOException {
        List<Element> arrayEntryElements = this.getObjectArrayElements(this.findChildElement(name));
        if (arrayEntryElements == null) {
            return defVal;
        }
        byte[][] arrays = new byte[arrayEntryElements.size()][];
        for (int i = 0; i < arrayEntryElements.size(); ++i) {
            arrays[i] = (byte[])this.readPrimitiveArrayHelper(arrayEntryElements.get(i), "byte");
        }
        return arrays;
    }

    public short readShort(String name, short defVal) throws IOException {
        String attribute = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, name);
        if (attribute.isEmpty()) {
            return defVal;
        }
        try {
            return Short.parseShort(attribute);
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
    }

    public short[] readShortArray(String name, short[] defVal) throws IOException {
        short[] array = (short[])this.readPrimitiveArrayHelper(this.findChildElement(name), "short");
        return array != null ? array : defVal;
    }

    public short[][] readShortArray2D(String name, short[][] defVal) throws IOException {
        List<Element> arrayEntryElements = this.getObjectArrayElements(this.findChildElement(name));
        if (arrayEntryElements == null) {
            return defVal;
        }
        short[][] arrays = new short[arrayEntryElements.size()][];
        for (int i = 0; i < arrayEntryElements.size(); ++i) {
            arrays[i] = (short[])this.readPrimitiveArrayHelper(arrayEntryElements.get(i), "short");
        }
        return arrays;
    }

    public int readInt(String name, int defVal) throws IOException {
        String attribute = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, name);
        if (attribute.isEmpty()) {
            return defVal;
        }
        try {
            return Integer.parseInt(attribute);
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
    }

    public int[] readIntArray(String name, int[] defVal) throws IOException {
        int[] array = (int[])this.readPrimitiveArrayHelper(this.findChildElement(name), "int");
        return array != null ? array : defVal;
    }

    public int[][] readIntArray2D(String name, int[][] defVal) throws IOException {
        List<Element> arrayEntryElements = this.getObjectArrayElements(this.findChildElement(name));
        if (arrayEntryElements == null) {
            return defVal;
        }
        int[][] arrays = new int[arrayEntryElements.size()][];
        for (int i = 0; i < arrayEntryElements.size(); ++i) {
            arrays[i] = (int[])this.readPrimitiveArrayHelper(arrayEntryElements.get(i), "int");
        }
        return arrays;
    }

    public long readLong(String name, long defVal) throws IOException {
        String attribute = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, name);
        if (attribute.isEmpty()) {
            return defVal;
        }
        try {
            return Long.parseLong(attribute);
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
    }

    public long[] readLongArray(String name, long[] defVal) throws IOException {
        long[] array = (long[])this.readPrimitiveArrayHelper(this.findChildElement(name), "long");
        return array != null ? array : defVal;
    }

    public long[][] readLongArray2D(String name, long[][] defVal) throws IOException {
        List<Element> arrayEntryElements = this.getObjectArrayElements(this.findChildElement(name));
        if (arrayEntryElements == null) {
            return defVal;
        }
        long[][] arrays = new long[arrayEntryElements.size()][];
        for (int i = 0; i < arrayEntryElements.size(); ++i) {
            arrays[i] = (long[])this.readPrimitiveArrayHelper(arrayEntryElements.get(i), "long");
        }
        return arrays;
    }

    public float readFloat(String name, float defVal) throws IOException {
        String attribute = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, name);
        if (attribute.isEmpty()) {
            return defVal;
        }
        try {
            return Float.parseFloat(attribute);
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
    }

    public float[] readFloatArray(String name, float[] defVal) throws IOException {
        float[] array = (float[])this.readPrimitiveArrayHelper(this.findChildElement(name), "float");
        return array != null ? array : defVal;
    }

    public float[][] readFloatArray2D(String name, float[][] defVal) throws IOException {
        List<Element> arrayEntryElements = this.getObjectArrayElements(this.findChildElement(name));
        if (arrayEntryElements == null) {
            return defVal;
        }
        float[][] arrays = new float[arrayEntryElements.size()][];
        for (int i = 0; i < arrayEntryElements.size(); ++i) {
            arrays[i] = (float[])this.readPrimitiveArrayHelper(arrayEntryElements.get(i), "float");
        }
        return arrays;
    }

    public double readDouble(String name, double defVal) throws IOException {
        String attribute = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, name);
        if (attribute.isEmpty()) {
            return defVal;
        }
        try {
            return Double.parseDouble(attribute);
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
    }

    public double[] readDoubleArray(String name, double[] defVal) throws IOException {
        double[] array = (double[])this.readPrimitiveArrayHelper(this.findChildElement(name), "double");
        return array != null ? array : defVal;
    }

    public double[][] readDoubleArray2D(String name, double[][] defVal) throws IOException {
        List<Element> arrayEntryElements = this.getObjectArrayElements(this.findChildElement(name));
        if (arrayEntryElements == null) {
            return defVal;
        }
        double[][] arrays = new double[arrayEntryElements.size()][];
        for (int i = 0; i < arrayEntryElements.size(); ++i) {
            arrays[i] = (double[])this.readPrimitiveArrayHelper(arrayEntryElements.get(i), "double");
        }
        return arrays;
    }

    public boolean readBoolean(String name, boolean defVal) throws IOException {
        String attribute = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, name);
        if (attribute.isEmpty()) {
            return defVal;
        }
        return Boolean.parseBoolean(attribute);
    }

    public boolean[] readBooleanArray(String name, boolean[] defVal) throws IOException {
        boolean[] array = (boolean[])this.readPrimitiveArrayHelper(this.findChildElement(name), "boolean");
        return array != null ? array : defVal;
    }

    public boolean[][] readBooleanArray2D(String name, boolean[][] defVal) throws IOException {
        List<Element> arrayEntryElements = this.getObjectArrayElements(this.findChildElement(name));
        if (arrayEntryElements == null) {
            return defVal;
        }
        boolean[][] arrays = new boolean[arrayEntryElements.size()][];
        for (int i = 0; i < arrayEntryElements.size(); ++i) {
            arrays[i] = (boolean[])this.readPrimitiveArrayHelper(arrayEntryElements.get(i), "boolean");
        }
        return arrays;
    }

    public String readString(String name, String defVal) throws IOException {
        String attribute = null;
        if (XMLUtils.hasAttribute(this.importer.getFormatVersion(), this.currentElement, name)) {
            attribute = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, name);
        }
        if (attribute == null) {
            return defVal;
        }
        return attribute;
    }

    public String[] readStringArray(String name, String[] defVal) throws IOException {
        List<Element> arrayElements = this.getObjectArrayElements(this.findChildElement(name));
        if (arrayElements == null) {
            return defVal;
        }
        Element oldElement = this.currentElement;
        String[] array = new String[arrayElements.size()];
        for (int i = 0; i < arrayElements.size(); ++i) {
            this.currentElement = arrayElements.get(i);
            array[i] = this.readString("value", null);
        }
        this.currentElement = oldElement;
        return array;
    }

    public String[][] readStringArray2D(String name, String[][] defVal) throws IOException {
        Element outerArrayElement = this.findChildElement(name);
        List<Element> innerArrayElements = this.getObjectArrayElements(outerArrayElement);
        if (innerArrayElements == null) {
            return defVal;
        }
        this.currentElement = outerArrayElement;
        String[][] arrays = new String[innerArrayElements.size()][];
        for (int i = 0; i < innerArrayElements.size(); ++i) {
            arrays[i] = this.readStringArray(innerArrayElements.get(i).getTagName(), null);
        }
        this.currentElement = (Element)this.currentElement.getParentNode();
        return arrays;
    }

    public <T extends Enum<T>> T readEnum(String name, Class<T> enumType, T defVal) throws IOException {
        String attribute = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, name);
        if (attribute.isEmpty()) {
            return defVal;
        }
        try {
            return Enum.valueOf(enumType, attribute);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IOException(e);
        }
    }

    public BitSet readBitSet(String name, BitSet defVal) throws IOException {
        String attribute = null;
        attribute = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, name);
        if (attribute == null || attribute.isEmpty()) {
            return defVal;
        }
        String[] strings = this.parseTokens(attribute);
        BitSet bitSet = new BitSet();
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals("1")) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    private Savable readSavableFromCurrentElement(Savable defVal) throws IOException {
        String refID;
        if (this.currentElement == null || !this.currentElement.hasAttributes()) {
            return defVal;
        }
        String reference = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, "ref");
        if (!reference.isEmpty()) {
            return this.referencedSavables.get(reference);
        }
        String className = this.currentElement.getNodeName();
        if (XMLUtils.hasAttribute(this.importer.getFormatVersion(), this.currentElement, "class")) {
            className = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, "class");
        } else if (defVal != null) {
            className = defVal.getClass().getName();
        }
        Savable tmp = null;
        try {
            tmp = SavableClassUtil.fromName((String)className);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException(e);
        }
        String versionsStr = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, "savable_versions");
        if (versionsStr != null && !versionsStr.equals("")) {
            String[] versionStr = versionsStr.split(",");
            this.classHierarchyVersions = new int[versionStr.length];
            try {
                for (int i = 0; i < this.classHierarchyVersions.length; ++i) {
                    this.classHierarchyVersions[i] = Integer.parseInt(versionStr[i].trim());
                }
            }
            catch (NumberFormatException nfe) {
                throw new IOException(nfe);
            }
        } else {
            this.classHierarchyVersions = null;
        }
        if ((refID = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, "reference_ID")).isEmpty()) {
            refID = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, "id");
        }
        if (!refID.isEmpty()) {
            this.referencedSavables.put(refID, tmp);
        }
        if (tmp != null) {
            this.savable = tmp;
            tmp.read((JmeImporter)this.importer);
            return tmp;
        }
        return defVal;
    }

    public Savable readSavable(String name, Savable defVal) throws IOException {
        Savable ret = defVal;
        if (name != null && name.equals("")) {
            logger.warning("Reading Savable String with name \"\"?");
        }
        Element old = this.currentElement;
        if (this.isAtRoot) {
            this.currentElement = this.doc.getDocumentElement();
            this.isAtRoot = false;
        } else {
            this.currentElement = this.findChildElement(name);
        }
        ret = this.readSavableFromCurrentElement(defVal);
        this.currentElement = old;
        return ret;
    }

    public Savable[] readSavableArray(String name, Savable[] defVal) throws IOException {
        Element arrayElement = this.findChildElement(name);
        if (arrayElement == null || !arrayElement.hasAttributes()) {
            return defVal;
        }
        List<Element> arrayElements = this.getObjectArrayElements(arrayElement);
        Savable[] savableArray = new Savable[arrayElements.size()];
        Element old = this.currentElement;
        for (int i = 0; i < arrayElements.size(); ++i) {
            this.currentElement = arrayElements.get(i);
            savableArray[i] = this.readSavableFromCurrentElement(null);
        }
        this.currentElement = old;
        return savableArray;
    }

    public Savable[][] readSavableArray2D(String name, Savable[][] defVal) throws IOException {
        Element outerArrayElement = this.findChildElement(name);
        if (outerArrayElement == null || !outerArrayElement.hasAttributes()) {
            return defVal;
        }
        List<Element> innerArrayElements = this.getObjectArrayElements(outerArrayElement);
        Savable[][] savableArray2D = new Savable[innerArrayElements.size()][];
        Element old = this.currentElement;
        for (int i = 0; i < innerArrayElements.size(); ++i) {
            List<Element> savableElements = this.getObjectArrayElements(innerArrayElements.get(i));
            if (savableElements == null) continue;
            savableArray2D[i] = new Savable[savableElements.size()];
            for (int j = 0; j < savableElements.size(); ++j) {
                this.currentElement = savableElements.get(j);
                savableArray2D[i][j] = this.readSavableFromCurrentElement(null);
            }
        }
        this.currentElement = old;
        return savableArray2D;
    }

    public ByteBuffer readByteBuffer(String name, ByteBuffer defVal) throws IOException {
        Element element = this.findChildElement(name);
        byte[] array = (byte[])this.readPrimitiveArrayHelper(element, "byte");
        if (array == null) {
            return defVal;
        }
        return (ByteBuffer)BufferUtils.createByteBuffer((int)array.length).put(array).rewind();
    }

    public ShortBuffer readShortBuffer(String name, ShortBuffer defVal) throws IOException {
        Element element = this.findChildElement(name);
        short[] array = (short[])this.readPrimitiveArrayHelper(element, "short");
        if (array == null) {
            return defVal;
        }
        return (ShortBuffer)BufferUtils.createShortBuffer((int)array.length).put(array).rewind();
    }

    public IntBuffer readIntBuffer(String name, IntBuffer defVal) throws IOException {
        Element element = this.findChildElement(name);
        int[] array = (int[])this.readPrimitiveArrayHelper(element, "int");
        if (array == null) {
            return defVal;
        }
        return (IntBuffer)BufferUtils.createIntBuffer((int)array.length).put(array).rewind();
    }

    public FloatBuffer readFloatBuffer(String name, FloatBuffer defVal) throws IOException {
        Element element = this.findChildElement(name);
        float[] array = (float[])this.readPrimitiveArrayHelper(element, "float");
        if (array == null) {
            return defVal;
        }
        return (FloatBuffer)BufferUtils.createFloatBuffer((int)array.length).put(array).rewind();
    }

    public ArrayList<ByteBuffer> readByteBufferArrayList(String name, ArrayList<ByteBuffer> defVal) throws IOException {
        byte[][] byteArray2D = this.readByteArray2D(name, null);
        if (byteArray2D == null) {
            return defVal;
        }
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>(byteArray2D.length);
        for (byte[] byteArray : byteArray2D) {
            if (byteArray == null) {
                byteBufferList.add(null);
                continue;
            }
            byteBufferList.add((ByteBuffer)BufferUtils.createByteBuffer((int)byteArray.length).put(byteArray).rewind());
        }
        return byteBufferList;
    }

    public ArrayList<FloatBuffer> readFloatBufferArrayList(String name, ArrayList<FloatBuffer> defVal) throws IOException {
        float[][] floatArray2D = this.readFloatArray2D(name, null);
        if (floatArray2D == null) {
            return defVal;
        }
        ArrayList<FloatBuffer> floatBufferList = new ArrayList<FloatBuffer>(floatArray2D.length);
        for (float[] floatArray : floatArray2D) {
            if (floatArray == null) {
                floatBufferList.add(null);
                continue;
            }
            floatBufferList.add((FloatBuffer)BufferUtils.createFloatBuffer((int)floatArray.length).put(floatArray).rewind());
        }
        return floatBufferList;
    }

    public ArrayList<Savable> readSavableArrayList(String name, ArrayList defVal) throws IOException {
        Savable[] savableArray = this.readSavableArray(name, null);
        if (savableArray == null) {
            return defVal;
        }
        return new ArrayList<Savable>(Arrays.asList(savableArray));
    }

    public ArrayList<Savable>[] readSavableArrayListArray(String name, ArrayList[] defVal) throws IOException {
        Savable[][] savableArray2D = this.readSavableArray2D(name, null);
        if (savableArray2D == null) {
            return defVal;
        }
        ArrayList[] savableArrayListArray = new ArrayList[savableArray2D.length];
        for (int i = 0; i < savableArray2D.length; ++i) {
            if (savableArray2D[i] == null) continue;
            savableArrayListArray[i] = new ArrayList<Savable>(Arrays.asList(savableArray2D[i]));
        }
        return savableArrayListArray;
    }

    public ArrayList<Savable>[][] readSavableArrayListArray2D(String name, ArrayList[][] defVal) throws IOException {
        Element outerArrayElement = this.findChildElement(name);
        if (outerArrayElement == null) {
            return defVal;
        }
        List<Element> innerArrayElements = this.getObjectArrayElements(outerArrayElement);
        ArrayList[][] savableArrayListArray2D = new ArrayList[innerArrayElements.size()][];
        Element old = this.currentElement;
        this.currentElement = outerArrayElement;
        for (int i = 0; i < innerArrayElements.size(); ++i) {
            if (innerArrayElements.get(i) == null) continue;
            savableArrayListArray2D[i] = this.readSavableArrayListArray(innerArrayElements.get(i).getTagName(), null);
        }
        this.currentElement = old;
        return savableArrayListArray2D;
    }

    public Map<? extends Savable, ? extends Savable> readSavableMap(String name, Map<? extends Savable, ? extends Savable> defVal) throws IOException {
        Element mapElement = this.findChildElement(name);
        if (mapElement == null) {
            return defVal;
        }
        HashMap<Savable, Savable> ret = new HashMap<Savable, Savable>();
        NodeList nodes = mapElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem;
            Node n = nodes.item(i);
            if (!(n instanceof Element) || !n.getNodeName().equals("MapEntry")) continue;
            this.currentElement = elem = (Element)n;
            Savable key = this.readSavable("Key", null);
            Savable val = this.readSavable("Value", null);
            ret.put(key, val);
        }
        this.currentElement = (Element)mapElement.getParentNode();
        return ret;
    }

    public Map<String, ? extends Savable> readStringSavableMap(String name, Map<String, ? extends Savable> defVal) throws IOException {
        Element mapElement = this.findChildElement(name);
        if (mapElement == null) {
            return defVal;
        }
        HashMap<String, Savable> ret = new HashMap<String, Savable>();
        NodeList nodes = mapElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem;
            Node n = nodes.item(i);
            if (!(n instanceof Element) || !n.getNodeName().equals("MapEntry")) continue;
            this.currentElement = elem = (Element)n;
            String key = XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, "key");
            Savable val = this.readSavable("Savable", null);
            ret.put(key, val);
        }
        this.currentElement = (Element)mapElement.getParentNode();
        return ret;
    }

    public IntMap<? extends Savable> readIntSavableMap(String name, IntMap<? extends Savable> defVal) throws IOException {
        Element mapElement = this.findChildElement(name);
        if (mapElement == null) {
            return defVal;
        }
        IntMap ret = new IntMap();
        NodeList nodes = mapElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem;
            Node n = nodes.item(i);
            if (!(n instanceof Element) || !n.getNodeName().equals("MapEntry")) continue;
            this.currentElement = elem = (Element)n;
            int key = Integer.parseInt(XMLUtils.getAttribute(this.importer.getFormatVersion(), this.currentElement, "key"));
            Savable val = this.readSavable("Savable", null);
            ret.put(key, (Object)val);
        }
        this.currentElement = (Element)mapElement.getParentNode();
        return ret;
    }

    protected String[] parseTokens(String inString) {
        String[] outStrings = inString.split("\\s+");
        return outStrings.length == 1 && outStrings[0].length() == 0 ? zeroStrings : outStrings;
    }
}

