/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;

public enum RotationOrder {
    EULER_XYZ,
    EULER_XZY,
    EULER_YZX,
    EULER_YXZ,
    EULER_ZXY,
    EULER_ZYX,
    SPHERIC_XYZ;

    public static final RotationOrder[] values;

    public Quaternion rotate(Vector3f vec) {
        return RotationOrder.fromEuler(vec.x * ((float)Math.PI / 180), vec.y * ((float)Math.PI / 180), vec.z * ((float)Math.PI / 180), this);
    }

    public Quaternion rotate(float x, float y, float z) {
        return RotationOrder.fromEuler(x * ((float)Math.PI / 180), y * ((float)Math.PI / 180), z * ((float)Math.PI / 180), this);
    }

    private static Quaternion fromEuler(float x, float y, float z, RotationOrder order) {
        switch (order.ordinal()) {
            case 0: {
                return RotationOrder.toQuat(x, Vector3f.UNIT_X, y, Vector3f.UNIT_Y, z, Vector3f.UNIT_Z);
            }
            case 3: {
                return RotationOrder.toQuat(y, Vector3f.UNIT_Y, x, Vector3f.UNIT_X, z, Vector3f.UNIT_Z);
            }
            case 4: {
                return RotationOrder.toQuat(z, Vector3f.UNIT_Z, x, Vector3f.UNIT_X, y, Vector3f.UNIT_Y);
            }
            case 5: {
                return RotationOrder.toQuat(z, Vector3f.UNIT_Z, y, Vector3f.UNIT_Y, x, Vector3f.UNIT_X);
            }
            case 2: {
                return RotationOrder.toQuat(y, Vector3f.UNIT_Y, z, Vector3f.UNIT_Z, x, Vector3f.UNIT_X);
            }
            case 1: {
                return RotationOrder.toQuat(x, Vector3f.UNIT_X, z, Vector3f.UNIT_Z, y, Vector3f.UNIT_Y);
            }
        }
        throw new IllegalArgumentException("Spherical rotation is unsupported in this importer");
    }

    private static Quaternion toQuat(float ax1v, Vector3f ax1, float ax2v, Vector3f ax2, float ax3v, Vector3f ax3) {
        Quaternion q1 = new Quaternion().fromAngleNormalAxis(ax1v, ax1);
        Quaternion q2 = new Quaternion().fromAngleNormalAxis(ax2v, ax2);
        Quaternion q3 = new Quaternion().fromAngleNormalAxis(ax3v, ax3);
        return q1.multLocal(q2).multLocal(q3);
    }

    static {
        values = RotationOrder.values();
    }
}

