/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.FastMath;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.WireBox;
import com.jme3.terrain.ProgressMonitor;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.NeighbourFinder;
import com.jme3.terrain.geomipmap.NormalRecalcControl;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import com.jme3.terrain.geomipmap.picking.BresenhamTerrainPicker;
import com.jme3.terrain.geomipmap.picking.TerrainPickData;
import com.jme3.terrain.geomipmap.picking.TerrainPicker;
import com.jme3.util.TangentBinormalGenerator;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TerrainQuad
extends Node
implements Terrain {
    protected Vector2f offset;
    protected int totalSize;
    protected int size;
    protected int patchSize;
    protected Vector3f stepScale;
    protected float offsetAmount;
    protected int quadrant = 0;
    private int maxLod = -1;
    private BoundingBox affectedAreaBBox;
    private TerrainPicker picker = new BresenhamTerrainPicker(this);
    private Vector3f lastScale = Vector3f.UNIT_XYZ;
    protected NeighbourFinder neighbourFinder;

    public TerrainQuad() {
        super("Terrain");
    }

    public TerrainQuad(String name, int patchSize, int totalSize, float[] heightMap) {
        this(name, patchSize, totalSize, Vector3f.UNIT_XYZ, heightMap);
        this.affectedAreaBBox = new BoundingBox(new Vector3f(0.0f, 0.0f, 0.0f), (float)(this.size * 2), Float.MAX_VALUE, (float)(this.size * 2));
        this.fixNormalEdges(this.affectedAreaBBox);
        this.addControl((Control)new NormalRecalcControl(this));
    }

    @Deprecated
    public TerrainQuad(String name, int patchSize, int size, Vector3f scale, float[] heightMap) {
        this(name, patchSize, size, scale, heightMap, size, new Vector2f(), 0.0f);
    }

    @Deprecated
    public TerrainQuad(String name, int patchSize, int totalSize, int quadSize, Vector3f scale, float[] heightMap) {
        this(name, patchSize, quadSize, scale, heightMap, totalSize, new Vector2f(), 0.0f);
    }

    protected TerrainQuad(String name, int patchSize, int quadSize, Vector3f scale, float[] heightMap, int totalSize, Vector2f offset, float offsetAmount) {
        super(name);
        if (heightMap == null) {
            heightMap = this.generateDefaultHeightMap(quadSize);
        }
        if (!FastMath.isPowerOfTwo((int)(quadSize - 1))) {
            throw new RuntimeException("size given: " + quadSize + "  Terrain quad sizes may only be (2^N + 1)");
        }
        if (FastMath.sqrt((float)heightMap.length) > (float)quadSize) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Heightmap size is larger than the terrain size. Make sure your heightmap image is the same size as the terrain!");
        }
        this.offset = offset;
        this.offsetAmount = offsetAmount;
        this.totalSize = totalSize;
        this.size = quadSize;
        this.patchSize = patchSize;
        this.stepScale = scale;
        this.split(patchSize, heightMap);
    }

    public void setNeighbourFinder(NeighbourFinder neighbourFinder) {
        this.neighbourFinder = neighbourFinder;
        this.resetCachedNeighbours();
    }

    public void recalculateAllNormals() {
        this.affectedAreaBBox = new BoundingBox(new Vector3f(0.0f, 0.0f, 0.0f), (float)(this.totalSize * 2), Float.MAX_VALUE, (float)(this.totalSize * 2));
    }

    private float[] generateDefaultHeightMap(int size) {
        float[] heightMap = new float[size * size];
        return heightMap;
    }

    protected void updateNormals() {
        if (this.needToRecalculateNormals()) {
            this.fixNormals(this.affectedAreaBBox);
            this.fixNormalEdges(this.affectedAreaBBox);
            this.setNormalRecalcNeeded(null);
        }
    }

    protected void cacheTerrainTransforms() {
        int i = this.children.size();
        while (--i >= 0) {
            Spatial child = (Spatial)this.children.get(i);
            if (child instanceof TerrainQuad) {
                ((TerrainQuad)child).cacheTerrainTransforms();
                continue;
            }
            if (!(child instanceof TerrainPatch)) continue;
            ((TerrainPatch)child).cacheTerrainTransforms();
        }
    }

    private int collideWithRay(Ray ray, CollisionResults results) {
        return this.picker.getTerrainIntersection(ray, results);
    }

    @Override
    public void generateEntropy(ProgressMonitor progressMonitor) {
        if (this.isRootQuad() && progressMonitor != null) {
            int numCalc = (this.totalSize - 1) / (this.patchSize - 1);
            progressMonitor.setMonitorMax(numCalc * numCalc);
        }
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).generateEntropy(progressMonitor);
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                ((TerrainPatch)child).generateLodEntropies();
                if (progressMonitor == null) continue;
                progressMonitor.incrementProgress(1.0f);
            }
        }
        if (this.isRootQuad() && progressMonitor != null) {
            progressMonitor.progressComplete();
        }
    }

    protected boolean isRootQuad() {
        return this.getParent() != null && !(this.getParent() instanceof TerrainQuad);
    }

    @Override
    public Material getMaterial() {
        return this.getMaterial(null);
    }

    @Override
    public Material getMaterial(Vector3f worldLocation) {
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    return ((TerrainQuad)child).getMaterial(worldLocation);
                }
                if (!(child instanceof TerrainPatch)) continue;
                return ((TerrainPatch)child).getMaterial();
            }
        }
        return null;
    }

    @Override
    public int getNumMajorSubdivisions() {
        return 1;
    }

    protected boolean calculateLod(List<Vector3f> location, HashMap<String, UpdatedTerrainPatch> updates, LodCalculator lodCalculator) {
        boolean lodChanged = false;
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                boolean b;
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    b = ((TerrainQuad)child).calculateLod(location, updates, lodCalculator);
                    if (!b) continue;
                    lodChanged = true;
                    continue;
                }
                if (!(child instanceof TerrainPatch) || !(b = lodCalculator.calculateLod((TerrainPatch)child, location, updates))) continue;
                lodChanged = true;
            }
        }
        return lodChanged;
    }

    protected synchronized void findNeighboursLod(HashMap<String, UpdatedTerrainPatch> updated) {
        if (this.children != null) {
            int x = this.children.size();
            while (--x >= 0) {
                Spatial child = (Spatial)this.children.get(x);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).findNeighboursLod(updated);
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                TerrainPatch patch = (TerrainPatch)child;
                if (!patch.searchedForNeighboursAlready) {
                    patch.rightNeighbour = this.findRightPatch(patch);
                    patch.bottomNeighbour = this.findDownPatch(patch);
                    patch.leftNeighbour = this.findLeftPatch(patch);
                    patch.topNeighbour = this.findTopPatch(patch);
                    patch.searchedForNeighboursAlready = true;
                }
                TerrainPatch right = patch.rightNeighbour;
                TerrainPatch down = patch.bottomNeighbour;
                TerrainPatch left = patch.leftNeighbour;
                TerrainPatch top = patch.topNeighbour;
                UpdatedTerrainPatch utp = updated.get(patch.getName());
                if (utp == null) {
                    utp = new UpdatedTerrainPatch(patch, patch.lod);
                    updated.put(utp.getName(), utp);
                }
                if (right != null) {
                    UpdatedTerrainPatch utpR = updated.get(right.getName());
                    if (utpR == null) {
                        utpR = new UpdatedTerrainPatch(right);
                        updated.put(utpR.getName(), utpR);
                        utpR.setNewLod(right.lod);
                    }
                    utp.setRightLod(utpR.getNewLod());
                    utpR.setLeftLod(utp.getNewLod());
                }
                if (down != null) {
                    UpdatedTerrainPatch utpD = updated.get(down.getName());
                    if (utpD == null) {
                        utpD = new UpdatedTerrainPatch(down);
                        updated.put(utpD.getName(), utpD);
                        utpD.setNewLod(down.lod);
                    }
                    utp.setBottomLod(utpD.getNewLod());
                    utpD.setTopLod(utp.getNewLod());
                }
                if (left != null) {
                    UpdatedTerrainPatch utpL = updated.get(left.getName());
                    if (utpL == null) {
                        utpL = new UpdatedTerrainPatch(left);
                        updated.put(utpL.getName(), utpL);
                        utpL.setNewLod(left.lod);
                    }
                    utp.setLeftLod(utpL.getNewLod());
                    utpL.setRightLod(utp.getNewLod());
                }
                if (top == null) continue;
                UpdatedTerrainPatch utpT = updated.get(top.getName());
                if (utpT == null) {
                    utpT = new UpdatedTerrainPatch(top);
                    updated.put(utpT.getName(), utpT);
                    utpT.setNewLod(top.lod);
                }
                utp.setTopLod(utpT.getNewLod());
                utpT.setBottomLod(utp.getNewLod());
            }
        }
    }

    public void resetCachedNeighbours() {
        if (this.children != null) {
            int x = this.children.size();
            while (--x >= 0) {
                Spatial child = (Spatial)this.children.get(x);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).resetCachedNeighbours();
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                TerrainPatch patch = (TerrainPatch)child;
                patch.searchedForNeighboursAlready = false;
            }
        }
    }

    protected synchronized void fixEdges(HashMap<String, UpdatedTerrainPatch> updated) {
        if (this.children != null) {
            int x = this.children.size();
            while (--x >= 0) {
                TerrainPatch patch;
                UpdatedTerrainPatch utp;
                Spatial child = (Spatial)this.children.get(x);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).fixEdges(updated);
                    continue;
                }
                if (!(child instanceof TerrainPatch) || (utp = updated.get((patch = (TerrainPatch)child).getName())) == null || !utp.lodChanged()) continue;
                if (!patch.searchedForNeighboursAlready) {
                    patch.rightNeighbour = this.findRightPatch(patch);
                    patch.bottomNeighbour = this.findDownPatch(patch);
                    patch.leftNeighbour = this.findLeftPatch(patch);
                    patch.topNeighbour = this.findTopPatch(patch);
                    patch.searchedForNeighboursAlready = true;
                }
                TerrainPatch right = patch.rightNeighbour;
                TerrainPatch down = patch.bottomNeighbour;
                TerrainPatch top = patch.topNeighbour;
                TerrainPatch left = patch.leftNeighbour;
                if (right != null) {
                    UpdatedTerrainPatch utpR = updated.get(right.getName());
                    if (utpR == null) {
                        utpR = new UpdatedTerrainPatch(right);
                        updated.put(utpR.getName(), utpR);
                        utpR.setNewLod(right.lod);
                    }
                    utpR.setLeftLod(utp.getNewLod());
                    utpR.setFixEdges(true);
                }
                if (down != null) {
                    UpdatedTerrainPatch utpD = updated.get(down.getName());
                    if (utpD == null) {
                        utpD = new UpdatedTerrainPatch(down);
                        updated.put(utpD.getName(), utpD);
                        utpD.setNewLod(down.lod);
                    }
                    utpD.setTopLod(utp.getNewLod());
                    utpD.setFixEdges(true);
                }
                if (top != null) {
                    UpdatedTerrainPatch utpT = updated.get(top.getName());
                    if (utpT == null) {
                        utpT = new UpdatedTerrainPatch(top);
                        updated.put(utpT.getName(), utpT);
                        utpT.setNewLod(top.lod);
                    }
                    utpT.setBottomLod(utp.getNewLod());
                    utpT.setFixEdges(true);
                }
                if (left == null) continue;
                UpdatedTerrainPatch utpL = updated.get(left.getName());
                if (utpL == null) {
                    utpL = new UpdatedTerrainPatch(left);
                    updated.put(utpL.getName(), utpL);
                    utpL.setNewLod(left.lod);
                }
                utpL.setRightLod(utp.getNewLod());
                utpL.setFixEdges(true);
            }
        }
    }

    protected synchronized void reIndexPages(HashMap<String, UpdatedTerrainPatch> updated, boolean usesVariableLod) {
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).reIndexPages(updated, usesVariableLod);
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                ((TerrainPatch)child).reIndexGeometry(updated, usesVariableLod);
            }
        }
    }

    protected void split(int blockSize, float[] heightMap) {
        if ((this.size >> 1) + 1 <= blockSize) {
            this.createQuadPatch(heightMap);
        } else {
            this.createQuad(blockSize, heightMap);
        }
    }

    protected void createQuad(int blockSize, float[] heightMap) {
        int quarterSize = this.size >> 2;
        int split = this.size + 1 >> 1;
        Vector2f tempOffset = new Vector2f();
        this.offsetAmount += (float)quarterSize;
        float[] heightBlock1 = this.createHeightSubBlock(heightMap, 0, 0, split);
        Vector3f origin1 = new Vector3f((float)(-quarterSize) * this.stepScale.x, 0.0f, (float)(-quarterSize) * this.stepScale.z);
        tempOffset.x = this.offset.x;
        tempOffset.y = this.offset.y;
        tempOffset.x += origin1.x;
        tempOffset.y += origin1.z;
        TerrainQuad quad1 = new TerrainQuad(this.getName() + "Quad1", blockSize, split, this.stepScale, heightBlock1, this.totalSize, tempOffset, this.offsetAmount);
        quad1.setLocalTranslation(origin1);
        quad1.quadrant = 1;
        this.attachChild((Spatial)quad1);
        float[] heightBlock2 = this.createHeightSubBlock(heightMap, 0, split - 1, split);
        Vector3f origin2 = new Vector3f((float)(-quarterSize) * this.stepScale.x, 0.0f, (float)quarterSize * this.stepScale.z);
        tempOffset = new Vector2f();
        tempOffset.x = this.offset.x;
        tempOffset.y = this.offset.y;
        tempOffset.x += origin2.x;
        tempOffset.y += origin2.z;
        TerrainQuad quad2 = new TerrainQuad(this.getName() + "Quad2", blockSize, split, this.stepScale, heightBlock2, this.totalSize, tempOffset, this.offsetAmount);
        quad2.setLocalTranslation(origin2);
        quad2.quadrant = 2;
        this.attachChild((Spatial)quad2);
        float[] heightBlock3 = this.createHeightSubBlock(heightMap, split - 1, 0, split);
        Vector3f origin3 = new Vector3f((float)quarterSize * this.stepScale.x, 0.0f, (float)(-quarterSize) * this.stepScale.z);
        tempOffset = new Vector2f();
        tempOffset.x = this.offset.x;
        tempOffset.y = this.offset.y;
        tempOffset.x += origin3.x;
        tempOffset.y += origin3.z;
        TerrainQuad quad3 = new TerrainQuad(this.getName() + "Quad3", blockSize, split, this.stepScale, heightBlock3, this.totalSize, tempOffset, this.offsetAmount);
        quad3.setLocalTranslation(origin3);
        quad3.quadrant = 3;
        this.attachChild((Spatial)quad3);
        float[] heightBlock4 = this.createHeightSubBlock(heightMap, split - 1, split - 1, split);
        Vector3f origin4 = new Vector3f((float)quarterSize * this.stepScale.x, 0.0f, (float)quarterSize * this.stepScale.z);
        tempOffset = new Vector2f();
        tempOffset.x = this.offset.x;
        tempOffset.y = this.offset.y;
        tempOffset.x += origin4.x;
        tempOffset.y += origin4.z;
        TerrainQuad quad4 = new TerrainQuad(this.getName() + "Quad4", blockSize, split, this.stepScale, heightBlock4, this.totalSize, tempOffset, this.offsetAmount);
        quad4.setLocalTranslation(origin4);
        quad4.quadrant = 4;
        this.attachChild((Spatial)quad4);
    }

    public void generateDebugTangents(Material mat) {
        int x = this.children.size();
        while (--x >= 0) {
            Spatial child = (Spatial)this.children.get(x);
            if (child instanceof TerrainQuad) {
                ((TerrainQuad)child).generateDebugTangents(mat);
                continue;
            }
            if (!(child instanceof TerrainPatch)) continue;
            Geometry debug = new Geometry("Debug " + this.name, TangentBinormalGenerator.genTbnLines((Mesh)((TerrainPatch)child).getMesh(), (float)0.8f));
            this.attachChild((Spatial)debug);
            debug.setLocalTranslation(child.getLocalTranslation());
            debug.setCullHint(Spatial.CullHint.Never);
            debug.setMaterial(mat);
        }
    }

    protected void createQuadPatch(float[] heightMap) {
        int quarterSize = this.size >> 2;
        int halfSize = this.size >> 1;
        int split = this.size + 1 >> 1;
        this.offsetAmount += (float)quarterSize;
        float[] heightBlock1 = this.createHeightSubBlock(heightMap, 0, 0, split);
        Vector3f origin1 = new Vector3f((float)(-halfSize) * this.stepScale.x, 0.0f, (float)(-halfSize) * this.stepScale.z);
        Vector2f tempOffset1 = new Vector2f();
        tempOffset1.x = this.offset.x;
        tempOffset1.y = this.offset.y;
        tempOffset1.x += origin1.x / 2.0f;
        tempOffset1.y += origin1.z / 2.0f;
        TerrainPatch patch1 = new TerrainPatch(this.getName() + "Patch1", split, this.stepScale, heightBlock1, origin1, this.totalSize, tempOffset1, this.offsetAmount);
        patch1.setQuadrant((short)1);
        this.attachChild((Spatial)patch1);
        patch1.setModelBound((BoundingVolume)new BoundingBox());
        patch1.updateModelBound();
        float[] heightBlock2 = this.createHeightSubBlock(heightMap, 0, split - 1, split);
        Vector3f origin2 = new Vector3f((float)(-halfSize) * this.stepScale.x, 0.0f, 0.0f);
        Vector2f tempOffset2 = new Vector2f();
        tempOffset2.x = this.offset.x;
        tempOffset2.y = this.offset.y;
        tempOffset2.x += origin1.x / 2.0f;
        tempOffset2.y += (float)quarterSize * this.stepScale.z;
        TerrainPatch patch2 = new TerrainPatch(this.getName() + "Patch2", split, this.stepScale, heightBlock2, origin2, this.totalSize, tempOffset2, this.offsetAmount);
        patch2.setQuadrant((short)2);
        this.attachChild((Spatial)patch2);
        patch2.setModelBound((BoundingVolume)new BoundingBox());
        patch2.updateModelBound();
        float[] heightBlock3 = this.createHeightSubBlock(heightMap, split - 1, 0, split);
        Vector3f origin3 = new Vector3f(0.0f, 0.0f, (float)(-halfSize) * this.stepScale.z);
        Vector2f tempOffset3 = new Vector2f();
        tempOffset3.x = this.offset.x;
        tempOffset3.y = this.offset.y;
        tempOffset3.x += (float)quarterSize * this.stepScale.x;
        tempOffset3.y += origin3.z / 2.0f;
        TerrainPatch patch3 = new TerrainPatch(this.getName() + "Patch3", split, this.stepScale, heightBlock3, origin3, this.totalSize, tempOffset3, this.offsetAmount);
        patch3.setQuadrant((short)3);
        this.attachChild((Spatial)patch3);
        patch3.setModelBound((BoundingVolume)new BoundingBox());
        patch3.updateModelBound();
        float[] heightBlock4 = this.createHeightSubBlock(heightMap, split - 1, split - 1, split);
        Vector3f origin4 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector2f tempOffset4 = new Vector2f();
        tempOffset4.x = this.offset.x;
        tempOffset4.y = this.offset.y;
        tempOffset4.x += (float)quarterSize * this.stepScale.x;
        tempOffset4.y += (float)quarterSize * this.stepScale.z;
        TerrainPatch patch4 = new TerrainPatch(this.getName() + "Patch4", split, this.stepScale, heightBlock4, origin4, this.totalSize, tempOffset4, this.offsetAmount);
        patch4.setQuadrant((short)4);
        this.attachChild((Spatial)patch4);
        patch4.setModelBound((BoundingVolume)new BoundingBox());
        patch4.updateModelBound();
    }

    public float[] createHeightSubBlock(float[] heightMap, int x, int y, int side) {
        float[] rVal = new float[side * side];
        int bsize = (int)FastMath.sqrt((float)heightMap.length);
        int count = 0;
        for (int i = y; i < side + y; ++i) {
            for (int j = x; j < side + x; ++j) {
                if (j < bsize && i < bsize) {
                    rVal[count] = heightMap[j + i * bsize];
                }
                ++count;
            }
        }
        return rVal;
    }

    public void attachBoundChildren(Node parent) {
        for (int i = 0; i < this.getQuantity(); ++i) {
            BoundingVolume bv;
            if (this.getChild(i) instanceof TerrainQuad) {
                ((TerrainQuad)this.getChild(i)).attachBoundChildren(parent);
                continue;
            }
            if (!(this.getChild(i) instanceof TerrainPatch) || !((bv = this.getChild(i).getWorldBound()) instanceof BoundingBox)) continue;
            this.attachBoundingBox((BoundingBox)bv, parent);
        }
        BoundingVolume bv = this.getWorldBound();
        if (bv instanceof BoundingBox) {
            this.attachBoundingBox((BoundingBox)bv, parent);
        }
    }

    private void attachBoundingBox(BoundingBox bb, Node parent) {
        WireBox wb = new WireBox(bb.getXExtent(), bb.getYExtent(), bb.getZExtent());
        Geometry g = new Geometry();
        g.setMesh((Mesh)wb);
        g.setLocalTranslation(bb.getCenter());
        parent.attachChild((Spatial)g);
    }

    protected void setNormalRecalcNeeded(Vector2f changedPoint) {
        if (changedPoint == null) {
            this.affectedAreaBBox = null;
            return;
        }
        if (this.affectedAreaBBox == null) {
            this.affectedAreaBBox = new BoundingBox(new Vector3f(changedPoint.x, 0.0f, changedPoint.y), 1.0f, Float.MAX_VALUE, 1.0f);
        } else {
            this.affectedAreaBBox.mergeLocal((BoundingVolume)new BoundingBox(new Vector3f(changedPoint.x, 0.0f, changedPoint.y), 1.0f, Float.MAX_VALUE, 1.0f));
        }
    }

    protected boolean needToRecalculateNormals() {
        if (this.affectedAreaBBox != null) {
            return true;
        }
        if (!this.lastScale.equals((Object)this.getWorldScale())) {
            this.affectedAreaBBox = new BoundingBox(this.getWorldTranslation(), Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            this.lastScale = this.getWorldScale();
            return true;
        }
        return false;
    }

    protected void setNeedToRecalculateNormals() {
        this.affectedAreaBBox = new BoundingBox(this.getWorldTranslation(), Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    }

    @Override
    public float getHeightmapHeight(Vector2f xz) {
        int z;
        int halfSize = this.totalSize / 2;
        int x = Math.round(xz.x / this.getWorldScale().x + (float)halfSize);
        if (!this.isInside(x, z = Math.round(xz.y / this.getWorldScale().z + (float)halfSize))) {
            return Float.NaN;
        }
        return this.getHeightmapHeight(x, z);
    }

    protected float getHeightmapHeight(int x, int z) {
        int quad = this.findQuadrant(x, z);
        int split = this.size + 1 >> 1;
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial spat = (Spatial)this.children.get(i);
                int col = x;
                int row = z;
                boolean match = false;
                int childQuadrant = 0;
                if (spat instanceof TerrainQuad) {
                    childQuadrant = ((TerrainQuad)spat).getQuadrant();
                } else if (spat instanceof TerrainPatch) {
                    childQuadrant = ((TerrainPatch)spat).getQuadrant();
                }
                if (childQuadrant == 1 && (quad & 1) != 0) {
                    match = true;
                } else if (childQuadrant == 2 && (quad & 2) != 0) {
                    row = z - split + 1;
                    match = true;
                } else if (childQuadrant == 3 && (quad & 4) != 0) {
                    col = x - split + 1;
                    match = true;
                } else if (childQuadrant == 4 && (quad & 8) != 0) {
                    col = x - split + 1;
                    row = z - split + 1;
                    match = true;
                }
                if (!match) continue;
                if (spat instanceof TerrainQuad) {
                    return ((TerrainQuad)spat).getHeightmapHeight(col, row);
                }
                if (!(spat instanceof TerrainPatch)) continue;
                return ((TerrainPatch)spat).getHeightmapHeight(col, row);
            }
        }
        return Float.NaN;
    }

    protected Vector3f getMeshNormal(int x, int z) {
        int quad = this.findQuadrant(x, z);
        int split = this.size + 1 >> 1;
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial spat = (Spatial)this.children.get(i);
                int col = x;
                int row = z;
                boolean match = false;
                int childQuadrant = 0;
                if (spat instanceof TerrainQuad) {
                    childQuadrant = ((TerrainQuad)spat).getQuadrant();
                } else if (spat instanceof TerrainPatch) {
                    childQuadrant = ((TerrainPatch)spat).getQuadrant();
                }
                if (childQuadrant == 1 && (quad & 1) != 0) {
                    match = true;
                } else if (childQuadrant == 2 && (quad & 2) != 0) {
                    row = z - split + 1;
                    match = true;
                } else if (childQuadrant == 3 && (quad & 4) != 0) {
                    col = x - split + 1;
                    match = true;
                } else if (childQuadrant == 4 && (quad & 8) != 0) {
                    col = x - split + 1;
                    row = z - split + 1;
                    match = true;
                }
                if (!match) continue;
                if (spat instanceof TerrainQuad) {
                    return ((TerrainQuad)spat).getMeshNormal(col, row);
                }
                if (!(spat instanceof TerrainPatch)) continue;
                return ((TerrainPatch)spat).getMeshNormal(col, row);
            }
        }
        return null;
    }

    private boolean isInside(int x, int z) {
        return x >= 0 && z >= 0 && x <= this.totalSize && z <= this.totalSize;
    }

    private QuadrantChild findMatchingChild(int x, int z) {
        int quad = this.findQuadrant(x, z);
        int split = this.size + 1 >> 1;
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial spat = (Spatial)this.children.get(i);
                int col = x;
                int row = z;
                boolean match = false;
                int childQuadrant = 0;
                if (spat instanceof TerrainQuad) {
                    childQuadrant = ((TerrainQuad)spat).getQuadrant();
                } else if (spat instanceof TerrainPatch) {
                    childQuadrant = ((TerrainPatch)spat).getQuadrant();
                }
                if (childQuadrant == 1 && (quad & 1) != 0) {
                    match = true;
                } else if (childQuadrant == 2 && (quad & 2) != 0) {
                    row = z - split + 1;
                    match = true;
                } else if (childQuadrant == 3 && (quad & 4) != 0) {
                    col = x - split + 1;
                    match = true;
                } else if (childQuadrant == 4 && (quad & 8) != 0) {
                    col = x - split + 1;
                    row = z - split + 1;
                    match = true;
                }
                if (!match) continue;
                return new QuadrantChild(col, row, spat);
            }
        }
        return null;
    }

    @Override
    public float getHeight(Vector2f xz) {
        float x = (xz.x - this.getWorldTranslation().x) / this.getWorldScale().x + (float)(this.totalSize - 1) / 2.0f;
        float z = (xz.y - this.getWorldTranslation().z) / this.getWorldScale().z + (float)(this.totalSize - 1) / 2.0f;
        if (!this.isInside((int)x, (int)z)) {
            return Float.NaN;
        }
        float height = this.getHeight((int)x, (int)z, x % 1.0f, z % 1.0f);
        return height *= this.getWorldScale().y;
    }

    protected float getHeight(int x, int z, float xm, float zm) {
        QuadrantChild match = this.findMatchingChild(x, z);
        if (match != null) {
            if (match.child instanceof TerrainQuad) {
                return ((TerrainQuad)match.child).getHeight(match.col, match.row, xm, zm);
            }
            if (match.child instanceof TerrainPatch) {
                return ((TerrainPatch)match.child).getHeight(match.col, match.row, xm, zm);
            }
        }
        return Float.NaN;
    }

    @Override
    public Vector3f getNormal(Vector2f xz) {
        float x = (xz.x - this.getWorldTranslation().x) / this.getWorldScale().x + (float)(this.totalSize - 1) / 2.0f;
        float z = (xz.y - this.getWorldTranslation().z) / this.getWorldScale().z + (float)(this.totalSize - 1) / 2.0f;
        Vector3f normal = this.getNormal(x, z, xz);
        return normal;
    }

    protected Vector3f getNormal(float x, float z, Vector2f xz) {
        float col = FastMath.floor((float)(x -= 0.5f));
        float row = FastMath.floor((float)(z -= 0.5f));
        boolean onX = false;
        if (1.0f - (x - col) - (z - row) < 0.0f) {
            onX = true;
        }
        Vector3f n1 = this.getMeshNormal((int)FastMath.ceil((float)x), (int)FastMath.ceil((float)z));
        Vector3f n2 = this.getMeshNormal((int)FastMath.floor((float)x), (int)FastMath.ceil((float)z));
        Vector3f n3 = this.getMeshNormal((int)FastMath.ceil((float)x), (int)FastMath.floor((float)z));
        Vector3f n4 = this.getMeshNormal((int)FastMath.floor((float)x), (int)FastMath.floor((float)z));
        return n1.add(n2).add(n3).add(n4).normalize();
    }

    @Override
    public void setHeight(Vector2f xz, float height) {
        ArrayList<Vector2f> coord = new ArrayList<Vector2f>();
        coord.add(xz);
        ArrayList<Float> h = new ArrayList<Float>();
        h.add(Float.valueOf(height));
        this.setHeight(coord, h);
    }

    @Override
    public void adjustHeight(Vector2f xz, float delta) {
        ArrayList<Vector2f> coord = new ArrayList<Vector2f>();
        coord.add(xz);
        ArrayList<Float> h = new ArrayList<Float>();
        h.add(Float.valueOf(delta));
        this.adjustHeight(coord, h);
    }

    @Override
    public void setHeight(List<Vector2f> xz, List<Float> height) {
        this.setHeight(xz, height, true);
    }

    @Override
    public void adjustHeight(List<Vector2f> xz, List<Float> height) {
        this.setHeight(xz, height, false);
    }

    protected void setHeight(List<Vector2f> xz, List<Float> height, boolean overrideHeight) {
        int i;
        if (xz.size() != height.size()) {
            throw new IllegalArgumentException("Both lists must be the same length!");
        }
        int halfSize = this.totalSize / 2;
        ArrayList<LocationHeight> locations = new ArrayList<LocationHeight>();
        for (i = 0; i < xz.size(); ++i) {
            int z;
            int x = Math.round(xz.get((int)i).x / this.getWorldScale().x + (float)halfSize);
            if (!this.isInside(x, z = Math.round(xz.get((int)i).y / this.getWorldScale().z + (float)halfSize))) continue;
            locations.add(new LocationHeight(x, z, height.get(i).floatValue()));
        }
        this.setHeight(locations, overrideHeight);
        for (i = 0; i < xz.size(); ++i) {
            this.setNormalRecalcNeeded(xz.get(i));
        }
    }

    protected void setHeight(List<LocationHeight> locations, boolean overrideHeight) {
        if (this.children == null) {
            return;
        }
        ArrayList<LocationHeight> quadLH1 = new ArrayList<LocationHeight>();
        ArrayList<LocationHeight> quadLH2 = new ArrayList<LocationHeight>();
        ArrayList<LocationHeight> quadLH3 = new ArrayList<LocationHeight>();
        ArrayList<LocationHeight> quadLH4 = new ArrayList<LocationHeight>();
        Spatial quad1 = null;
        Spatial quad2 = null;
        Spatial quad3 = null;
        Spatial quad4 = null;
        int i = this.children.size();
        while (--i >= 0) {
            Spatial spat = (Spatial)this.children.get(i);
            int childQuadrant = 0;
            if (spat instanceof TerrainQuad) {
                childQuadrant = ((TerrainQuad)spat).getQuadrant();
            } else if (spat instanceof TerrainPatch) {
                childQuadrant = ((TerrainPatch)spat).getQuadrant();
            }
            if (childQuadrant == 1) {
                quad1 = spat;
                continue;
            }
            if (childQuadrant == 2) {
                quad2 = spat;
                continue;
            }
            if (childQuadrant == 3) {
                quad3 = spat;
                continue;
            }
            if (childQuadrant != 4) continue;
            quad4 = spat;
        }
        int split = this.size + 1 >> 1;
        for (LocationHeight lh : locations) {
            int quad = this.findQuadrant(lh.x, lh.z);
            int col = lh.x;
            int row = lh.z;
            if ((quad & 1) != 0) {
                quadLH1.add(lh);
            }
            if ((quad & 2) != 0) {
                row = lh.z - split + 1;
                quadLH2.add(new LocationHeight(lh.x, row, lh.h));
            }
            if ((quad & 4) != 0) {
                col = lh.x - split + 1;
                quadLH3.add(new LocationHeight(col, lh.z, lh.h));
            }
            if ((quad & 8) == 0) continue;
            col = lh.x - split + 1;
            row = lh.z - split + 1;
            quadLH4.add(new LocationHeight(col, row, lh.h));
        }
        if (!quadLH1.isEmpty()) {
            if (quad1 instanceof TerrainQuad) {
                ((TerrainQuad)quad1).setHeight(quadLH1, overrideHeight);
            } else if (quad1 instanceof TerrainPatch) {
                ((TerrainPatch)quad1).setHeight(quadLH1, overrideHeight);
            }
        }
        if (!quadLH2.isEmpty()) {
            if (quad2 instanceof TerrainQuad) {
                ((TerrainQuad)quad2).setHeight(quadLH2, overrideHeight);
            } else if (quad2 instanceof TerrainPatch) {
                ((TerrainPatch)quad2).setHeight(quadLH2, overrideHeight);
            }
        }
        if (!quadLH3.isEmpty()) {
            if (quad3 instanceof TerrainQuad) {
                ((TerrainQuad)quad3).setHeight(quadLH3, overrideHeight);
            } else if (quad3 instanceof TerrainPatch) {
                ((TerrainPatch)quad3).setHeight(quadLH3, overrideHeight);
            }
        }
        if (!quadLH4.isEmpty()) {
            if (quad4 instanceof TerrainQuad) {
                ((TerrainQuad)quad4).setHeight(quadLH4, overrideHeight);
            } else if (quad4 instanceof TerrainPatch) {
                ((TerrainPatch)quad4).setHeight(quadLH4, overrideHeight);
            }
        }
    }

    protected boolean isPointOnTerrain(int x, int z) {
        return x >= 0 && x <= this.totalSize && z >= 0 && z <= this.totalSize;
    }

    @Override
    public int getTerrainSize() {
        return this.totalSize;
    }

    private int findQuadrant(int x, int y) {
        int split = this.size + 1 >> 1;
        int quads = 0;
        if (x < split && y < split) {
            quads |= 1;
        }
        if (x < split && y >= split - 1) {
            quads |= 2;
        }
        if (x >= split - 1 && y < split) {
            quads |= 4;
        }
        if (x >= split - 1 && y >= split - 1) {
            quads |= 8;
        }
        return quads;
    }

    @Override
    public void setLocked(boolean locked) {
        for (int i = 0; i < this.getQuantity(); ++i) {
            if (this.getChild(i) instanceof TerrainQuad) {
                ((TerrainQuad)this.getChild(i)).setLocked(locked);
                continue;
            }
            if (!(this.getChild(i) instanceof TerrainPatch)) continue;
            if (locked) {
                ((TerrainPatch)this.getChild(i)).lockMesh();
                continue;
            }
            ((TerrainPatch)this.getChild(i)).unlockMesh();
        }
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(short quadrant) {
        this.quadrant = quadrant;
    }

    protected TerrainPatch getPatch(int quad) {
        if (this.children != null) {
            int x = this.children.size();
            while (--x >= 0) {
                TerrainPatch tb;
                Spatial child = (Spatial)this.children.get(x);
                if (!(child instanceof TerrainPatch) || (tb = (TerrainPatch)child).getQuadrant() != quad) continue;
                return tb;
            }
        }
        return null;
    }

    protected TerrainQuad getQuad(int quad) {
        if (quad == 0) {
            return this;
        }
        if (this.children != null) {
            int x = this.children.size();
            while (--x >= 0) {
                TerrainQuad tq;
                Spatial child = (Spatial)this.children.get(x);
                if (!(child instanceof TerrainQuad) || (tq = (TerrainQuad)child).getQuadrant() != quad) continue;
                return tq;
            }
        }
        return null;
    }

    protected TerrainPatch findRightPatch(TerrainPatch tp) {
        TerrainQuad quad;
        if (tp.getQuadrant() == 1) {
            return this.getPatch(3);
        }
        if (tp.getQuadrant() == 2) {
            return this.getPatch(4);
        }
        if (tp.getQuadrant() == 3) {
            TerrainQuad quad2 = this.findRightQuad();
            if (quad2 != null) {
                return quad2.getPatch(1);
            }
        } else if (tp.getQuadrant() == 4 && (quad = this.findRightQuad()) != null) {
            return quad.getPatch(2);
        }
        return null;
    }

    protected TerrainPatch findDownPatch(TerrainPatch tp) {
        TerrainQuad quad;
        if (tp.getQuadrant() == 1) {
            return this.getPatch(2);
        }
        if (tp.getQuadrant() == 3) {
            return this.getPatch(4);
        }
        if (tp.getQuadrant() == 2) {
            TerrainQuad quad2 = this.findDownQuad();
            if (quad2 != null) {
                return quad2.getPatch(1);
            }
        } else if (tp.getQuadrant() == 4 && (quad = this.findDownQuad()) != null) {
            return quad.getPatch(3);
        }
        return null;
    }

    protected TerrainPatch findTopPatch(TerrainPatch tp) {
        TerrainQuad quad;
        if (tp.getQuadrant() == 2) {
            return this.getPatch(1);
        }
        if (tp.getQuadrant() == 4) {
            return this.getPatch(3);
        }
        if (tp.getQuadrant() == 1) {
            TerrainQuad quad2 = this.findTopQuad();
            if (quad2 != null) {
                return quad2.getPatch(2);
            }
        } else if (tp.getQuadrant() == 3 && (quad = this.findTopQuad()) != null) {
            return quad.getPatch(4);
        }
        return null;
    }

    protected TerrainPatch findLeftPatch(TerrainPatch tp) {
        TerrainQuad quad;
        if (tp.getQuadrant() == 3) {
            return this.getPatch(1);
        }
        if (tp.getQuadrant() == 4) {
            return this.getPatch(2);
        }
        if (tp.getQuadrant() == 1) {
            TerrainQuad quad2 = this.findLeftQuad();
            if (quad2 != null) {
                return quad2.getPatch(3);
            }
        } else if (tp.getQuadrant() == 2 && (quad = this.findLeftQuad()) != null) {
            return quad.getPatch(4);
        }
        return null;
    }

    protected TerrainQuad findRightQuad() {
        boolean useFinder = false;
        if (this.getParent() == null || !(this.getParent() instanceof TerrainQuad)) {
            if (this.neighbourFinder == null) {
                return null;
            }
            useFinder = true;
        }
        TerrainQuad pQuad = null;
        if (!useFinder) {
            pQuad = (TerrainQuad)this.getParent();
        }
        if (this.quadrant == 1) {
            return pQuad.getQuad(3);
        }
        if (this.quadrant == 2) {
            return pQuad.getQuad(4);
        }
        if (this.quadrant == 3) {
            TerrainQuad quad = pQuad.findRightQuad();
            if (quad != null) {
                return quad.getQuad(1);
            }
        } else if (this.quadrant == 4) {
            TerrainQuad quad = pQuad.findRightQuad();
            if (quad != null) {
                return quad.getQuad(2);
            }
        } else if (this.quadrant == 0 && useFinder) {
            TerrainQuad quad = this.neighbourFinder.getRightQuad(this);
            return quad;
        }
        return null;
    }

    protected TerrainQuad findDownQuad() {
        boolean useFinder = false;
        if (this.getParent() == null || !(this.getParent() instanceof TerrainQuad)) {
            if (this.neighbourFinder == null) {
                return null;
            }
            useFinder = true;
        }
        TerrainQuad pQuad = null;
        if (!useFinder) {
            pQuad = (TerrainQuad)this.getParent();
        }
        if (this.quadrant == 1) {
            return pQuad.getQuad(2);
        }
        if (this.quadrant == 3) {
            return pQuad.getQuad(4);
        }
        if (this.quadrant == 2) {
            TerrainQuad quad = pQuad.findDownQuad();
            if (quad != null) {
                return quad.getQuad(1);
            }
        } else if (this.quadrant == 4) {
            TerrainQuad quad = pQuad.findDownQuad();
            if (quad != null) {
                return quad.getQuad(3);
            }
        } else if (this.quadrant == 0 && useFinder) {
            TerrainQuad quad = this.neighbourFinder.getDownQuad(this);
            return quad;
        }
        return null;
    }

    protected TerrainQuad findTopQuad() {
        boolean useFinder = false;
        if (this.getParent() == null || !(this.getParent() instanceof TerrainQuad)) {
            if (this.neighbourFinder == null) {
                return null;
            }
            useFinder = true;
        }
        TerrainQuad pQuad = null;
        if (!useFinder) {
            pQuad = (TerrainQuad)this.getParent();
        }
        if (this.quadrant == 2) {
            return pQuad.getQuad(1);
        }
        if (this.quadrant == 4) {
            return pQuad.getQuad(3);
        }
        if (this.quadrant == 1) {
            TerrainQuad quad = pQuad.findTopQuad();
            if (quad != null) {
                return quad.getQuad(2);
            }
        } else if (this.quadrant == 3) {
            TerrainQuad quad = pQuad.findTopQuad();
            if (quad != null) {
                return quad.getQuad(4);
            }
        } else if (this.quadrant == 0 && useFinder) {
            TerrainQuad quad = this.neighbourFinder.getTopQuad(this);
            return quad;
        }
        return null;
    }

    protected TerrainQuad findLeftQuad() {
        boolean useFinder = false;
        if (this.getParent() == null || !(this.getParent() instanceof TerrainQuad)) {
            if (this.neighbourFinder == null) {
                return null;
            }
            useFinder = true;
        }
        TerrainQuad pQuad = null;
        if (!useFinder) {
            pQuad = (TerrainQuad)this.getParent();
        }
        if (this.quadrant == 3) {
            return pQuad.getQuad(1);
        }
        if (this.quadrant == 4) {
            return pQuad.getQuad(2);
        }
        if (this.quadrant == 1) {
            TerrainQuad quad = pQuad.findLeftQuad();
            if (quad != null) {
                return quad.getQuad(3);
            }
        } else if (this.quadrant == 2) {
            TerrainQuad quad = pQuad.findLeftQuad();
            if (quad != null) {
                return quad.getQuad(4);
            }
        } else if (this.quadrant == 0 && useFinder) {
            TerrainQuad quad = this.neighbourFinder.getLeftQuad(this);
            return quad;
        }
        return null;
    }

    protected void fixNormals(BoundingBox affectedArea) {
        if (this.children == null) {
            return;
        }
        int x = this.children.size();
        while (--x >= 0) {
            Spatial child = (Spatial)this.children.get(x);
            if (child instanceof TerrainQuad) {
                if (affectedArea == null || !affectedArea.intersects(child.getWorldBound())) continue;
                ((TerrainQuad)child).fixNormals(affectedArea);
                continue;
            }
            if (!(child instanceof TerrainPatch) || affectedArea == null || !affectedArea.intersects(child.getWorldBound())) continue;
            ((TerrainPatch)child).updateNormals();
        }
    }

    protected void fixNormalEdges(BoundingBox affectedArea) {
        if (this.children == null) {
            return;
        }
        int x = this.children.size();
        while (--x >= 0) {
            Spatial child = (Spatial)this.children.get(x);
            if (child instanceof TerrainQuad) {
                if (affectedArea == null || !affectedArea.intersects(child.getWorldBound())) continue;
                ((TerrainQuad)child).fixNormalEdges(affectedArea);
                continue;
            }
            if (!(child instanceof TerrainPatch) || affectedArea != null && !affectedArea.intersects(child.getWorldBound())) continue;
            TerrainPatch tp = (TerrainPatch)child;
            TerrainPatch right = this.findRightPatch(tp);
            TerrainPatch bottom = this.findDownPatch(tp);
            TerrainPatch top = this.findTopPatch(tp);
            TerrainPatch left = this.findLeftPatch(tp);
            TerrainPatch topLeft = null;
            if (top != null) {
                topLeft = this.findLeftPatch(top);
            }
            TerrainPatch bottomRight = null;
            if (right != null) {
                bottomRight = this.findDownPatch(right);
            }
            TerrainPatch topRight = null;
            if (top != null) {
                topRight = this.findRightPatch(top);
            }
            TerrainPatch bottomLeft = null;
            if (left != null) {
                bottomLeft = this.findDownPatch(left);
            }
            tp.fixNormalEdges(right, bottom, top, left, bottomRight, bottomLeft, topRight, topLeft);
        }
    }

    public int collideWith(Collidable other, CollisionResults results) {
        int total = 0;
        if (other instanceof Ray) {
            return this.collideWithRay((Ray)other, results);
        }
        if (other instanceof BoundingVolume && !this.getWorldBound().intersects((BoundingVolume)other)) {
            return total;
        }
        for (Spatial child : this.children) {
            total += child.collideWith(other, results);
        }
        return total;
    }

    public void findPick(Ray toTest, List<TerrainPickData> results) {
        if (this.getWorldBound() != null && this.getWorldBound().intersects(toTest)) {
            for (int i = 0; i < this.getQuantity(); ++i) {
                if (this.children.get(i) instanceof TerrainPatch) {
                    TerrainPatch tp = (TerrainPatch)((Object)this.children.get(i));
                    tp.ensurePositiveVolumeBBox();
                    if (!tp.getWorldBound().intersects(toTest)) continue;
                    CollisionResults cr = new CollisionResults();
                    toTest.collideWith((Collidable)tp.getWorldBound(), cr);
                    if (cr.getClosestCollision() == null) continue;
                    cr.getClosestCollision().getDistance();
                    results.add(new TerrainPickData(tp, cr.getClosestCollision()));
                    continue;
                }
                if (!(this.children.get(i) instanceof TerrainQuad)) continue;
                ((TerrainQuad)this.children.get(i)).findPick(toTest, results);
            }
        }
    }

    public void getAllTerrainPatches(List<TerrainPatch> holder) {
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).getAllTerrainPatches(holder);
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                holder.add((TerrainPatch)child);
            }
        }
    }

    public void getAllTerrainPatchesWithTranslation(Map<TerrainPatch, Vector3f> holder, Vector3f translation) {
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).getAllTerrainPatchesWithTranslation(holder, translation.clone().add(child.getLocalTranslation()));
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                holder.put((TerrainPatch)child, translation.clone().add(child.getLocalTranslation()));
            }
        }
    }

    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule c = e.getCapsule((Savable)this);
        this.size = c.readInt("size", 0);
        this.stepScale = (Vector3f)c.readSavable("stepScale", null);
        this.offset = (Vector2f)c.readSavable("offset", (Savable)new Vector2f(0.0f, 0.0f));
        this.offsetAmount = c.readFloat("offsetAmount", 0.0f);
        this.quadrant = c.readInt("quadrant", 0);
        this.totalSize = c.readInt("totalSize", 0);
        if (!(this.getParent() instanceof TerrainQuad)) {
            BoundingBox all;
            this.affectedAreaBBox = all = new BoundingBox(this.getWorldTranslation(), (float)this.totalSize, (float)this.totalSize, (float)this.totalSize);
            this.updateNormals();
        }
    }

    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule c = e.getCapsule((Savable)this);
        c.write(this.size, "size", 0);
        c.write(this.totalSize, "totalSize", 0);
        c.write((Savable)this.stepScale, "stepScale", null);
        c.write((Savable)this.offset, "offset", (Savable)new Vector2f(0.0f, 0.0f));
        c.write(this.offsetAmount, "offsetAmount", 0.0f);
        c.write(this.quadrant, "quadrant", 0);
    }

    public TerrainQuad clone() {
        return this.clone(true);
    }

    public TerrainQuad clone(boolean cloneMaterials) {
        NormalRecalcControl normalControl;
        TerrainQuad quadClone = (TerrainQuad)super.clone(cloneMaterials);
        quadClone.name = this.name.toString();
        quadClone.size = this.size;
        quadClone.totalSize = this.totalSize;
        if (this.stepScale != null) {
            quadClone.stepScale = this.stepScale.clone();
        }
        if (this.offset != null) {
            quadClone.offset = this.offset.clone();
        }
        quadClone.offsetAmount = this.offsetAmount;
        quadClone.quadrant = this.quadrant;
        TerrainLodControl lodControlCloned = (TerrainLodControl)this.getControl(TerrainLodControl.class);
        TerrainLodControl lodControl = (TerrainLodControl)quadClone.getControl(TerrainLodControl.class);
        if (lodControlCloned == null || !(this.getParent() instanceof TerrainQuad)) {
            // empty if block
        }
        if ((normalControl = (NormalRecalcControl)this.getControl(NormalRecalcControl.class)) != null) {
            normalControl.setTerrain(this);
        }
        return quadClone;
    }

    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.stepScale = (Vector3f)cloner.clone((Object)this.stepScale);
        this.offset = (Vector2f)cloner.clone((Object)this.offset);
        this.affectedAreaBBox = (BoundingBox)cloner.clone((Object)this.affectedAreaBBox);
        this.picker = new BresenhamTerrainPicker(this);
    }

    protected void setParent(Node parent) {
        super.setParent(parent);
        if (parent == null) {
            this.clearCaches();
        }
    }

    public void clearCaches() {
        if (this.children != null) {
            int i = this.children.size();
            while (--i >= 0) {
                Spatial child = (Spatial)this.children.get(i);
                if (child instanceof TerrainQuad) {
                    ((TerrainQuad)child).clearCaches();
                    continue;
                }
                if (!(child instanceof TerrainPatch)) continue;
                ((TerrainPatch)child).clearCaches();
            }
        }
    }

    @Override
    public int getMaxLod() {
        if (this.maxLod < 0) {
            this.maxLod = Math.max(1, (int)(FastMath.log((float)(this.size - 1)) / FastMath.log((float)2.0f)) - 1);
        }
        return this.maxLod;
    }

    public int getPatchSize() {
        return this.patchSize;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public float[] getHeightMap() {
        float[] hm = null;
        int length = (this.size - 1) / 2 + 1;
        int area = this.size * this.size;
        hm = new float[area];
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            float[] ul = null;
            float[] ur = null;
            float[] bl = null;
            float[] br = null;
            if (this.getChild(0) instanceof TerrainPatch) {
                for (Spatial s : this.getChildren()) {
                    if (((TerrainPatch)s).getQuadrant() == 1) {
                        ul = ((TerrainPatch)s).getHeightMap();
                        continue;
                    }
                    if (((TerrainPatch)s).getQuadrant() == 2) {
                        bl = ((TerrainPatch)s).getHeightMap();
                        continue;
                    }
                    if (((TerrainPatch)s).getQuadrant() == 3) {
                        ur = ((TerrainPatch)s).getHeightMap();
                        continue;
                    }
                    if (((TerrainPatch)s).getQuadrant() != 4) continue;
                    br = ((TerrainPatch)s).getHeightMap();
                }
            } else {
                ul = this.getQuad(1).getHeightMap();
                bl = this.getQuad(2).getHeightMap();
                ur = this.getQuad(3).getHeightMap();
                br = this.getQuad(4).getHeightMap();
            }
            for (int y = 0; y < length; ++y) {
                int row;
                for (int x1 = 0; x1 < length; ++x1) {
                    row = y * this.size;
                    hm[row + x1] = ul[y * length + x1];
                }
                for (int x2 = 1; x2 < length; ++x2) {
                    row = y * this.size + length;
                    hm[row + x2 - 1] = ur[y * length + x2];
                }
            }
            int rowOffset = this.size * length;
            for (int y = 1; y < length; ++y) {
                int row;
                for (int x1 = 0; x1 < length; ++x1) {
                    row = (y - 1) * this.size;
                    hm[rowOffset + row + x1] = bl[y * length + x1];
                }
                for (int x2 = 1; x2 < length; ++x2) {
                    row = (y - 1) * this.size + length;
                    hm[rowOffset + row + x2 - 1] = br[y * length + x2];
                }
            }
        }
        return hm;
    }

    public void setSupportMultipleCollisions(boolean set) {
        if (this.picker == null) {
            throw new NullPointerException("TerrainPicker is null");
        }
        if (!(this.picker instanceof BresenhamTerrainPicker)) {
            throw new IllegalStateException("The underlying picking implementation does not support multiple collisions");
        }
        ((BresenhamTerrainPicker)this.picker).setSupportMultipleCollisions(set);
    }

    protected class LocationHeight {
        int x;
        int z;
        float h;

        LocationHeight() {
        }

        LocationHeight(int x, int z, float h) {
            this.x = x;
            this.z = z;
            this.h = h;
        }
    }

    private class QuadrantChild {
        int col;
        int row;
        Spatial child;

        QuadrantChild(int col, int row, Spatial child) {
            this.col = col;
            this.row = row;
            this.child = child;
        }
    }
}

