/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.noise.filter;

import com.jme3.terrain.noise.Basis;
import com.jme3.terrain.noise.filter.AbstractFilter;
import java.nio.FloatBuffer;

public class HydraulicErodeFilter
extends AbstractFilter {
    private Basis waterMap;
    private Basis sedimentMap;
    private float Kr;
    private float Ks;
    private float Ke;
    private float Kc;
    private float T;

    public void setKc(float kc) {
        this.Kc = kc;
    }

    public void setKe(float ke) {
        this.Ke = ke;
    }

    public void setKr(float kr) {
        this.Kr = kr;
    }

    public void setKs(float ks) {
        this.Ks = ks;
    }

    public void setSedimentMap(Basis sedimentMap) {
        this.sedimentMap = sedimentMap;
    }

    public void setT(float t) {
        this.T = t;
    }

    public void setWaterMap(Basis waterMap) {
        this.waterMap = waterMap;
    }

    @Override
    public int getMargin(int size, int margin) {
        return super.getMargin(size, margin) + 1;
    }

    @Override
    public FloatBuffer filter(float sx, float sy, float base, FloatBuffer buffer, int workSize) {
        float[] ga = buffer.array();
        float[] wt = new float[workSize * workSize];
        float[] st = new float[workSize * workSize];
        int[] idxrel = new int[]{-workSize - 1, -workSize + 1, workSize - 1, workSize + 1};
        for (int y = 0; y < workSize; ++y) {
            for (int x = 0; x < workSize; ++x) {
                float smax;
                int idx = y * workSize + x;
                float wtemp = this.Kr;
                float stemp = this.Ks;
                if (wtemp > 0.0f) {
                    int n = idx;
                    wt[n] = wt[n] + wtemp;
                    if (stemp > 0.0f) {
                        int n2 = idx;
                        ga[n2] = ga[n2] - stemp * wt[idx];
                        int n3 = idx;
                        st[n3] = st[n3] + stemp * wt[idx];
                    }
                }
                float a = ga[idx] + wt[idx];
                float amax = 0.0f;
                int amaxidx = -1;
                float ac = 0.0f;
                float dtotal = 0.0f;
                for (int j = 0; j < idxrel.length; ++j) {
                    float at;
                    if (idx + idxrel[j] <= 0 || idx + idxrel[j] >= workSize || !(a - (at = ga[idx + idxrel[j]] + wt[idx + idxrel[j]]) > a - amax)) continue;
                    dtotal += at;
                    amax = at;
                    amaxidx = j;
                    ac += 1.0f;
                }
                float aa = (dtotal + a) / (ac + 1.0f);
                if (amaxidx > -1) {
                    float dwj = Math.min(wt[idx], a - aa) * (a - amax) / dtotal;
                    float dsj = st[idx] * dwj / wt[idx];
                    int n = idx;
                    wt[n] = wt[n] - dwj;
                    int n4 = idx;
                    st[n4] = st[n4] - dsj;
                    int n5 = idx + idxrel[amaxidx];
                    wt[n5] = wt[n5] + dwj;
                    int n6 = idx + idxrel[amaxidx];
                    st[n6] = st[n6] + dsj;
                }
                wt[idx] = wt[idx] * (1.0f - this.Ke);
                if (wt[idx] < this.T) {
                    wt[idx] = 0.0f;
                }
                if (!(st[idx] > (smax = this.Kc * wt[idx]))) continue;
                int n = idx;
                ga[n] = ga[n] + (st[idx] - smax);
                int n7 = idx;
                st[n7] = st[n7] - (st[idx] - smax);
            }
        }
        return buffer;
    }
}

