/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.noise.modulator;

import com.jme3.terrain.noise.ShaderUtils;
import com.jme3.terrain.noise.modulator.Modulator;
import java.util.HashMap;
import java.util.Map;

public class CatRom2
implements Modulator {
    private int sampleRate = 100;
    private final float[] table;
    private static Map<Integer, CatRom2> instances = new HashMap<Integer, CatRom2>();

    public CatRom2(int sampleRate) {
        this.sampleRate = sampleRate;
        this.table = new float[4 * sampleRate + 1];
        for (int i = 0; i < 4 * sampleRate + 1; ++i) {
            float x = (float)i / (float)sampleRate;
            this.table[i] = (x = (float)Math.sqrt(x)) < 1.0f ? 0.5f * (2.0f + x * x * (-5.0f + x * 3.0f)) : 0.5f * (4.0f + x * (-8.0f + x * (5.0f - x)));
        }
    }

    public static CatRom2 getInstance(int sampleRate) {
        if (!instances.containsKey(sampleRate)) {
            instances.put(sampleRate, new CatRom2(sampleRate));
        }
        return instances.get(sampleRate);
    }

    @Override
    public float value(float ... in) {
        if (in[0] >= 4.0f) {
            return 0.0f;
        }
        in[0] = in[0] * (float)this.sampleRate + 0.5f;
        int i = ShaderUtils.floor(in[0]);
        if (i >= 4 * this.sampleRate + 1) {
            return 0.0f;
        }
        return this.table[i];
    }
}

