/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.lodcalc;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class DistanceLodCalculator
implements LodCalculator {
    private int size;
    private float lodMultiplier = 2.0f;
    private boolean turnOffLod = false;

    public DistanceLodCalculator() {
    }

    public DistanceLodCalculator(int patchSize, float multiplier) {
        this.size = patchSize;
        this.lodMultiplier = multiplier;
    }

    @Override
    public boolean calculateLod(TerrainPatch terrainPatch, List<Vector3f> locations, HashMap<String, UpdatedTerrainPatch> updates) {
        if (locations == null || locations.isEmpty()) {
            return false;
        }
        float distance = this.getCenterLocation(terrainPatch).distance(locations.get(0));
        if (this.turnOffLod) {
            int prevLOD = terrainPatch.getLod();
            UpdatedTerrainPatch utp = updates.get(terrainPatch.getName());
            if (utp == null) {
                utp = new UpdatedTerrainPatch(terrainPatch);
                updates.put(utp.getName(), utp);
            }
            utp.setNewLod(0);
            utp.setPreviousLod(prevLOD);
            return true;
        }
        for (int i = 0; i <= terrainPatch.getMaxLod(); ++i) {
            if (!(distance < this.getLodDistanceThreshold() * (float)(i + 1) * terrainPatch.getWorldScaleCached().x) && i != terrainPatch.getMaxLod()) continue;
            boolean reIndexNeeded = false;
            if (i != terrainPatch.getLod()) {
                reIndexNeeded = true;
            }
            int prevLOD = terrainPatch.getLod();
            UpdatedTerrainPatch utp = updates.get(terrainPatch.getName());
            if (utp == null) {
                utp = new UpdatedTerrainPatch(terrainPatch);
                updates.put(utp.getName(), utp);
            }
            utp.setNewLod(i);
            utp.setPreviousLod(prevLOD);
            return reIndexNeeded;
        }
        return false;
    }

    protected Vector3f getCenterLocation(TerrainPatch terrainPatch) {
        Vector3f loc = terrainPatch.getWorldTranslationCached();
        loc.x += (float)terrainPatch.getSize() * terrainPatch.getWorldScaleCached().x / 2.0f;
        loc.z += (float)terrainPatch.getSize() * terrainPatch.getWorldScaleCached().z / 2.0f;
        return loc;
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.size, "patchSize", 32);
        oc.write(this.lodMultiplier, "lodMultiplier", 32.0f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule((Savable)this);
        this.size = ic.readInt("patchSize", 32);
        this.lodMultiplier = ic.readFloat("lodMultiplier", 32.0f);
    }

    @Override
    public LodCalculator clone() {
        DistanceLodCalculator clone = new DistanceLodCalculator(this.size, this.lodMultiplier);
        return clone;
    }

    public String toString() {
        return "DistanceLodCalculator " + this.size + "*" + this.lodMultiplier;
    }

    protected float getLodDistanceThreshold() {
        return (float)this.size * this.lodMultiplier;
    }

    @Override
    public boolean usesVariableLod() {
        return false;
    }

    public float getLodMultiplier() {
        return this.lodMultiplier;
    }

    public void setLodMultiplier(float lodMultiplier) {
        this.lodMultiplier = lodMultiplier;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void turnOffLod() {
        this.turnOffLod = true;
    }

    @Override
    public boolean isLodOff() {
        return this.turnOffLod;
    }

    @Override
    public void turnOnLod() {
        this.turnOffLod = false;
    }
}

