/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.terrain.heightmap.AbstractHeightMap;
import java.util.Random;
import java.util.logging.Logger;

public class HillHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(HillHeightMap.class.getName());
    private int iterations;
    private float minRadius;
    private float maxRadius;
    private long seed;

    public HillHeightMap(int size, int iterations, float minRadius, float maxRadius, long seed) throws Exception {
        if (size <= 0 || iterations <= 0 || minRadius <= 0.0f || maxRadius <= 0.0f || minRadius >= maxRadius) {
            throw new Exception("Either size of the terrain is not greater that zero, or number of iterations is not greater that zero, or minimum or maximum radius are not greater than zero, or minimum radius is greater than maximum radius, or power of flattening is below one");
        }
        logger.fine("Contructing hill heightmap using seed: " + seed);
        this.size = size;
        this.seed = seed;
        this.iterations = iterations;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.load();
    }

    public HillHeightMap(int size, int iterations, float minRadius, float maxRadius) throws Exception {
        this(size, iterations, minRadius, maxRadius, new Random().nextLong());
    }

    @Override
    public boolean load() {
        int i;
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new float[this.size * this.size];
        float[][] tempBuffer = new float[this.size][this.size];
        Random random = new Random(this.seed);
        for (i = 0; i < this.iterations; ++i) {
            this.addHill(tempBuffer, random);
        }
        for (i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.setHeightAtPoint(tempBuffer[i][j], j, i);
            }
        }
        this.normalizeTerrain(NORMALIZE_RANGE);
        logger.fine("Created Heightmap using the Hill Algorithm");
        return true;
    }

    protected void addHill(float[][] tempBuffer, Random random) {
        float radius = this.randomRange(random, this.minRadius, this.maxRadius);
        float x = this.randomRange(random, -radius, (float)this.size + radius);
        float y = this.randomRange(random, -radius, (float)this.size + radius);
        float radiusSq = radius * radius;
        int xMin = Math.round(x - radius - 1.0f);
        int xMax = Math.round(x + radius + 1.0f);
        int yMin = Math.round(y - radius - 1.0f);
        int yMax = Math.round(y + radius + 1.0f);
        if (xMin < 0) {
            xMin = 0;
        }
        if (xMax > this.size) {
            xMax = this.size - 1;
        }
        if (yMin < 0) {
            yMin = 0;
        }
        if (yMax > this.size) {
            yMax = this.size - 1;
        }
        for (int i = xMin; i <= xMax; ++i) {
            for (int j = yMin; j <= yMax; ++j) {
                float distSq = (x - (float)i) * (x - (float)i) + (y - (float)j) * (y - (float)j);
                float height = radiusSq - distSq;
                if (!(height > 0.0f)) continue;
                float[] fArray = tempBuffer[i];
                int n = j;
                fArray[n] = fArray[n] + height;
            }
        }
    }

    private float randomRange(Random random, float min, float max) {
        return (float)random.nextInt() * (max - min) / 2.1474836E9f + min;
    }

    public void setIterations(int iterations) throws Exception {
        if (iterations <= 0) {
            throw new Exception("Number of iterations is not greater than zero");
        }
        this.iterations = iterations;
    }

    public void setMaxRadius(float maxRadius) throws Exception {
        if (maxRadius <= 0.0f || maxRadius <= this.minRadius) {
            throw new Exception("The maximum radius is not greater than 0, or not greater than the minimum radius");
        }
        this.maxRadius = maxRadius;
    }

    public void setMinRadius(float minRadius) throws Exception {
        if (minRadius <= 0.0f || minRadius >= this.maxRadius) {
            throw new Exception("The minimum radius is not greater than 0, or not lower than the maximum radius");
        }
        this.minRadius = minRadius;
    }
}

