/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jmxtrans.embedded.EmbeddedJmxTrans;
import org.jmxtrans.embedded.QueryAttribute;
import org.jmxtrans.embedded.QueryMBean;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.Preconditions;
import org.jmxtrans.embedded.util.concurrent.DiscardingBlockingQueue;
import org.jmxtrans.embedded.util.jmx.JmxUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query
implements QueryMBean {
    private static final AtomicInteger queryIdSequence = new AtomicInteger();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private EmbeddedJmxTrans embeddedJmxTrans;
    private String id = "query-" + queryIdSequence.getAndIncrement();
    @Nonnull
    private ObjectName objectName;
    @Nullable
    private String resultAlias;
    @Nonnull
    private Map<String, QueryAttribute> attributesByName = new HashMap<String, QueryAttribute>();
    @Nonnull
    private String[] attributeNames = new String[0];
    @Nonnull
    private List<OutputWriter> outputWriters = new ArrayList<OutputWriter>();
    @Nonnull
    private BlockingQueue<QueryResult> queryResults = new DiscardingBlockingQueue<QueryResult>(200);
    @Nonnull
    private final AtomicInteger collectedMetricsCount = new AtomicInteger();
    @Nonnull
    private final AtomicLong collectionDurationInNanos = new AtomicLong();
    @Nonnull
    private final AtomicInteger collectionCount = new AtomicInteger();
    @Nonnull
    private final AtomicInteger exportedMetricsCount = new AtomicInteger();
    @Nonnull
    private final AtomicLong exportDurationInNanos = new AtomicLong();
    @Nonnull
    private final AtomicInteger exportCount = new AtomicInteger();
    @Nullable
    private ObjectName queryMbeanObjectName;

    public Query(@Nonnull String objectName) {
        try {
            this.objectName = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Exception parsing '" + objectName + "'", e);
        }
    }

    public Query(@Nonnull ObjectName objectName) {
        this.objectName = objectName;
    }

    @Override
    public void collectMetrics() {
        long nanosBefore = System.nanoTime();
        Set<ObjectName> matchingObjectNames = this.embeddedJmxTrans.getMbeanServer().queryNames(this.objectName, null);
        this.logger.trace("Query {} returned {}", (Object)this.objectName, matchingObjectNames);
        for (ObjectName matchingObjectName : matchingObjectNames) {
            long epochInMillis = System.currentTimeMillis();
            try {
                AttributeList jmxAttributes = this.embeddedJmxTrans.getMbeanServer().getAttributes(matchingObjectName, this.attributeNames);
                this.logger.trace("Query {} returned {}", (Object)matchingObjectName, (Object)jmxAttributes);
                for (Attribute jmxAttribute : jmxAttributes.asList()) {
                    QueryAttribute queryAttribute = this.attributesByName.get(jmxAttribute.getName());
                    Object value = jmxAttribute.getValue();
                    int count = queryAttribute.collectMetrics(matchingObjectName, value, epochInMillis, this.queryResults);
                    this.collectedMetricsCount.addAndGet(count);
                }
            }
            catch (Exception e) {
                this.logger.warn("Exception processing query {}", (Object)this, (Object)e);
            }
        }
        this.collectionCount.incrementAndGet();
        long nanosAfter = System.nanoTime();
        this.collectionDurationInNanos.addAndGet(nanosAfter - nanosBefore);
    }

    @Override
    public int exportCollectedMetrics() {
        int size;
        if (this.queryResults.isEmpty()) {
            return 0;
        }
        int totalExportedMetricsCount = 0;
        long nanosBefore = System.nanoTime();
        List<OutputWriter> effectiveOutputWriters = this.getEffectiveOutputWriters();
        int exportBatchSize = this.getEmbeddedJmxTrans().getExportBatchSize();
        ArrayList<QueryResult> availableQueryResults = new ArrayList<QueryResult>(exportBatchSize);
        while ((size = this.queryResults.drainTo(availableQueryResults, exportBatchSize)) > 0) {
            totalExportedMetricsCount += size;
            this.exportedMetricsCount.addAndGet(size);
            for (OutputWriter outputWriter : effectiveOutputWriters) {
                outputWriter.write(availableQueryResults);
            }
            availableQueryResults.clear();
        }
        this.exportDurationInNanos.addAndGet(System.nanoTime() - nanosBefore);
        this.exportCount.incrementAndGet();
        return totalExportedMetricsCount;
    }

    @PostConstruct
    public void start() throws Exception {
        this.queryMbeanObjectName = JmxUtils2.registerObject(this, "org.jmxtrans.embedded:Type=Query,id=" + this.id, this.getEmbeddedJmxTrans().getMbeanServer());
        for (OutputWriter outputWriter : this.outputWriters) {
            outputWriter.start();
        }
    }

    @PreDestroy
    public void stop() throws Exception {
        JmxUtils2.unregisterObject(this.queryMbeanObjectName, this.embeddedJmxTrans.getMbeanServer());
        for (OutputWriter outputWriter : this.outputWriters) {
            outputWriter.stop();
        }
    }

    @Override
    @Nonnull
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Nonnull
    public Collection<QueryAttribute> getQueryAttributes() {
        return this.attributesByName.values();
    }

    @Nonnull
    public Query addAttribute(@Nonnull QueryAttribute attribute) {
        attribute.setQuery(this);
        this.attributesByName.put(attribute.getName(), attribute);
        this.attributeNames = this.attributesByName.keySet().toArray(new String[0]);
        return this;
    }

    @Nonnull
    public Query addAttribute(@Nonnull String attributeName) {
        return this.addAttribute(new QueryAttribute(attributeName, null, null));
    }

    @Nonnull
    public BlockingQueue<QueryResult> getResults() {
        return this.queryResults;
    }

    public void setResultsQueue(@Nonnull BlockingQueue<QueryResult> queryResultQueue) {
        this.queryResults = Preconditions.checkNotNull(queryResultQueue);
    }

    public void setResultAlias(@Nullable String resultAlias) {
        this.resultAlias = resultAlias;
    }

    public EmbeddedJmxTrans getEmbeddedJmxTrans() {
        return this.embeddedJmxTrans;
    }

    public void setEmbeddedJmxTrans(EmbeddedJmxTrans embeddedJmxTrans) {
        this.embeddedJmxTrans = embeddedJmxTrans;
    }

    @Nonnull
    public List<OutputWriter> getEffectiveOutputWriters() {
        ArrayList<OutputWriter> result = new ArrayList<OutputWriter>(this.embeddedJmxTrans.getOutputWriters().size() + this.outputWriters.size());
        for (OutputWriter outputWriter : this.embeddedJmxTrans.getOutputWriters()) {
            if (!outputWriter.isEnabled()) continue;
            result.add(outputWriter);
        }
        for (OutputWriter outputWriter : this.outputWriters) {
            if (!outputWriter.isEnabled()) continue;
            result.add(outputWriter);
        }
        return result;
    }

    @Nonnull
    public List<OutputWriter> getOutputWriters() {
        return this.outputWriters;
    }

    @Override
    @Nullable
    public String getResultAlias() {
        return this.resultAlias;
    }

    public String toString() {
        return "Query{objectName=" + this.objectName + ", resultAlias='" + this.resultAlias + '\'' + ", outputWriters=" + this.outputWriters + ", attributes=" + this.attributesByName.values() + '}';
    }

    @Override
    public int getCollectedMetricsCount() {
        return this.collectedMetricsCount.get();
    }

    @Override
    public long getCollectionDurationInNanos() {
        return this.collectionDurationInNanos.get();
    }

    @Override
    public int getCollectionCount() {
        return this.collectionCount.get();
    }

    @Override
    public int getExportedMetricsCount() {
        return this.exportedMetricsCount.get();
    }

    @Override
    public long getExportDurationInNanos() {
        return this.exportDurationInNanos.get();
    }

    @Override
    public int getExportCount() {
        return this.exportCount.get();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getDiscardedResultsCount() {
        if (this.queryResults instanceof DiscardingBlockingQueue) {
            DiscardingBlockingQueue discardingBlockingQueue = (DiscardingBlockingQueue)this.queryResults;
            return discardingBlockingQueue.getDiscardedElementCount();
        }
        return -1;
    }
}

