/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.spring;

import java.util.ArrayList;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.spring.EmbeddedJmxTransFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EmbeddedJmxTransBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CONFIGURATION_ATTRIBUTE = "configuration";
    private static final String IGNORE_CONFIGURATION_NOT_FOUND_ATTRIBUTE = "ignore-configuration-not-found";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected Class getBeanClass(Element element) {
        return EmbeddedJmxTransFactory.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = element.getAttribute("id");
        return StringUtils.hasText((String)id) ? id : "jmxtrans";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setRole(0);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        if (element.hasAttribute(IGNORE_CONFIGURATION_NOT_FOUND_ATTRIBUTE)) {
            builder.addPropertyValue("ignoreConfigurationNotFound", (Object)element.getAttribute(IGNORE_CONFIGURATION_NOT_FOUND_ATTRIBUTE));
        }
        ArrayList<String> configurationUrls = new ArrayList<String>();
        if (element.hasAttribute(CONFIGURATION_ATTRIBUTE)) {
            String configurationUrl = element.getAttribute(CONFIGURATION_ATTRIBUTE);
            this.logger.debug("Add configuration from attribute {}", (Object)configurationUrl);
            configurationUrls.add(configurationUrl);
        }
        NodeList configurationNodeList = element.getElementsByTagNameNS(element.getNamespaceURI(), CONFIGURATION_ATTRIBUTE);
        for (int i = 0; i < configurationNodeList.getLength(); ++i) {
            Node node = configurationNodeList.item(i);
            if (!(node instanceof Element)) {
                throw new EmbeddedJmxTransException("Invalid configuration child element " + node);
            }
            String configurationUrl = node.getTextContent();
            this.logger.debug("Add configuration from attribute {}", (Object)configurationUrl);
            configurationUrls.add(configurationUrl);
        }
        builder.addPropertyValue("configurationUrls", configurationUrls);
    }
}

