/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoUtils2 {
    private static final Logger logger = LoggerFactory.getLogger(IoUtils2.class);

    private IoUtils2() {
    }

    public static OutputStream nullOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[512];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.debug("Exception closing quietly", (Throwable)e);
        }
    }
}

