/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.json;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import org.jmxtrans.embedded.util.json.PropertyPlaceholderResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceholderEnabledJsonNodeFactory
extends JsonNodeFactory {
    private static final long serialVersionUID = 1L;
    private final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PropertyPlaceholderResolver resolver = new PropertyPlaceholderResolver();

    public PlaceholderEnabledJsonNodeFactory(boolean bigDecimalExact) {
        super(bigDecimalExact);
    }

    public PlaceholderEnabledJsonNodeFactory() {
    }

    public TextNode textNode(String text) {
        String resolvedText = this.resolver.resolveString(text);
        if (this.logger.isInfoEnabled()) {
            if (text == null ? resolvedText == null : text.equals(resolvedText)) {
                this.logger.debug("Resolve '{}' into '{}'", (Object)text, (Object)resolvedText);
            } else {
                this.logger.info("Resolve '{}' into '{}'", (Object)text, (Object)resolvedText);
            }
        }
        return super.textNode(resolvedText);
    }
}

