/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.json;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.embedded.EmbeddedJmxTransException;

public class PropertyPlaceholderResolver
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Nonnull
    public String resolveString(@Nonnull String string) throws EmbeddedJmxTransException {
        StringBuilder result = new StringBuilder(string.length());
        int position = 0;
        while (position < string.length()) {
            char c = string.charAt(position);
            if (c == '$' && position < string.length() - 1 && string.charAt(position + 1) == '{') {
                String defaultValue;
                String placeholder;
                int beginningBracketPosition = position + 1;
                int endingBracketPosition = string.indexOf(125, beginningBracketPosition);
                int colonPosition = string.indexOf(58, beginningBracketPosition);
                if (colonPosition > endingBracketPosition) {
                    colonPosition = -1;
                }
                if (colonPosition == -1) {
                    placeholder = string.substring(beginningBracketPosition + 1, endingBracketPosition);
                    defaultValue = null;
                } else {
                    placeholder = string.substring(beginningBracketPosition + 1, colonPosition);
                    defaultValue = string.substring(colonPosition + 1, endingBracketPosition);
                }
                String resolvedPlaceHolder = this.resolvePlaceholder(placeholder, defaultValue);
                result.append(resolvedPlaceHolder);
                position = endingBracketPosition + 1;
                continue;
            }
            result.append(c);
            ++position;
        }
        return result.toString();
    }

    @Nonnull
    protected String resolvePlaceholder(String property, @Nullable String defaultValue) throws EmbeddedJmxTransException {
        String result;
        String environmentVariableStyleProperty = property.toUpperCase();
        environmentVariableStyleProperty = environmentVariableStyleProperty.replaceAll("\\.", "_");
        if (System.getProperties().containsKey(property)) {
            result = System.getProperty(property);
        } else if (System.getenv().containsKey(property)) {
            result = System.getenv(property);
        } else if (System.getenv().containsKey(environmentVariableStyleProperty)) {
            result = System.getenv(environmentVariableStyleProperty);
        } else if (defaultValue != null) {
            result = defaultValue;
        } else {
            throw new EmbeddedJmxTransException("Property '" + property + "' not found in System properties nor in Environment variables");
        }
        return result;
    }
}

