/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jmxtrans.embedded.util.StringUtils2;

class DeferredResultNameStrategyExpressionEvaluatorInitializer {
    DeferredResultNameStrategyExpressionEvaluatorInitializer() {
    }

    Map<String, Callable<String>> createInitialExpressionEvaluatorsMap() {
        final CachingCallable<InetAddress> localHostCallable = new CachingCallable<InetAddress>(new Callable<InetAddress>(){

            @Override
            public InetAddress call() throws Exception {
                return InetAddress.getLocalHost();
            }
        });
        final CachingCallable<String> hostnameCallable = new CachingCallable<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((InetAddress)localHostCallable.call()).getHostName();
            }
        });
        CachingCallable<String> reversedHostNameCallable = new CachingCallable<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return StringUtils2.reverseTokens((String)hostnameCallable.call(), ".");
            }
        });
        final CachingCallable<String> canonicalHostNameCallable = new CachingCallable<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((InetAddress)localHostCallable.call()).getCanonicalHostName();
            }
        });
        CachingCallable<String> reversedCanonicalHostNameCallable = new CachingCallable<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return StringUtils2.reverseTokens((String)canonicalHostNameCallable.call(), ".");
            }
        });
        final CachingCallable<String> hostAddressCallable = new CachingCallable<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((InetAddress)localHostCallable.call()).getHostAddress();
            }
        });
        CachingCallable<String> escapedHostNameCallable = new CachingCallable<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((String)hostnameCallable.call()).replaceAll("\\.", "_");
            }
        });
        CachingCallable<String> escapedCanonicalHostNameCallable = new CachingCallable<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((String)canonicalHostNameCallable.call()).replaceAll("\\.", "_");
            }
        });
        CachingCallable<String> escapedHostAddressCallable = new CachingCallable<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((String)hostAddressCallable.call()).replaceAll("\\.", "_");
            }
        });
        HashMap<String, Callable<String>> resultMap = new HashMap<String, Callable<String>>();
        resultMap.put("hostname", hostnameCallable);
        resultMap.put("reversed_hostname", reversedHostNameCallable);
        resultMap.put("escaped_hostname", escapedHostNameCallable);
        resultMap.put("canonical_hostname", canonicalHostNameCallable);
        resultMap.put("reversed_canonical_hostname", reversedCanonicalHostNameCallable);
        resultMap.put("escaped_canonical_hostname", escapedCanonicalHostNameCallable);
        resultMap.put("hostaddress", hostAddressCallable);
        resultMap.put("escaped_hostaddress", escapedHostAddressCallable);
        return resultMap;
    }

    private static class CachingCallable<T>
    implements Callable<T> {
        private final Callable<T> delegate;
        private CachedValueReference<T> cachedValueReference;

        public CachingCallable(Callable<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T call() throws Exception {
            CachedValueReference<T> valueRef = this.cachedValueReference;
            if (valueRef == null) {
                valueRef = new CachedValueReference<T>(this.delegate.call());
                this.cachedValueReference = valueRef;
            }
            return valueRef.getValue();
        }
    }

    private static class CachedValueReference<T> {
        private final T value;

        public CachedValueReference(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }
}

