/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.output.AbstractOutputWriter;
import org.jmxtrans.embedded.output.OutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvListWriter;
import org.supercsv.io.ICsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvWriter
extends AbstractOutputWriter
implements OutputWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ICsvListWriter csv;
    String outputFilePath;
    String[] header;
    private boolean firstWrite = true;

    @Override
    public void start() {
        OutputStreamWriter fileWriter;
        try {
            File outputFile = this.createOutputFile();
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            this.logger.debug("Started CSV output writer, writing to file: {}", (Object)outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.logger.error("Error opening file located at {}", (Object)this.outputFilePath);
            throw new RuntimeException(e);
        }
        this.csv = new CsvListWriter((Writer)fileWriter, CsvPreference.EXCEL_PREFERENCE);
    }

    @Override
    public void stop() throws IOException {
        this.csv.close();
    }

    @Override
    public void write(Iterable<QueryResult> results) {
        try {
            SortedMap<String, List<QueryResult>> splitResults = this.splitQueryResultsByTime(results);
            for (Map.Entry<String, List<QueryResult>> entry : splitResults.entrySet()) {
                List<QueryResult> sortedResults = entry.getValue();
                if (this.firstWrite) {
                    this.writeHeader(sortedResults);
                }
                this.writeBody(sortedResults, entry.getKey());
            }
        }
        catch (IOException e) {
            this.logger.error("Error writing header to file located at {}", (Object)this.outputFilePath);
            throw new RuntimeException(e);
        }
    }

    private void writeHeader(List<QueryResult> results) throws IOException {
        this.header = this.createHeader(results);
        try {
            this.csv.writeHeader(this.header);
        }
        finally {
            this.csv.flush();
        }
        this.firstWrite = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBody(List<QueryResult> results, String epoch) throws IOException {
        List<Object> alignedResults = this.alignResults(results, epoch);
        try {
            this.csv.write(alignedResults);
        }
        finally {
            this.csv.flush();
        }
    }

    private SortedMap<String, List<QueryResult>> splitQueryResultsByTime(Iterable<QueryResult> results) {
        TreeMap<String, List<QueryResult>> resultsByTime = new TreeMap<String, List<QueryResult>>();
        for (QueryResult result : results) {
            String epoch = String.valueOf(result.getEpoch(TimeUnit.SECONDS));
            if (resultsByTime.containsKey(epoch)) {
                List current = (List)resultsByTime.get(epoch);
                current.add(result);
                resultsByTime.put(epoch, current);
                continue;
            }
            ArrayList<QueryResult> newQueryList = new ArrayList<QueryResult>();
            newQueryList.add(result);
            resultsByTime.put(epoch, newQueryList);
        }
        return resultsByTime;
    }

    private File createOutputFile() throws IOException {
        if (this.outputFilePath == null) {
            this.outputFilePath = this.getStringSetting("outputFile", "jmxCsv.log");
        }
        File outputFile = new File(this.outputFilePath);
        FileUtils.forceMkdir((File)outputFile.getAbsoluteFile().getParentFile());
        return outputFile;
    }

    private String[] createHeader(List<QueryResult> results) {
        List<String> headerList = this.queryResultToHeader(results);
        headerList.add(0, "time");
        return headerList.toArray(new String[headerList.size()]);
    }

    List<Object> alignResults(List<QueryResult> results, String epoch) {
        Object[] alignedResults = new Object[results.size() + 1];
        List<String> headerList = Arrays.asList(this.header);
        alignedResults[0] = epoch;
        for (QueryResult result : results) {
            alignedResults[headerList.indexOf((Object)result.getName())] = result.getValue();
        }
        return Arrays.asList(alignedResults);
    }

    private List<String> queryResultToHeader(List<QueryResult> results) {
        ArrayList<String> header = new ArrayList<String>();
        for (QueryResult result : results) {
            header.add(result.getName());
        }
        return header;
    }
}

