/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.net.ssl;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jmxtrans.embedded.util.io.IoUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtils {
    @Nonnull
    public static SSLSocketFactory getSSLSocketFactory(@Nullable String keyStore, @Nullable String keyStorePassword, @Nullable String trustStore, @Nullable String trustStorePassword) {
        SSLContext sslContext = SslUtils.getSslContext(keyStore, keyStorePassword, trustStore, trustStorePassword);
        return sslContext.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static SSLContext getSslContext(@Nullable String keyStore, @Nullable String keyStorePassword, @Nullable String trustStore, @Nullable String trustStorePassword) {
        try {
            TrustManager[] trustManagers;
            KeyManager[] keyManagers;
            if (keyStore == null) {
                keyManagers = null;
            } else {
                char[] password = keyStorePassword == null ? null : keyStorePassword.toCharArray();
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                InputStream in = IoUtils2.getInputStream(keyStore);
                try {
                    ks.load(in, password);
                }
                finally {
                    IoUtils2.closeQuietly(in);
                }
                keyManagerFactory.init(ks, password);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            if (trustStore == null) {
                trustManagers = null;
            } else {
                char[] password = trustStorePassword == null ? null : trustStorePassword.toCharArray();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                InputStream in = IoUtils2.getInputStream(trustStore);
                try {
                    ks.load(in, password);
                }
                finally {
                    IoUtils2.closeQuietly(in);
                }
                trustManagerFactory.init(ks);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("NoSuchAlgorithmException loading SSLSocketFactory with keyStore=" + keyStore + ", keyStorePassword=" + (keyStorePassword == null ? "<null>" : "***") + ",trustStore=" + trustStore + ", trustStorePassword=" + (trustStorePassword == null ? "<null>" : "***") + ": " + e, e);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("FileNotFoundException loading SSLSocketFactory with keyStore=" + keyStore + ", keyStorePassword=" + (keyStorePassword == null ? "<null>" : "***") + ",trustStore=" + trustStore + ", trustStorePassword=" + (trustStorePassword == null ? "<null>" : "***") + ": " + e, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception loading SSLSocketFactory with keyStore=" + keyStore + ", keyStorePassword=" + (keyStorePassword == null ? "<null>" : "***") + ",trustStore=" + trustStore + ", trustStorePassword=" + (trustStorePassword == null ? "<null>" : "***") + ": " + e, e);
        }
    }

    @Nonnull
    public static SSLSocketFactory getTrustAllSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new TrustAllX509TrustManager()}, null);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (KeyManagementException e) {
            throw new IllegalStateException(e);
        }
    }

    private SslUtils() {
    }

    public static class TrustAllX509TrustManager
    implements X509TrustManager {
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("checkClientTrusted(authType=" + authType + ")");
                for (X509Certificate x509Certificate : x509Certificates) {
                    this.logger.debug(x509Certificate.toString());
                }
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("checkServerTrusted(authType=" + authType + ")");
                for (X509Certificate x509Certificate : x509Certificates) {
                    this.logger.debug(x509Certificate.toString());
                }
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

