/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.pool;

import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.jmxtrans.embedded.util.net.HostAndPort;
import org.jmxtrans.embedded.util.net.SocketOutputStream;

public class SocketOutputStreamPoolFactory
extends BaseKeyedPooledObjectFactory<HostAndPort, SocketOutputStream>
implements KeyedPooledObjectFactory<HostAndPort, SocketOutputStream> {
    public static final int DEFAULT_SOCKET_CONNECT_TIMEOUT_IN_MILLIS = 500;
    private final int socketConnectTimeoutInMillis;

    public SocketOutputStreamPoolFactory(int socketConnectTimeoutInMillis) {
        this.socketConnectTimeoutInMillis = socketConnectTimeoutInMillis;
    }

    public SocketOutputStream create(HostAndPort hostAndPort) throws Exception {
        Socket socket = new Socket();
        socket.setKeepAlive(true);
        socket.connect(new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort()), this.socketConnectTimeoutInMillis);
        return new SocketOutputStream(socket);
    }

    public PooledObject<SocketOutputStream> wrap(SocketOutputStream outputStream) {
        return new DefaultPooledObject((Object)outputStream);
    }

    public void destroyObject(HostAndPort hostAndPort, PooledObject<SocketOutputStream> socketOutputStreamRef) throws Exception {
        SocketOutputStream socketOutputStream = (SocketOutputStream)socketOutputStreamRef.getObject();
        socketOutputStream.close();
        socketOutputStream.getSocket().close();
    }

    public boolean validateObject(HostAndPort hostAndPort, PooledObject<SocketOutputStream> socketOutputStreamRef) {
        Socket socket = ((SocketOutputStream)socketOutputStreamRef.getObject()).getSocket();
        return socket.isConnected() && socket.isBound() && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }
}

