/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.xtend.core.XtendStandaloneSetup;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXtend2CompilerMojo
extends AbstractMojo {
    protected static final Predicate<String> FILE_EXISTS = new Predicate<String>(){

        public boolean apply(String filePath) {
            return new File(filePath).exists();
        }
    };
    protected MavenProject project;
    protected String encoding;
    protected boolean skipXtend;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipped()) {
            this.getLog().info((CharSequence)"Xtend compiler skipped.");
        }
        this.configureLog4j();
        XtendBatchCompiler xtendBatchCompiler = this.createXtendBatchCompiler();
        this.internalExecute(xtendBatchCompiler);
    }

    protected boolean isSkipped() {
        return this.skipXtend;
    }

    protected abstract void internalExecute(XtendBatchCompiler var1) throws MojoExecutionException;

    protected XtendBatchCompiler createXtendBatchCompiler() {
        Injector injector = new XtendStandaloneSetup().createInjectorAndDoEMFRegistration();
        return (XtendBatchCompiler)injector.getInstance(XtendBatchCompiler.class);
    }

    protected void compile(XtendBatchCompiler xtend2BatchCompiler, String classPath, List<String> sourceDirectories, String outputPath) throws MojoExecutionException {
        Iterable filtered = Iterables.filter(sourceDirectories, FILE_EXISTS);
        if (Iterables.isEmpty((Iterable)filtered)) {
            this.getLog().info((CharSequence)("skip compiling sources because the configured directory '" + Iterables.toString(sourceDirectories) + "' does not exists."));
            return;
        }
        this.getLog().debug((CharSequence)("Set temp directory: " + this.getTempDirectory()));
        xtend2BatchCompiler.setTempDirectory(this.getTempDirectory());
        this.getLog().debug((CharSequence)"Set DeleteTempDirectory: false");
        xtend2BatchCompiler.setDeleteTempDirectory(false);
        this.getLog().debug((CharSequence)("Set classpath: " + classPath));
        xtend2BatchCompiler.setClassPath(classPath);
        this.getLog().debug((CharSequence)("Set source path: " + Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered))));
        xtend2BatchCompiler.setSourcePath(Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered)));
        this.getLog().debug((CharSequence)("Set output path: " + outputPath));
        xtend2BatchCompiler.setOutputPath(outputPath);
        this.getLog().debug((CharSequence)("Set encoding: " + this.encoding));
        xtend2BatchCompiler.setFileEncoding(this.encoding);
        if (!xtend2BatchCompiler.compile()) {
            throw new MojoExecutionException("Error compiling xtend sources in '" + Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered)) + "'.");
        }
    }

    protected abstract String getTempDirectory();

    protected void configureLog4j() {
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
            Logger.getRootLogger().addAppender((Appender)this.createMojoLogAppender());
        } else {
            Logger logger = Logger.getLogger((String)"org.eclipse.xtext");
            logger.setAdditivity(false);
            logger.setLevel(Level.DEBUG);
            logger.removeAllAppenders();
            logger.addAppender((Appender)this.createMojoLogAppender());
        }
    }

    protected AppenderSkeleton createMojoLogAppender() {
        return new AppenderSkeleton(){

            public void close() {
            }

            public boolean requiresLayout() {
                return false;
            }

            protected void append(LoggingEvent event) {
                if (event.getMessage() == null) {
                    return;
                }
                if (Level.DEBUG == event.getLevel()) {
                    AbstractXtend2CompilerMojo.this.getLog().debug((CharSequence)event.getMessage(), this.getThrowable(event));
                } else if (Level.INFO == event.getLevel()) {
                    AbstractXtend2CompilerMojo.this.getLog().info((CharSequence)event.getMessage(), this.getThrowable(event));
                } else if (Level.WARN == event.getLevel()) {
                    AbstractXtend2CompilerMojo.this.getLog().warn((CharSequence)event.getMessage(), this.getThrowable(event));
                } else if (Level.ERROR == event.getLevel()) {
                    AbstractXtend2CompilerMojo.this.getLog().error((CharSequence)event.getMessage(), this.getThrowable(event));
                }
            }

            private Throwable getThrowable(LoggingEvent event) {
                return event.getThrowableInformation() != null ? event.getThrowableInformation().getThrowable() : null;
            }
        };
    }

    protected void addDependencies(Set<String> classPath, List<Artifact> dependencies) {
        for (Artifact artifact : dependencies) {
            classPath.add(artifact.getFile().getAbsolutePath());
        }
    }
}

