/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;
import org.eclipse.xtend.maven.AbstractXtend2CompilerMojo;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendCompile
extends AbstractXtend2CompilerMojo {
    private String outputDirectory;
    private String tempDirectory;

    @Override
    protected void internalExecute(XtendBatchCompiler xtend2BatchCompiler) throws MojoExecutionException {
        this.compileSources(xtend2BatchCompiler);
    }

    private void compileSources(XtendBatchCompiler xtend2BatchCompiler) throws MojoExecutionException {
        ArrayList compileSourceRoots = Lists.newArrayList((Iterable)this.project.getCompileSourceRoots());
        String classPath = Strings.concat((String)File.pathSeparator, this.getClassPath());
        this.project.addCompileSourceRoot(this.outputDirectory);
        this.compile(xtend2BatchCompiler, classPath, compileSourceRoots, this.outputDirectory);
    }

    protected List<String> getClassPath() {
        LinkedHashSet classPath = Sets.newLinkedHashSet();
        classPath.add(this.project.getBuild().getSourceDirectory());
        try {
            classPath.addAll(this.project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        this.addDependencies(classPath, this.project.getCompileArtifacts());
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)classPath, (Predicate)FILE_EXISTS));
    }

    @Override
    protected String getTempDirectory() {
        return this.tempDirectory;
    }
}

