/*
 * Decompiled with CFR 0.152.
 */
package org.jnario.maven;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;
import org.eclipse.xtend.maven.XtendTestCompile;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.util.Strings;
import org.jnario.compiler.HtmlAssetsCompiler;
import org.jnario.compiler.JnarioDocCompiler;
import org.jnario.feature.FeatureStandaloneSetup;
import org.jnario.report.Executable2ResultMapping;
import org.jnario.report.HashBasedSpec2ResultMapping;
import org.jnario.report.SpecExecutionAcceptor;
import org.jnario.report.SpecResultParser;
import org.jnario.spec.SpecStandaloneSetup;
import org.jnario.suite.SuiteStandaloneSetup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JnarioDocGenerate
extends XtendTestCompile {
    private String docOutputDirectory;
    private String reportsDirectory;
    private boolean skipDocGeneration;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skipDocGeneration) {
            this.getLog().info((CharSequence)"Jnario Report Generator skipped.");
        }
        this.configureLog4j();
        this.getLog().info((CharSequence)("Generating Jnario reports to " + this.docOutputDirectory));
        List<Injector> injectors = this.createInjectors(new ISetup[]{new SpecStandaloneSetup(), new FeatureStandaloneSetup(), new SuiteStandaloneSetup()});
        this.generateCssAndJsFiles(injectors);
        HashBasedSpec2ResultMapping resultMapping = this.createSpec2ResultMapping(injectors);
        ResourceSet resourceSet = this.createResourceSet(injectors);
        for (Injector injector : injectors) {
            this.generateDoc(resourceSet, injector, (Executable2ResultMapping)resultMapping);
        }
    }

    protected HashBasedSpec2ResultMapping createSpec2ResultMapping(List<Injector> injectors) throws MojoExecutionException {
        HashBasedSpec2ResultMapping resultMapping = (HashBasedSpec2ResultMapping)injectors.get(2).getInstance(HashBasedSpec2ResultMapping.class);
        File reportFolder = new File(this.reportsDirectory);
        if (!reportFolder.exists()) {
            throw new MojoExecutionException("Surefire Report folder does not exist");
        }
        this.addExecutionResults(resultMapping, reportFolder);
        return resultMapping;
    }

    protected void generateCssAndJsFiles(List<Injector> injectors) {
        HtmlAssetsCompiler assetsCompiler = (HtmlAssetsCompiler)injectors.get(0).getInstance(HtmlAssetsCompiler.class);
        assetsCompiler.setOutputPath(this.docOutputDirectory);
        this.getLog().info((CharSequence)("Generating HTML assets to " + this.docOutputDirectory));
        assetsCompiler.compile();
    }

    protected void addExecutionResults(HashBasedSpec2ResultMapping resultMapping, File reportFolder) throws MojoExecutionException {
        SpecResultParser specResultParser = new SpecResultParser();
        for (File file : reportFolder.listFiles(new XmlFiles())) {
            FileInputStream is = null;
            try {
                this.getLog().info((CharSequence)("Parsing Results: " + file));
                is = new FileInputStream(file);
                specResultParser.parse((InputStream)is, (SpecExecutionAcceptor)resultMapping);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Exception while parsing spec for: " + file, e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    protected void compileTestSources(XtendBatchCompiler xtend2BatchCompiler) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Using source folders: " + this.project.getTestCompileSourceRoots()));
        ArrayList testCompileSourceRoots = Lists.newArrayList((Iterable)this.project.getTestCompileSourceRoots());
        String testClassPath = Strings.concat((String)File.pathSeparator, this.getTestClassPath());
        this.project.addTestCompileSourceRoot(this.docOutputDirectory);
        this.compile(xtend2BatchCompiler, testClassPath, testCompileSourceRoots, this.docOutputDirectory);
    }

    private void generateDoc(ResourceSet resourceSet, Injector injector, Executable2ResultMapping resultMapping) throws MojoExecutionException {
        JnarioDocCompiler docCompiler = (JnarioDocCompiler)injector.getInstance(JnarioDocCompiler.class);
        docCompiler.setResourceSet(resourceSet);
        docCompiler.setExecutable2ResultMapping(resultMapping);
        this.internalExecute((XtendBatchCompiler)docCompiler);
    }

    private ResourceSet createResourceSet(List<Injector> injectors) {
        Provider resourceSetProvider = injectors.get(0).getProvider(ResourceSet.class);
        ResourceSet resourceSet = (ResourceSet)resourceSetProvider.get();
        return resourceSet;
    }

    private List<Injector> createInjectors(ISetup ... setups) {
        return Lists.transform(Arrays.asList(setups), (Function)new Function<ISetup, Injector>(){

            public Injector apply(ISetup input) {
                return input.createInjectorAndDoEMFRegistration();
            }
        });
    }

    @Override
    protected List<String> getTestClassPath() {
        List<String> classpath = super.getTestClassPath();
        if (classpath.isEmpty()) {
            classpath.add(this.project.getBasedir() + "/src");
        }
        return classpath;
    }

    private final class XmlFiles
    implements FilenameFilter {
        private XmlFiles() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith("xml");
        }
    }
}

