/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.jnosql.artemis.PreparedStatementAsync;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentQuery;

public interface DocumentTemplateAsync {
    public <T> void insert(T var1);

    public <T> void insert(T var1, Duration var2);

    default public <T> void insert(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(this::insert);
    }

    default public <T> void insert(Iterable<T> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(d -> this.insert(d, ttl));
    }

    public <T> void insert(T var1, Consumer<T> var2);

    public <T> void insert(T var1, Duration var2, Consumer<T> var3);

    public <T> void update(T var1, Consumer<T> var2);

    public <T> void update(T var1);

    default public <T> void update(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(this::update);
    }

    public void delete(DocumentDeleteQuery var1);

    public void delete(DocumentDeleteQuery var1, Consumer<Void> var2);

    public <T> void select(DocumentQuery var1, Consumer<List<T>> var2);

    public <T> void query(String var1, Consumer<List<T>> var2);

    public <T> void singleResult(String var1, Consumer<Optional<T>> var2);

    public PreparedStatementAsync prepare(String var1);

    public <T, ID> void find(Class<T> var1, ID var2, Consumer<Optional<T>> var3);

    public <T, ID> void delete(Class<T> var1, ID var2, Consumer<Void> var3);

    public <T, ID> void delete(Class<T> var1, ID var2);

    public void count(String var1, Consumer<Long> var2);

    public <T> void count(Class<T> var1, Consumer<Long> var2);

    default public <T> void singleResult(DocumentQuery query, Consumer<Optional<T>> callBack) {
        Objects.requireNonNull(callBack, "callBack is required");
        Consumer<List<T>> singleCallBack = entities -> {
            if (entities.isEmpty()) {
                callBack.accept(Optional.empty());
            } else if (entities.size() == 1) {
                callBack.accept(Optional.of(entities.get(0)));
            } else {
                throw new NonUniqueResultException("The query returns more than one entity, query: " + query);
            }
        };
        this.select(query, singleCallBack);
    }
}

