/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.RepositoryAsync;
import org.jnosql.artemis.document.DocumentRepositoryAsyncProducer;
import org.jnosql.artemis.document.DocumentTemplateAsync;
import org.jnosql.artemis.document.DocumentTemplateAsyncProducer;
import org.jnosql.artemis.document.query.DocumentRepositoryAsyncProxy;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.Reflections;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;

@ApplicationScoped
class DefaultDocumentRepositoryAsyncProducer
implements DocumentRepositoryAsyncProducer {
    @Inject
    private ClassRepresentations classRepresentations;
    @Inject
    private Reflections reflections;
    @Inject
    private Converters converters;
    @Inject
    private DocumentTemplateAsyncProducer producer;

    DefaultDocumentRepositoryAsyncProducer() {
    }

    @Override
    public <E, ID, T extends RepositoryAsync<E, ID>> T get(Class<T> repositoryClass, DocumentCollectionManagerAsync manager) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(manager, "manager class is required");
        Object template = this.producer.get(manager);
        return this.get(repositoryClass, (DocumentTemplateAsync)template);
    }

    @Override
    public <E, ID, T extends RepositoryAsync<E, ID>> T get(Class<T> repositoryClass, DocumentTemplateAsync template) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(template, "template class is required");
        DocumentRepositoryAsyncProxy handler = new DocumentRepositoryAsyncProxy(template, this.classRepresentations, repositoryClass, this.reflections, this.converters);
        return (T)((RepositoryAsync)Proxy.newProxyInstance(repositoryClass.getClassLoader(), new Class[]{repositoryClass}, handler));
    }
}

