/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.ParameterizedType;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.query.AbstractDocumentRepository;
import org.jnosql.artemis.document.query.AbstractDocumentRepositoryProxy;
import org.jnosql.artemis.document.query.DocumentQueryDeleteParser;
import org.jnosql.artemis.document.query.DocumentQueryParser;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.artemis.reflection.Reflections;

class DocumentRepositoryProxy<T>
extends AbstractDocumentRepositoryProxy<T> {
    private final DocumentTemplate template;
    private final DocumentRepository repository;
    private final ClassRepresentation classRepresentation;
    private final DocumentQueryParser queryParser;
    private final DocumentQueryDeleteParser deleteQueryParser;
    private final Converters converters;

    DocumentRepositoryProxy(DocumentTemplate template, ClassRepresentations classRepresentations, Class<?> repositoryType, Reflections reflections, Converters converters) {
        this.template = template;
        Class typeClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(repositoryType.getGenericInterfaces()[0])).getActualTypeArguments()[0]);
        this.classRepresentation = classRepresentations.get(typeClass);
        this.repository = new DocumentRepository(template, this.classRepresentation, reflections);
        this.queryParser = new DocumentQueryParser();
        this.deleteQueryParser = new DocumentQueryDeleteParser();
        this.converters = converters;
    }

    @Override
    protected Repository getRepository() {
        return this.repository;
    }

    @Override
    protected DocumentQueryParser getQueryParser() {
        return this.queryParser;
    }

    @Override
    protected DocumentTemplate getTemplate() {
        return this.template;
    }

    @Override
    protected DocumentQueryDeleteParser getDeleteParser() {
        return this.deleteQueryParser;
    }

    @Override
    protected ClassRepresentation getClassRepresentation() {
        return this.classRepresentation;
    }

    @Override
    protected Converters getConverters() {
        return this.converters;
    }

    class DocumentRepository
    extends AbstractDocumentRepository
    implements Repository {
        private final DocumentTemplate template;
        private final ClassRepresentation classRepresentation;
        private final Reflections reflections;

        DocumentRepository(DocumentTemplate template, ClassRepresentation classRepresentation, Reflections reflections) {
            this.template = template;
            this.classRepresentation = classRepresentation;
            this.reflections = reflections;
        }

        @Override
        protected DocumentTemplate getTemplate() {
            return this.template;
        }

        @Override
        protected ClassRepresentation getClassRepresentation() {
            return this.classRepresentation;
        }

        @Override
        protected Reflections getReflections() {
            return this.reflections;
        }
    }
}

