/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.column.ColumnDeleteQuery;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnObserverParser;
import org.jnosql.diana.api.column.ColumnPreparedStatement;
import org.jnosql.diana.api.column.ColumnQuery;
import org.jnosql.diana.api.column.ColumnQueryParser;

public interface ColumnFamilyManager
extends AutoCloseable {
    public ColumnEntity insert(ColumnEntity var1);

    public ColumnEntity update(ColumnEntity var1);

    default public Iterable<ColumnEntity> update(Iterable<ColumnEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::update).collect(Collectors.toList());
    }

    public ColumnEntity insert(ColumnEntity var1, Duration var2);

    default public Iterable<ColumnEntity> insert(Iterable<ColumnEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).collect(Collectors.toList());
    }

    default public Iterable<ColumnEntity> insert(Iterable<ColumnEntity> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(c -> this.insert((ColumnEntity)c, ttl)).collect(Collectors.toList());
    }

    public void delete(ColumnDeleteQuery var1);

    public List<ColumnEntity> select(ColumnQuery var1);

    default public List<ColumnEntity> query(String query) {
        Objects.requireNonNull(query, "query is required");
        ColumnQueryParser parser = ColumnQueryParser.getParser();
        return parser.query(query, this, ColumnObserverParser.EMPTY);
    }

    default public ColumnPreparedStatement prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        ColumnQueryParser parser = ColumnQueryParser.getParser();
        return parser.prepare(query, this, ColumnObserverParser.EMPTY);
    }

    default public Optional<ColumnEntity> singleResult(ColumnQuery query) {
        List<ColumnEntity> entities = this.select(query);
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        if (entities.size() == 1) {
            return Optional.of(entities.get(0));
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + query);
    }

    public long count(String var1);

    @Override
    public void close();
}

