/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.column.ColumnDeleteQuery;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnObserverParser;
import org.jnosql.diana.api.column.ColumnPreparedStatementAsync;
import org.jnosql.diana.api.column.ColumnQuery;
import org.jnosql.diana.api.column.ColumnQueryParserAsync;

public interface ColumnFamilyManagerAsync
extends AutoCloseable {
    public void insert(ColumnEntity var1);

    public void insert(ColumnEntity var1, Duration var2);

    public void insert(ColumnEntity var1, Consumer<ColumnEntity> var2);

    default public void insert(Iterable<ColumnEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(this::insert);
    }

    default public void insert(Iterable<ColumnEntity> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(c -> this.insert((ColumnEntity)c, ttl));
    }

    public void insert(ColumnEntity var1, Duration var2, Consumer<ColumnEntity> var3);

    public void update(ColumnEntity var1);

    default public void update(Iterable<ColumnEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        StreamSupport.stream(entities.spliterator(), false).forEach(this::update);
    }

    public void update(ColumnEntity var1, Consumer<ColumnEntity> var2);

    public void delete(ColumnDeleteQuery var1);

    public void delete(ColumnDeleteQuery var1, Consumer<Void> var2);

    public void select(ColumnQuery var1, Consumer<List<ColumnEntity>> var2);

    default public void query(String query, Consumer<List<ColumnEntity>> callBack) {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callBack, "callBack is required");
        ColumnQueryParserAsync parser = ColumnQueryParserAsync.getParser();
        parser.query(query, this, callBack, ColumnObserverParser.EMPTY);
    }

    default public ColumnPreparedStatementAsync prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        ColumnQueryParserAsync parser = ColumnQueryParserAsync.getParser();
        return parser.prepare(query, this, ColumnObserverParser.EMPTY);
    }

    default public void singleResult(ColumnQuery query, Consumer<Optional<ColumnEntity>> callBack) {
        this.select(query, entities -> {
            if (entities.isEmpty()) {
                callBack.accept(Optional.empty());
                return;
            }
            if (entities.size() == 1) {
                callBack.accept(Optional.of(entities.get(0)));
                return;
            }
            throw new NonUniqueResultException("The select returns more than one entity, select: " + query);
        });
    }

    public void count(String var1, Consumer<Long> var2);

    @Override
    public void close();
}

