/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.Arrays;
import java.util.Objects;
import org.jnosql.diana.api.column.Column;
import org.jnosql.diana.api.column.ColumnCondition;

abstract class BaseQueryBuilder {
    protected String name;
    protected boolean negate;
    protected boolean and;
    protected ColumnCondition condition;

    BaseQueryBuilder() {
    }

    protected <T> void eqImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.eq(Column.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void gtImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.gt(Column.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected void likeImpl(String value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.like(Column.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void ltImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.lt(Column.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void lteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.lte(Column.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void gteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        ColumnCondition newCondition = ColumnCondition.gte(Column.of(this.name, value));
        this.appendCondition(newCondition);
    }

    protected <T> void betweenImpl(T valueA, T valueB) {
        Objects.requireNonNull(valueA, "valueA is required");
        Objects.requireNonNull(valueB, "valueB is required");
        ColumnCondition newCondition = ColumnCondition.between(Column.of(this.name, Arrays.asList(valueA, valueB)));
        this.appendCondition(newCondition);
    }

    protected <T> void inImpl(Iterable<T> values) {
        Objects.requireNonNull(values, "values is required");
        ColumnCondition newCondition = ColumnCondition.in(Column.of(this.name, values));
        this.appendCondition(newCondition);
    }

    protected void appendCondition(ColumnCondition newCondition) {
        if (this.negate) {
            newCondition = newCondition.negate();
        }
        this.condition = Objects.nonNull(this.condition) ? (this.and ? this.condition.and(newCondition) : this.condition.or(newCondition)) : newCondition;
        this.negate = false;
        this.name = null;
    }
}

