/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.column.ColumnCondition;
import org.jnosql.diana.api.column.ColumnQuery;
import org.jnosql.diana.api.column.query.ReadOnlyColumnCondition;

class DefaultColumnQuery
implements ColumnQuery {
    private final long maxResults;
    private final long firstResult;
    private final String columnFamily;
    private final List<String> columns;
    private final List<Sort> sorts;
    private final ColumnCondition condition;

    DefaultColumnQuery(long maxResults, long firstResult, String columnFamily, List<String> columns, List<Sort> sorts, ColumnCondition condition) {
        this.maxResults = maxResults;
        this.firstResult = firstResult;
        this.columnFamily = columnFamily;
        this.columns = columns;
        this.sorts = sorts;
        this.condition = Optional.ofNullable(condition).map(ReadOnlyColumnCondition::new).orElse(null);
    }

    @Override
    public long getLimit() {
        return this.maxResults;
    }

    @Override
    public long getSkip() {
        return this.firstResult;
    }

    @Override
    public String getColumnFamily() {
        return this.columnFamily;
    }

    @Override
    public Optional<ColumnCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    @Override
    public List<String> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public List<Sort> getSorts() {
        return Collections.unmodifiableList(this.sorts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnQuery)) {
            return false;
        }
        ColumnQuery that = (ColumnQuery)o;
        return this.maxResults == that.getLimit() && this.firstResult == that.getSkip() && Objects.equals(this.columnFamily, that.getColumnFamily()) && Objects.equals(this.columns, that.getColumns()) && Objects.equals(this.sorts, that.getSorts()) && Objects.equals(this.condition, that.getCondition().orElse(null));
    }

    public int hashCode() {
        return Objects.hash(this.maxResults, this.firstResult, this.columnFamily, this.columns, this.sorts, this.condition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultColumnQuery{");
        sb.append("maxResults=").append(this.maxResults);
        sb.append(", firstResult=").append(this.firstResult);
        sb.append(", columnFamily='").append(this.columnFamily).append('\'');
        sb.append(", columns=").append(this.columns);
        sb.append(", sorts=").append(this.sorts);
        sb.append(", condition=").append(this.condition);
        sb.append('}');
        return sb.toString();
    }
}

