/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jnosql.diana.api.column.ColumnCondition;
import org.jnosql.diana.api.column.ColumnDeleteQuery;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnFamilyManager;
import org.jnosql.diana.api.column.ColumnFamilyManagerAsync;
import org.jnosql.diana.api.column.ColumnObserverParser;
import org.jnosql.diana.api.column.ColumnPreparedStatement;
import org.jnosql.diana.api.column.ColumnPreparedStatementAsync;
import org.jnosql.diana.api.column.query.CacheQuery;
import org.jnosql.diana.api.column.query.Conditions;
import org.jnosql.diana.api.column.query.DefaultColumnDeleteQuery;
import org.jnosql.diana.api.column.query.DefaultColumnPreparedStatement;
import org.jnosql.diana.api.column.query.DefaultColumnPreparedStatementAsync;
import org.jnosql.diana.api.column.query.Params;
import org.jnosql.query.DeleteQuery;
import org.jnosql.query.DeleteQuerySupplier;
import org.jnosql.query.QueryException;

final class DeleteQueryParser {
    private final DeleteQuerySupplier selectQuerySupplier = DeleteQuerySupplier.getSupplier();
    private final CacheQuery<ColumnDeleteQuery> cache = new CacheQuery<ColumnDeleteQuery>(this::getQuery);

    DeleteQueryParser() {
    }

    List<ColumnEntity> query(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        ColumnDeleteQuery columnDeleteQuery = this.cache.get(query, observer);
        manager.delete(columnDeleteQuery);
        return Collections.emptyList();
    }

    void queryAsync(String query, ColumnFamilyManagerAsync manager, Consumer<List<ColumnEntity>> callBack, ColumnObserverParser observer) {
        ColumnDeleteQuery columnDeleteQuery = this.cache.get(query, observer);
        manager.delete(columnDeleteQuery, v -> callBack.accept(Collections.emptyList()));
    }

    ColumnPreparedStatement prepare(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        Params params = new Params();
        ColumnDeleteQuery columnDeleteQuery = this.getQuery(query, params, observer);
        return DefaultColumnPreparedStatement.delete(columnDeleteQuery, params, query, manager);
    }

    ColumnPreparedStatementAsync prepareAsync(String query, ColumnFamilyManagerAsync manager, ColumnObserverParser observer) {
        Params params = new Params();
        ColumnDeleteQuery columnDeleteQuery = this.getQuery(query, params, observer);
        return DefaultColumnPreparedStatementAsync.delete(columnDeleteQuery, params, query, manager);
    }

    private ColumnDeleteQuery getQuery(String query, Params params, ColumnObserverParser observer) {
        DeleteQuery deleteQuery = (DeleteQuery)this.selectQuerySupplier.apply((Object)query);
        String columnFamily = observer.fireEntity(deleteQuery.getEntity());
        List<String> columns = deleteQuery.getFields().stream().map(f -> observer.fireField(columnFamily, (String)f)).collect(Collectors.toList());
        ColumnCondition condition = null;
        if (deleteQuery.getWhere().isPresent()) {
            condition = deleteQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).get();
        }
        return new DefaultColumnDeleteQuery(columnFamily, condition, columns);
    }

    private ColumnDeleteQuery getQuery(String query, ColumnObserverParser observer) {
        DeleteQuery deleteQuery = (DeleteQuery)this.selectQuerySupplier.apply((Object)query);
        String columnFamily = observer.fireEntity(deleteQuery.getEntity());
        List<String> columns = deleteQuery.getFields().stream().map(f -> observer.fireField(columnFamily, (String)f)).collect(Collectors.toList());
        ColumnCondition condition = null;
        Params params = new Params();
        if (deleteQuery.getWhere().isPresent()) {
            condition = deleteQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).get();
        }
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultColumnDeleteQuery(columnFamily, condition, columns);
    }
}

