/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jnosql.diana.api.column.ColumnCondition;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnFamilyManager;
import org.jnosql.diana.api.column.ColumnFamilyManagerAsync;
import org.jnosql.diana.api.column.ColumnObserverParser;
import org.jnosql.diana.api.column.ColumnPreparedStatement;
import org.jnosql.diana.api.column.ColumnPreparedStatementAsync;
import org.jnosql.diana.api.column.query.Conditions;
import org.jnosql.diana.api.column.query.DefaultColumnPreparedStatement;
import org.jnosql.diana.api.column.query.DefaultColumnPreparedStatementAsync;
import org.jnosql.diana.api.column.query.Params;
import org.jnosql.query.InsertQuery;
import org.jnosql.query.InsertQuerySupplier;
import org.jnosql.query.QueryException;

final class InsertQueryParser {
    private final InsertQuerySupplier supplier = InsertQuerySupplier.getSupplier();

    InsertQueryParser() {
    }

    List<ColumnEntity> query(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        InsertQuery insertQuery = (InsertQuery)this.supplier.apply((Object)query);
        String columnFamily = insertQuery.getEntity();
        Params params = new Params();
        ColumnEntity entity = this.getEntity(insertQuery, columnFamily, params, observer);
        Optional ttl = insertQuery.getTtl();
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        if (ttl.isPresent()) {
            return Collections.singletonList(manager.insert(entity, (Duration)ttl.get()));
        }
        return Collections.singletonList(manager.insert(entity));
    }

    void queryAsync(String query, ColumnFamilyManagerAsync manager, Consumer<List<ColumnEntity>> callBack, ColumnObserverParser observer) {
        InsertQuery insertQuery = (InsertQuery)this.supplier.apply((Object)query);
        String columnFamily = observer.fireEntity(insertQuery.getEntity());
        Params params = new Params();
        ColumnEntity entity = this.getEntity(insertQuery, columnFamily, params, observer);
        Optional ttl = insertQuery.getTtl();
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        if (ttl.isPresent()) {
            manager.insert(entity, (Duration)ttl.get(), c -> callBack.accept(Collections.singletonList(c)));
        } else {
            manager.insert(entity, c -> callBack.accept(Collections.singletonList(c)));
        }
    }

    ColumnPreparedStatement prepare(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        InsertQuery insertQuery = (InsertQuery)this.supplier.apply((Object)query);
        String columnFamily = observer.fireEntity(insertQuery.getEntity());
        Params params = new Params();
        Optional ttl = insertQuery.getTtl();
        ColumnEntity entity = this.getEntity(insertQuery, columnFamily, params, observer);
        return DefaultColumnPreparedStatement.insert(entity, params, query, ttl.orElse(null), manager);
    }

    ColumnPreparedStatementAsync prepareAsync(String query, ColumnFamilyManagerAsync manager, ColumnObserverParser observer) {
        Params params = new Params();
        InsertQuery insertQuery = (InsertQuery)this.supplier.apply((Object)query);
        String columnFamily = observer.fireEntity(insertQuery.getEntity());
        Optional ttl = insertQuery.getTtl();
        ColumnEntity entity = this.getEntity(insertQuery, columnFamily, params, observer);
        return DefaultColumnPreparedStatementAsync.insert(entity, params, query, ttl.orElse(null), manager);
    }

    private ColumnEntity getEntity(InsertQuery insertQuery, String columnFamily, Params params, ColumnObserverParser observer) {
        ColumnEntity entity = ColumnEntity.of(columnFamily);
        insertQuery.getConditions().stream().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).map(ColumnCondition::getColumn).forEach(entity::add);
        return entity;
    }
}

