/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.column.ColumnCondition;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnFamilyManager;
import org.jnosql.diana.api.column.ColumnFamilyManagerAsync;
import org.jnosql.diana.api.column.ColumnObserverParser;
import org.jnosql.diana.api.column.ColumnPreparedStatement;
import org.jnosql.diana.api.column.ColumnPreparedStatementAsync;
import org.jnosql.diana.api.column.ColumnQuery;
import org.jnosql.diana.api.column.query.CacheQuery;
import org.jnosql.diana.api.column.query.Conditions;
import org.jnosql.diana.api.column.query.DefaultColumnPreparedStatement;
import org.jnosql.diana.api.column.query.DefaultColumnPreparedStatementAsync;
import org.jnosql.diana.api.column.query.DefaultColumnQuery;
import org.jnosql.diana.api.column.query.Params;
import org.jnosql.query.QueryException;
import org.jnosql.query.SelectQuery;
import org.jnosql.query.SelectQuerySupplier;
import org.jnosql.query.Sort;

final class SelectQueryParser {
    private final SelectQuerySupplier selectQuerySupplier = SelectQuerySupplier.getSupplier();
    private final CacheQuery<ColumnQuery> cache = new CacheQuery<ColumnQuery>(this::getColumnQuery);

    SelectQueryParser() {
    }

    List<ColumnEntity> query(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        ColumnQuery columnQuery = this.cache.get(query, observer);
        return manager.select(columnQuery);
    }

    void queryAsync(String query, ColumnFamilyManagerAsync manager, Consumer<List<ColumnEntity>> callBack, ColumnObserverParser observer) {
        ColumnQuery columnQuery = this.cache.get(query, observer);
        manager.select(columnQuery, callBack);
    }

    ColumnPreparedStatement prepare(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        Params params = new Params();
        SelectQuery selectQuery = (SelectQuery)this.selectQuerySupplier.apply((Object)query);
        ColumnQuery columnQuery = this.getColumnQuery(params, selectQuery, observer);
        return DefaultColumnPreparedStatement.select(columnQuery, params, query, manager);
    }

    ColumnPreparedStatementAsync prepareAsync(String query, ColumnFamilyManagerAsync manager, ColumnObserverParser observer) {
        Params params = new Params();
        SelectQuery selectQuery = (SelectQuery)this.selectQuerySupplier.apply((Object)query);
        ColumnQuery columnQuery = this.getColumnQuery(params, selectQuery, observer);
        return DefaultColumnPreparedStatementAsync.select(columnQuery, params, query, manager);
    }

    private ColumnQuery getColumnQuery(String query, ColumnObserverParser observer) {
        SelectQuery selectQuery = (SelectQuery)this.selectQuerySupplier.apply((Object)query);
        String columnFamily = observer.fireEntity(selectQuery.getEntity());
        long limit = selectQuery.getLimit();
        long skip = selectQuery.getSkip();
        List<String> columns = selectQuery.getFields().stream().map(f -> observer.fireField(columnFamily, (String)f)).collect(Collectors.toList());
        List<Sort> sorts = selectQuery.getOrderBy().stream().map(s -> this.toSort((org.jnosql.query.Sort)s, observer, columnFamily)).collect(Collectors.toList());
        ColumnCondition condition = null;
        Params params = new Params();
        if (selectQuery.getWhere().isPresent()) {
            condition = selectQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).get();
        }
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultColumnQuery(limit, skip, columnFamily, columns, sorts, condition);
    }

    private ColumnQuery getColumnQuery(Params params, SelectQuery selectQuery, ColumnObserverParser observer) {
        String columnFamily = observer.fireEntity(selectQuery.getEntity());
        long limit = selectQuery.getLimit();
        long skip = selectQuery.getSkip();
        List<String> columns = selectQuery.getFields().stream().map(f -> observer.fireField(columnFamily, (String)f)).collect(Collectors.toList());
        List<Sort> sorts = selectQuery.getOrderBy().stream().map(s -> this.toSort((org.jnosql.query.Sort)s, observer, columnFamily)).collect(Collectors.toList());
        ColumnCondition condition = null;
        if (selectQuery.getWhere().isPresent()) {
            condition = selectQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).get();
        }
        return new DefaultColumnQuery(limit, skip, columnFamily, columns, sorts, condition);
    }

    private Sort toSort(org.jnosql.query.Sort sort, ColumnObserverParser observer, String entity) {
        return Sort.of((String)observer.fireField(entity, sort.getName()), (Sort.SortType)(sort.getType().equals((Object)Sort.SortType.ASC) ? Sort.SortType.ASC : Sort.SortType.DESC));
    }
}

