/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.column.query;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jnosql.diana.api.column.ColumnCondition;
import org.jnosql.diana.api.column.ColumnEntity;
import org.jnosql.diana.api.column.ColumnFamilyManager;
import org.jnosql.diana.api.column.ColumnFamilyManagerAsync;
import org.jnosql.diana.api.column.ColumnObserverParser;
import org.jnosql.diana.api.column.ColumnPreparedStatement;
import org.jnosql.diana.api.column.ColumnPreparedStatementAsync;
import org.jnosql.diana.api.column.query.Conditions;
import org.jnosql.diana.api.column.query.DefaultColumnPreparedStatement;
import org.jnosql.diana.api.column.query.DefaultColumnPreparedStatementAsync;
import org.jnosql.diana.api.column.query.Params;
import org.jnosql.query.QueryException;
import org.jnosql.query.UpdateQuery;
import org.jnosql.query.UpdateQuerySupplier;

final class UpdateQueryParser {
    private final UpdateQuerySupplier supplier = UpdateQuerySupplier.getSupplier();

    UpdateQueryParser() {
    }

    List<ColumnEntity> query(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        UpdateQuery updateQuery = (UpdateQuery)this.supplier.apply((Object)query);
        Params params = new Params();
        ColumnEntity entity = this.getEntity(params, updateQuery, observer);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return Collections.singletonList(manager.update(entity));
    }

    void queryAsync(String query, ColumnFamilyManagerAsync manager, Consumer<List<ColumnEntity>> callBack, ColumnObserverParser observer) {
        UpdateQuery updateQuery = (UpdateQuery)this.supplier.apply((Object)query);
        Params params = new Params();
        ColumnEntity entity = this.getEntity(params, updateQuery, observer);
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        manager.update(entity, c -> callBack.accept(Collections.singletonList(c)));
    }

    ColumnPreparedStatement prepare(String query, ColumnFamilyManager manager, ColumnObserverParser observer) {
        Params params = new Params();
        UpdateQuery updateQuery = (UpdateQuery)this.supplier.apply((Object)query);
        ColumnEntity entity = this.getEntity(params, updateQuery, observer);
        return DefaultColumnPreparedStatement.update(entity, params, query, manager);
    }

    ColumnPreparedStatementAsync prepareAsync(String query, ColumnFamilyManagerAsync manager, ColumnObserverParser observer) {
        Params params = new Params();
        UpdateQuery updateQuery = (UpdateQuery)this.supplier.apply((Object)query);
        ColumnEntity entity = this.getEntity(params, updateQuery, observer);
        return DefaultColumnPreparedStatementAsync.update(entity, params, query, manager);
    }

    private ColumnEntity getEntity(Params params, UpdateQuery updateQuery, ColumnObserverParser observer) {
        String columnFamily = observer.fireEntity(updateQuery.getEntity());
        ColumnEntity entity = ColumnEntity.of(columnFamily);
        updateQuery.getConditions().stream().map(c -> Conditions.getCondition(c, params, observer, columnFamily)).map(ColumnCondition::getColumn).forEach(entity::add);
        return entity;
    }
}

