/*
 *  Copyright (c) 2017 Otávio Santana and others
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   and Apache License v2.0 which accompanies this distribution.
 *   The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 *   and the Apache License v2.0 is available at http://www.opensource.org/licenses/apache2.0.php.
 *
 *   You may elect to redistribute this code under either of these licenses.
 *
 *   Contributors:
 *
 *   Otavio Santana
 */

/**
 * In computing, Hazelcast is an open source in-memory data grid based on Java. It is also the name of the company
 * developing the product. The Hazelcast company is funded by venture capital.
 * In a Hazelcast grid, data is evenly distributed among the nodes of a computer cluster, allowing for horizontal
 * scaling of processing and available storage. Backups are also distributed among nodes to protect against failure
 * of any single node. Hazelcast provides central, predictable scaling of applications through in-memory
 * access to frequently used data and across an elastically scalable data grid. These techniques reduce
 * the sql load on databases and improve speed.
 * Hazelcast can run on-premise, in the cloud (Amazon Web Services,
 * Microsoft Azure, Cloud Foundry, OpenShift), virtually (VMWare),
 * and in Docker containers. Hazelcast offers technology integrations for multiple cloud configuration and deployment
 * technologies, including Apache jclouds, Consul, etcd, Eureka, Kubernetes, and Zookeeper. The Hazelcast Cloud Discovery
 * Service Provider Interface (SPI) enables cloud-based or on-premise nodes to auto-discover each other.
 */
package org.jnosql.diana.hazelcast;