/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.hazelcast.key;

import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.KeyValueEntity;
import org.jnosql.diana.hazelcast.key.HazelcastBucketManager;

class DefaultHazelcastBucketManager
implements HazelcastBucketManager {
    private final IMap map;

    DefaultHazelcastBucketManager(IMap map) {
        this.map = map;
    }

    public <K, V> void put(K key, V value) {
        this.map.put(key, value);
    }

    public <K> void put(KeyValueEntity<K> entity) throws NullPointerException {
        this.map.put(entity.getKey(), entity.getValue().get());
    }

    public <K> void put(KeyValueEntity<K> entity, Duration ttl) {
        this.map.put(entity.getKey(), entity.getValue().get(), ttl.toMillis(), TimeUnit.MILLISECONDS);
    }

    public <K> void put(Iterable<KeyValueEntity<K>> entities) throws NullPointerException {
        StreamSupport.stream(entities.spliterator(), false).forEach(this::put);
    }

    public <K> void put(Iterable<KeyValueEntity<K>> entities, Duration ttl) throws NullPointerException, UnsupportedOperationException {
        StreamSupport.stream(entities.spliterator(), false).forEach(kv -> this.put((KeyValueEntity)kv, ttl));
    }

    public <K> Optional<Value> get(K key) throws NullPointerException {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(Value.of((Object)value));
    }

    public <K> Iterable<Value> get(Iterable<K> keys) throws NullPointerException {
        return StreamSupport.stream(keys.spliterator(), false).map(arg_0 -> ((IMap)this.map).get(arg_0)).filter(Objects::nonNull).map(Value::of).collect(Collectors.toList());
    }

    public <K> void remove(K key) {
        this.map.remove(key);
    }

    public <K> void remove(Iterable<K> keys) {
        StreamSupport.stream(keys.spliterator(), false).forEach(this::remove);
    }

    public void close() {
    }

    @Override
    public Collection<Value> sql(String query) throws NullPointerException {
        Objects.requireNonNull(query, "sql is required");
        return this.sql((Predicate)new SqlPredicate(query));
    }

    @Override
    public Collection<Value> sql(String query, Map<String, Object> params) throws NullPointerException {
        Objects.requireNonNull(query, "sql is required");
        Objects.requireNonNull(params, "params is required");
        StringBuilder finalQuery = new StringBuilder(query);
        Consumer<Map.Entry> consumer = e -> {
            String key = ":" + (String)e.getKey();
            int indexOf = query.indexOf(key);
            finalQuery.replace(indexOf, indexOf + key.length(), e.getValue().toString());
        };
        params.entrySet().forEach(consumer);
        return this.sql((Predicate)new SqlPredicate(finalQuery.toString()));
    }

    @Override
    public <K, V> Collection<Value> sql(Predicate<K, V> predicate) throws NullPointerException {
        Objects.requireNonNull(predicate, "predicate is required");
        Collection values = this.map.values(predicate);
        return values.stream().map(Value::of).collect(Collectors.toList());
    }
}

