/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.hazelcast.key;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import org.jnosql.diana.hazelcast.key.DefaultHazelcastBucketManager;
import org.jnosql.diana.hazelcast.key.HazelcastBucketManager;
import org.jnosql.diana.hazelcast.key.HazelcastBucketManagerFactory;

class DefaultHazelcastBucketManagerFactory
implements HazelcastBucketManagerFactory {
    private final HazelcastInstance hazelcastInstance;

    DefaultHazelcastBucketManagerFactory(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public HazelcastBucketManager getBucketManager(String bucketName) {
        Objects.requireNonNull(bucketName, "bucketName is required");
        return new DefaultHazelcastBucketManager(this.hazelcastInstance.getMap(bucketName));
    }

    public <T> List<T> getList(String bucketName, Class<T> clazz) {
        Objects.requireNonNull(bucketName, "bucketName is required");
        Objects.requireNonNull(clazz, "clazz is required");
        return this.hazelcastInstance.getList(bucketName);
    }

    public <T> Set<T> getSet(String bucketName, Class<T> clazz) {
        Objects.requireNonNull(bucketName, "bucketName is required");
        Objects.requireNonNull(clazz, "clazz is required");
        return this.hazelcastInstance.getSet(bucketName);
    }

    public <T> Queue<T> getQueue(String bucketName, Class<T> clazz) {
        Objects.requireNonNull(bucketName, "bucketName is required");
        Objects.requireNonNull(clazz, "clazz is required");
        return this.hazelcastInstance.getQueue(bucketName);
    }

    public <K, V> Map<K, V> getMap(String bucketName, Class<K> keyValue, Class<V> valueValue) {
        Objects.requireNonNull(bucketName, "bucketName is required");
        Objects.requireNonNull(keyValue, "keyValue is required");
        Objects.requireNonNull(valueValue, "valueValue is required");
        return this.hazelcastInstance.getMap(bucketName);
    }

    public void close() {
    }

    @Override
    public <T> List<T> getList(String bucketName) throws UnsupportedOperationException, NullPointerException {
        Objects.requireNonNull(bucketName, "bucketName is required");
        return this.hazelcastInstance.getList(bucketName);
    }

    @Override
    public <T> Set<T> getSet(String bucketName) throws UnsupportedOperationException, NullPointerException {
        Objects.requireNonNull(bucketName, "bucketName is required");
        return this.hazelcastInstance.getSet(bucketName);
    }

    @Override
    public <T> Queue<T> getQueue(String bucketName) throws UnsupportedOperationException, NullPointerException {
        Objects.requireNonNull(bucketName, "bucketName is required");
        return this.hazelcastInstance.getQueue(bucketName);
    }

    @Override
    public <K, V> Map<K, V> getMap(String bucketName) throws UnsupportedOperationException, NullPointerException {
        Objects.requireNonNull(bucketName, "bucketName is required");
        return this.hazelcastInstance.getMap(bucketName);
    }

    @Override
    public IAtomicLong getAtomicLong(String bucketName) throws NullPointerException {
        Objects.requireNonNull(bucketName, "bucketName is required");
        return this.hazelcastInstance.getAtomicLong(bucketName);
    }
}

