/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.micronaut.autoconfigure.metrics;

import io.micronaut.runtime.event.annotation.EventListener;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.jobrunr.server.metrics.BackgroundJobServerMetricsBinder;
import org.jobrunr.storage.metrics.StorageProviderMetricsBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JobRunrMetricsStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRunrMetricsStarter.class);
    private final Optional<StorageProviderMetricsBinder> storageProviderMetricsBinder;
    private final Optional<BackgroundJobServerMetricsBinder> backgroundJobServerMetrics;

    public JobRunrMetricsStarter(Optional<StorageProviderMetricsBinder> storageProviderMetricsBinder, Optional<BackgroundJobServerMetricsBinder> backgroundJobServerMetrics) {
        this.storageProviderMetricsBinder = storageProviderMetricsBinder;
        this.backgroundJobServerMetrics = backgroundJobServerMetrics;
    }

    @EventListener
    void startup(ServerStartupEvent event) {
        this.storageProviderMetricsBinder.ifPresent(x -> LOGGER.debug("JobRunr StorageProvider MicroMeter Metrics enabled"));
        this.backgroundJobServerMetrics.ifPresent(x -> LOGGER.debug("JobRunr BackgroundJobServer MicroMeter Metrics enabled"));
    }
}

