/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import io.micronaut.inject.ExecutableMethod;
import java.lang.reflect.Method;
import java.time.ZoneId;
import java.util.ArrayList;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.annotations.Recurring;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.scheduling.Schedule;
import org.jobrunr.scheduling.cron.CronExpression;
import org.jobrunr.scheduling.interval.Interval;
import org.jobrunr.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunrRecurringJobScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRunrRecurringJobScheduler.class);
    private final JobScheduler jobScheduler;

    public JobRunrRecurringJobScheduler(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public void schedule(ExecutableMethod<?, ?> method) {
        if (this.hasParametersOutsideOfJobContext(method.getTargetMethod())) {
            throw new IllegalStateException("Methods annotated with " + Recurring.class.getName() + " can only have zero parameters or a single parameter of type JobContext.");
        }
        String id = this.getId(method);
        String cron = this.getCron(method);
        String interval = this.getInterval(method);
        if (StringUtils.isNullOrEmpty((String)cron) && StringUtils.isNullOrEmpty((String)interval)) {
            throw new IllegalArgumentException("Either cron or interval attribute is required.");
        }
        if (StringUtils.isNotNullOrEmpty((String)cron) && StringUtils.isNotNullOrEmpty((String)interval)) {
            throw new IllegalArgumentException("Both cron and interval attribute provided. Only one is allowed.");
        }
        if ("-".equals(cron) || "-".equals(interval)) {
            if (id == null) {
                LOGGER.warn("You are trying to disable a recurring job using placeholders but did not define an id.");
            } else {
                this.jobScheduler.deleteRecurringJob(id);
            }
        } else {
            JobDetails jobDetails = this.getJobDetails(method);
            ZoneId zoneId = this.getZoneId(method);
            if (StringUtils.isNotNullOrEmpty((String)cron)) {
                this.jobScheduler.scheduleRecurrently(id, jobDetails, (Schedule)CronExpression.create((String)cron), zoneId);
            } else {
                this.jobScheduler.scheduleRecurrently(id, jobDetails, (Schedule)new Interval(interval), zoneId);
            }
        }
    }

    private boolean hasParametersOutsideOfJobContext(Method method) {
        if (method.getParameterCount() == 0) {
            return false;
        }
        if (method.getParameterCount() > 1) {
            return true;
        }
        return !method.getParameterTypes()[0].equals(JobContext.class);
    }

    private String getId(ExecutableMethod<?, ?> method) {
        return method.stringValue(Recurring.class, "id").orElse(null);
    }

    private String getCron(ExecutableMethod<?, ?> method) {
        return method.stringValue(Recurring.class, "cron").orElse(null);
    }

    private String getInterval(ExecutableMethod<?, ?> method) {
        return method.stringValue(Recurring.class, "interval").orElse(null);
    }

    private JobDetails getJobDetails(ExecutableMethod<?, ?> method) {
        ArrayList<JobParameter> jobParameters = new ArrayList<JobParameter>();
        if (method.getTargetMethod().getParameterCount() == 1 && method.getTargetMethod().getParameterTypes()[0].equals(JobContext.class)) {
            jobParameters.add(JobParameter.JobContext);
        }
        JobDetails jobDetails = new JobDetails(method.getTargetMethod().getDeclaringClass().getName(), null, method.getTargetMethod().getName(), jobParameters);
        jobDetails.setCacheable(true);
        return jobDetails;
    }

    private ZoneId getZoneId(ExecutableMethod<?, ?> method) {
        return method.stringValue(Recurring.class, "zoneId").map(ZoneId::of).orElse(ZoneId.systemDefault());
    }
}

